/***************************************************************************
 *   Copyright (C) 2004 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SNMP_H
#define SNMP_H

#include "structs.h"
#include "gldefs.h"
#include "ioctldef.h"
#include "csnmp.h"

#ifdef SNMP_DRIVER_BUILD

/* 
 * Driver definitions
 */
#define DRIVER_VERSION_MAJOR			0
#define DRIVER_VERSION_MINOR			0
#define DRIVER_VERSION_SUBMINOR			1

#define DRIVER_CONFIG_FILE				"snmp_sinlinexl.conf"
#define DRIVER_UPS_FAMILY				"SNMP Management Card for SINLINE XL"
#define DRIVER_UPS_PREFIX				""

#define UPS_MAX_MODELS					0
/* 
 * Licznik pozycji ustawie z drivera
 */
#define INT_MAX_SETUPITEMS				0


/* 
 * definicje tablic - sprzetowe
 */
#include "sinlinexl_ups.h"

typedef enum eValType {
	ET_BYTE,
	ET_INT,
	ET_UINT,
	ET_STRING,
	ET_LONG,
	ET_ULONG
} evtype;

/*
 * Structures
 */
typedef struct tagStatMap {
	char*	name;			/* config name */
	evtype	type;			/* is it an integral type? */
	void*	res_addr;		/* address of variable where the result should be stored */
	void*	div_addr;		/* address of variable where the divider should be stored */
} stat_map, *lpstat_map;

// maximum number of stat objects
#define MAX_GET_STATS		64
#define MAX_SET_STATS		64

// single object "stat"
// limits defs
#define MAX_STATID			64
#define MAX_STATNAME		32
#define MAX_STATMAP			256
#define MAX_STATOID			128

// request id used in frame
#define MON_REQUESTID		0xAA

// structure
typedef struct tagSnmpstat
{
	char			szId[MAX_STATID];
	char			szMap[MAX_STATMAP];
	char			szOID[MAX_STATOID];
	SNMP_OID		oid;
	int				iType;
	int				iSize;
	unsigned char	bDataBuff[SNMP_MAX_PDU_LENGTH];
	int				iErrorStatus;
	unsigned long	ulMode;
} snmpstat, *lpsnmpstat;

// main driver config
typedef struct _sdrv_config_
{
	/* struct size used for versioning */
	unsigned long	ulSize;
	char 			szDevAddress[MAX_PATHBUFF];
	unsigned int	uiPortNumber;
	char			szReadPassword[127];
	char			szWritePassword[127];
	char			szTrapPassword[127];
	// params stats
	int				statsGetCount;
	snmpstat		statsGet[MAX_GET_STATS];
	// setup stats
	int				statsSetCount;
	snmpstat		statsSet[MAX_SET_STATS];
	// ping stat
	snmpstat		pingStat;
	char			pingStatVal[256];
	
	unsigned int	uiOpTimeout;
	
	// user settings
	unsigned int	uiLowBatteryTreshold;
	
	supsp			params;
	supssp			setup;
	unsigned long	ulUpsState;

} sdrv_config, *lpsdrv_config;

/* 
 * Function prototypes - internal
 */
int		SNMP_DoInit(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoUnInit(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetConfigFileName(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoAutoConfigure(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoConfigure(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoSetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoSetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetUpsState(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoSetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetUpsParams(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoSetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoSetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetDriverInfo(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetUpsCharacteristics(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetExtendedError(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoTestUpsLink(void *lpvBuff, int *lpiBuffSize);
//int		SNMP_DoGetUPSStructures(eups_tab eType, void *lpvBuff, int *lpiBuffSize);
//int		SNMP_DoSetUPSStructures(eups_tab eType, void *lpvBuff, int *lpiBuffSize, int *lpiBuffErrPos);
int		SNMP_DoGetUpsCharacteristicMask(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetUpsCharacteristic(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetConfigParamsCount(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoSetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoSetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoUpdateConfig(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoGetDriverMode(void *lpvBuff, int *lpiBuffSize);
int		SNMP_DoUpsShutdown(void *lpvBuff, int *lpiBuffSize);

int		SNMP_ReadConfig();
int		SNMP_CreateStatTable(CConf& pc, sdrv_config& sc);
int		SNMP_ReleaseStatTable(sdrv_config& sc);

int		SNMP_StatMap_ParseByType(stat_map *sm, void *lpvBuff);
int		SNMP_StatMap_Compile(stat_map *sm, sdrv_config& sc);
int		SNMP_ReadGetStats(sdrv_config& sc);
int		SNMP_ReadPingStat(sdrv_config& sc);
int		SNMP_ReadSetStats(sdrv_config& sc);

#else /*SNMP_DRIVER_BUILD*/

int		snmp_ioctl(long lCommand, void *lpvBuff, int *lpiBuffSize);

#endif/*SNMP_DRIVER_BUILD*/

#endif/*SNMP_H*/
