/*  (c)Copyright Dariusz Dziel, EVER SP. Z O.O.	          */
/*  Projekt : SINUS						                  */
/*  File name:	 ups.h					             	  */
/*  Version:	 1.0					             	  */
/*--------------------------------------------------------*/
/*--------------------------------------------------------*/
/* DATA : 14052003					                      */
/*--------------------------------------------------------*/
/*	OPIS:							 					  */	
/*  definicje tablic dla sterowania UPS-a			      */
/*--------------------------------------------------------*/

/*UNIKALNY IDENTYFIKATOR OPROGRAMOWANIA*/ 
/*PS 28 listopad 2002*/      
/* DD wersja specjalna 2.0 dla SINLINE1000 + 6 x 2 x 7Ah modu 24V */
#define MAGIC_NUMBER_VALUE  0x2000   /* xxxx.xxxx - wersja soft, xxxxxxxx - nr edycji wersji soft */
/* 0x1044 - 1b68 ostatnia dla klienta */
/* 0x1045 - 1b69 wersja dla test� w EMC: ESD i BURST w IL kodowanie bledu wewnetrznego*/
/* 0x2000 - 2b0 wersja dla dla SINLINE1000 + 6 x 2 x 7Ah modu 24V */
// ---------------------------------------------------------------
//	Definicje tablic informacyjno-kontrolnych dla UPS
// ---------------------------------------------------------------
//Definicja stalych
/*#define AUTOTEST_ON		1  autotet online */
#define UPS_ON			16
#define UPS_OFF			65535 - 16
#define BUZZER_ON		64
#define BUZZER_OFF		65535 - 64
#define KOM_STAN_ON		1024  
#define UPS_STANDBY     8  

#define AKU_FAIL        0x0200
#define MODULE_FAIL     0x0001                                        
#define TEMP_TO_LOW     0x0002
#define TEMP_TO_HIGH    0x0004
#define INVERTER_FAIL   0x0008
#define INTERNAL_ERROR  0x0010  

#define PRACA_SIECIOWA 	0x8000
#define PRACA_BATERYJNA 0x4000
#define PRACA_STANDBY 	0x2000  
#define PRAC_CZUWANIE 	0x0400 

#define PRACA_AVR_DOWN  0x0800 
#define PRACA_AVR_UP    0x1000   

#define ZWAR_INVERTER 	0x0080
#define PRZEC_INVERTER 	0x0100        

#define CZULOSC			0x2 //	czulosc napieciowa i czestotliwosciowa

#define	MALA_CZULOSC	0x0  // 45 < f < 65, Tzanik = 15ms  
#define	SREDNIA_CZULOSC	0x0F // 45 < f < 55, Tzanik = 3ms  
#define	DUZA_CZULOSC	0xF0 // 49 < f < 51, Tzanik = 1ms  
	


/*************************************************************************************************************/
/* Wszytkie wielkosci napi�iowe,prdowe,mocy i cz�totliwoci podawane w 0,1 jednostki podstawowej			 */

/*************************************************************************************************************/
/* tablice parametrow charakteryzujacych dany model UPS-a   */
/* odczyt - zapis                                           */ 
/*volatile unsigned int UPS_charakter[UPS_CHARAKTER_COUNT]  */

//definicja wielkosci tablicy
#define UPS_CHARAKTER_COUNT 14
//definicja stalych dotyczacych tablicy informacyjnej: UPS_charakterystyka
#define P_WYJ_MAX			0x0		// Moc maksymalna UPS-a w  Watach    

/*zmiana 26-07-2002 */
#define	SKALOWANIE_AKU		0x1     // Stala do dokladnego skalowania akumulatora

#define	DOD_MOD_MAX		 	0x2     // Pojemnosc maksymalna akumulator� zewnatrz
#define	V_DOLNY_MIN			0x3	    // Minimalny prog dolny napiecia
#define	V_DOLNY_MAX			0x4		// Maksymalny prog dolny napiecia 
#define	V_GORNY_MAX			0x5		// Maksymalny prog gorny napiecia							
#define	V_GORNY_MIN			0x6		// Minimalny prog gorny napiecia							

#define	V_AVRUP_MIN			0x7		// Minimalny prog AVR gornego napiecia							
#define	V_AVRDOWN_MAX		0x8		// Maksymalny prog AVR dolnego napiecia							

#define	F_MIN				0x9		// Minimalny prog dolny czestotliwosci granica ustawien
#define	F_MAX				0xa		// Maksymalny prog gorny czestotliwosci granica ustawien							
#define V_WYJ_NOM		    0xb     // napiecie wyjsciowe nominalne
#define V_AKU_FULL 			0xc	    // Napiecie pelnego naladowania baterii UPS-a

/* zmiana 14-11-2002 */

#define SKALOWANIE_MOCY    0xd      // Stala do dokladnego skalowania wskazania mocy
                                    // ze wzgledu na fabryczna niedokladnosc 
                                    // przekladnika pradowego     


//definicja wielkosci tablicy                                                       
#define UPS_SPRZET_COUNT 16                                                       
/*volatile unsigned int UPS_sprzet[UPS_SPRZET_COUNT]       */
/* odczyt - zapis                                           */ 
//definicja stalych dotyczacych tablicy informacyjnej: UPS_sprzet
#define I_KONC_MAX				0x0		// Prad maksymalny koncowki UPS-a  
#define V_AKU_MAX 				0x01	// Napiecie maksymalne baterii UPS-a
#define	V_AKU_MIN				0x02    // Napiecie minimalne baterii UPS-a
#define	TEMP_KONC_MAX			0x03    // Temperatura maksymalna koncowki
#define	TEMP_OTOCZ_MAX			0x04    // Temperatura maksymalna otoczenia 
#define	TEMP_OTOCZ_MIN			0x05    // Temperatura minimalna otoczenia              
#define	CZAS_PRZ_WYJ			0x06	// Czas przekaznika wyjsciowego 
#define	CZAS_PRZ_WYJ_ODP		0x07	// Czas przekaznika wyjsciowego odpuszczanie 
#define	CZAS_PRZ_SIEC_BAT		0x08	// Czas przekaznika siec-bateria 
#define	CZAS_PRZ_SIEC_BAT_ODP	0x09	// Czas przekaznika siec-bateria odpuszczanie 
#define	CZAS_PRZ_AVRDN			0x0a	// Czas przekaznika AVRdown 
#define	CZAS_PRZ_AVRDN_ODP		0x0b	// Czas przekaznika AVRdown odpuszczanie 
#define	CZAS_PRZ_AVRUP			0x0c	// Czas przekaznika AVRup 
#define	CZAS_PRZ_AVRUP_ODP		0x0d	// Czas przekaznika AVRup odpuszczanie 
#define REZYST_AKU_MAX      	0x0e    // Maksymalna dopuszczalna rezystancja akumulator� wewntrz w mOmach
#define REZYST_ALL_AKU_MAX	  	0x0f    // Maksymalna dopuszczalna rezystancja akumulator� wszystkich
                        

/**************************************************************************/
/*tablica informacyjna                                   */
/* tylko odczyt 										 */
/*volatile unsigned int UPS_inf[UPS_INF_COUNT];          */
//definicja wielkosci           
#define UPS_INF_COUNT 11
//definicja stalych dotyczacych tablicy informacyjnej: UPS_informacja
#define	V_WYJ			0x0	 // we Voltach skut
#define	V_WEJ			0x1  // we Voltach skut
#define	F_WEJ			0x2  // w 0.1Hz
#define	V_AKU			0x3	 // w 0.1V srednie						 
#define	OBCIAZENIE		0x4	 // w %
#define	POJ_AKU			0x5  // w %
#define	DOD_MOD			0x6	//	ilosc dodatkowych modulow bateryjnych w sztukach (max 4)							
#define	TRYB_PRACY		0x7	//okresla stan UPS-a
							//	15	-	praca sieciowa
							//	14	-	praca bateryjna
							//	13	-	praca stand by
							//	12	-	AVR UP   - podwyzszajacy
							//	11	-	AVR DOWN - obnizajacy 
							//	10	-	praca czuwanie (tylko ladowanie na sieci) 
							//	9	-	akumulator do wyrzucenia
							//	8	-	przeciazenie
							//	7	-	zwarcie
							//	6	-	
							//	5	-	
							//	4	-	Blad wewnterzny
							//	3	-	Inverter nie dziala
							//	2	-	Temperatura pracy za wysoka
							//	1	-	Temperatura pracy za niska
							//	0	-	Zle moduly dodatkowe

#define	CZAS_PRACY		0x8	//czas pracy UPS-a na dwoch bajtach w minutach
#define	TEMPERATURA		0x9 //temperatura koncowki w stopniach  
#define	TEMPERATURA_OT	0xA //temperatura otoczenia w stopniach 

/**************************************************************************************************************/
/*tablica kontrolno-konfiguracyjna					*/         
/* zapis - odczyt							    	*/
/*volatile unsigned int UPS_setup[UPS_SETUP_COUNT]  */
//definicja wielkosci
#define UPS_SETUP_COUNT  8
//definicja stalych dotyczacych tablicy kontrolnej: UPS_kontrola
#define	KONTROLA_PRACY	0x0	//	komorka zawiera rozne flagi do 
							//	kontrolowania pracy UPS-a
							//	15	-	
							//	14	-	
							//	13	-	
							//	12	-	
							//	11	-	
							//	10	-	
							//	9	-	
							//	8	-	
							//	7	-	
							//	6	-	buzer ON-1 OFF-0
							//	5	-	
							//	4	-	UPS ON-1, OFF-0 
							//	3	-	UPS STANDBY - 1  
							//	2	-	
							//	1	-	
							//	0	-	

#define	F_WYJ		0x1	//	w 0.1Hz czestotliwosc napiecia wyjsciowego
#define	CZULOSC		0x2	//	czulosc napieciowa i czestotliwosciowa
						//	0x00 - mala
						//	0x0F - srednia
						//	0xF0 - duza		
#define	V_DOLNY			0x3	//	prog dolny napiecia
#define	V_GORNY			0x4	//	prog gorny napiecia							
#define	V_DOLNY_AVR		0x5	//	prog dolny napiecia AVR
#define	V_GORNY_AVR		0x6	//	prog gorny napiecia AVR
#define OPOZNIENIE_STANDBY	0x7	// czas do przelaczenia UPSa w standby po rozkazie
								// flaga UPS STANDBY w sekundach

/*	trzeba to wepchnac do ktorej tablicy sprzetowej

                        // wspolczynniki skalujace od 58 do 70 
						
#define SKALUJ_AKU				0x7    // wspolczynnik skalujacy dla napiecia akumulatora  
#define SKALUJ_WYJ_U			0x8    // wspolczynnik skalujacy dla napiecia wyjsciowego
#define SKALUJ_WEJ_U			0x9    // wspolczynnik skalujacy dla napiecia wejsciowego 
#define SKALUJ_U12VOLT_IN		0xA    // wspolczynnik skalujacy dla napiecia 12V in 
#define SKALUJ_U12VOLT			0xB    // wspolczynnik skalujacy dla napiecia 12V out
#define SKALUJ_U_T_OTOCZ		0xC    // wspolczynnik skalujacy dla temperatury otoczenia
#define SKALUJ_U_T_TRANZ		0xD    // wspolczynnik skalujacy dla temperatury tranzystorow
#define SKALUJ_MOD_BAT			0xE    // wspolczynnik skalujacy dla pomiaru typu modulow
#define SKALUJ_U1_65V			0xF    // wspolczynnik skalujacy dla pomiaru Vref / 2
*/


/**********************************************************************************************************************/
/*tablica funkcji specjalnych							*/
/*zapis odczyt											*/
/*volatile unsigned int UPS_special[UPS_SPECIAL_COUNT] */

//definicja wielkosci
#define UPS_SPECIAL_COUNT 16		
#define UPS_special_zapis_count_max 12


#define	L_ZANIKOW		0x0	//	zlicza ilosc zanikow							
#define	L_SPADKOW		0x1	//	zlicza ilosc spadkow
#define	L_AVRUP			0x2	//	zlicza ilosc przelaczen AVR_UP
#define	L_AVRDOWN		0x3	//	zlicza ilosc przelaczen AVR_DOWN
#define	L_ZWARC			0x4	//	zlicza ilosc zwarc
#define	L_PRZECIAZEN	0x5	//	zlicza ilosc przeciazen 
#define	L_ROZLADOWAN	0x6	//	zlicza ilosc calkowitych rozladowan, przejscie od za malego akum 
#define	L_MAX_TEMP		0x7	//	zlicza ilosc przekroczenia temperatury otoczenia
#define L_MIN_TEMP		0x8 //  zlicza ilosc przekroczenia temperatury minimalnej otoczenia
#define	L_MAX_TEMP_K	0x9 //  zlicza ilosc przekroczenia temperatury koncowki 
	
#define R_AKU_FULL		0xA    // rezystancja w mOmach akumulatora naladowanego z testu aku

#define PUSTY           0xB	   // pusty do wykorzystania	                              
                              
#define	ID_TYP_VHW			0xC	//	xxxx.xxxx 					xxxx.xxxx
								//	|_>typ   					|_>ver.hard
								//     xxxx		.	xxxx		
							    //     rodzina:     model:
							    //	   0 - sinus	1	-	700
							    //					2	-	1000
							    //					3	-	1500
							    //					4	-	2000
								//					5	-	2500							    
							    //					6	-	3000
							
#define	ID_DATA				0xD	//	xxxx.xxxx 		xxxx.xxxx
								// 	|_>rok i tydzien w kodzie BCD
							
#define	ID_NUMER_UPS 		0xE	//	xxxxxxxxxxxxxxxx
								//	|w naturalnym kodzie binarnym
							
#define MAGIC_NUMBER		0xF	//identyfikator oprogramowania
                             	//   xxxx.xxxx 		xxxx.xxxx
								//	 |_>ver.soft 	|_>numer edycji

 							
/*********************************************************************************************************************/



