/***************************************************************************
 *   Property rights (C) 2004-2006 by EVER Sp. z o.o.                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SINLINEXL_H
#define SINLINEXL_H

#include "structs.h"
#include "gldefs.h"
#include "ioctldef.h"
#include <math.h>

#include "ups_defs_p7p9.h"

#ifdef SINLINEXL_DRIVER_BUILD

/* 
 * Driver definitions
 */
#define DRIVER_VERSION_MAJOR			0
#define DRIVER_VERSION_MINOR			0
#define DRIVER_VERSION_SUBMINOR			1

#define DRIVER_BITMAP_FILE				PIX_PATH"/sinlinep9.bmp"
#define DRIVER_CONFIG_FILE				"sinlinexl.conf"

#define UPS_FAMILYP9					0x02
// Modified on july 26 2006
//#define UPS_FAMILYP23					0x03
//#define UPS_FAMILYP25					0x04
#define UPS_FAMILYP23					0x04
#define UPS_FAMILYP25					0x05


#define DRIVER_UPS_PREFIXP9			"SINLINE XL"
#define DRIVER_UPS_PREFIXP25		"SINLINE PRO"
#define DRIVER_UPS_FAMILYP9			DRIVER_UPS_PREFIXP9"\0"
#define DRIVER_UPS_FAMILYP25		DRIVER_UPS_PREFIXP25"\0"

// Licznik pozycji ustawie�z drivera
#define INT_MAX_SETUPITEMS				8
// Identyfikatory ustawie�UPS-a
#define INT_UPSCFG_SERIALCOMM			0
#define INT_UPSCFG_BUZZER				1
#define INT_UPSCFG_FORCE_STANDBY		2
#define INT_UPSCFG_TR_TSH_UPPER			3
#define INT_UPSCFG_TR_TSH_LOWER			4
#define INT_UPSCFG_TR_TSH_AVRTRIM		5
#define INT_UPSCFG_STANDBYDELAY			6
#define INT_UPSCFG_MODULE_NO			7

// Text strings
#define TXT_STAT_PWRFAILURE			"Power failure counter"
#define TXT_STAT_PWRDROP			"Power drop counter"
#define TXT_STAT_PWRINCREASE		"Power increase counter"
#define TXT_STAT_OVERLOAD			"Overload counter"
#define TXT_STAT_SHORT				"Short circuit counter"
#define TXT_STAT_DISCHARGE			"Discharge counter"
#define TXT_STAT_AVRTRIM			"AVR trim counter"
#define TXT_STAT_AVRBOOST			"AVR boost counter"
#define TXT_STAT_OVERHEAT			"Overheat counter"
#define TXT_STAT_OVERLOAD_TIME		"Overload time"
#define TXT_STAT_PWROK_TIME			"Power normal time"
#define TXT_STAT_PWRFAIL_TIME		"Power failure time"
#define TXT_STAT_SYNCLOST			"Synchronization lost counter"
#define TXT_FCTL_CHARGE_H			"Charge counter (higher word)"
#define TXT_FCTL_CHARGE_L			"Charge counter (lower word)"
#define TXT_FCTL_MODULES			"External modules counter"
#define TXT_FCTL_PWRFAIL_TIME_MIN	"Power failure time (min)"
#define TXT_FCTL_OVERLOAD_TIME_SEC	"Overload time (sec)"
#define TXT_FCTL_PWROK_TIME_MIN		"Power normal time (min)"

/* 
 * Kody zawartoci ramek transmisyjnych
 */
#define FRAME_INITCODE					0xD0
#define FRAME_START						0x1F
#define FRAME_CMD_GET					0x0F
#define FRAME_CMD_SET					0xF0
#define FRAME_CMD_SPECIAL				0xFF

/* 
 * Flagi dla KONTROLA_PRACY
 */
#define FLAG_WORKCONTROL_BUZZER		KP_BUZZER
#define FLAG_WORKCONTROL_STANDBY	KP_UPS_STANDBY
#define FLAG_WORKCONTROL_PROGI2		KP_UPS_PROGI2

/* 
 * Macros
#undef FAILED
#define FAILED( var )				(BOOL)((var == 0) ? 0 : 1)

#undef COMMFAIL
#define COMMFAIL( var )				(BOOL)((var == 1) ? 0 : 1)
 */

// firmware'y
#define FIRMWARE_00		0x10

#define FIRMWARE_FIRST	FIRMWARE_00
#define FIRMWARE_LAST	FIRMWARE_00

/* 
 * Structures
 */
typedef struct _sdrv_config_
{
	// struct size used for versioning
	unsigned long	ulSize;
	// serial port configured by user
	int				iSerialPort;
	char			szSerialPort[255];
	// Ups settings
	bool			bAudibleAlarm;
	bool			bForceStandby;
	unsigned int	uiTransferTrsh_Upper;
	unsigned int	uiTransferTrsh_Lower;
	unsigned int	uiTransferTrsh_AVRBoost;
	unsigned int	uiStandbyDelay;
	unsigned int	uiModuleNumber;
	// UPS setup table
	unsigned int	uiUpsConfiguration[ UPS_CONFIGURATION_COUNT ];
	// last operation error number
	int				iConfigError;
	// last operation argument
	int				iConfigErrorArg;

} sdrv_config, *lpsdrv_config;

/* 
 * Enumerators
 */
typedef enum _eups_structs_
{
	EU_INFORMATION		= 1,
	EU_SETUP			= 2,
	EU_STATS			= 3,
	EU_FACTORYCTL		= 4
} eups_structs;

/* 
 * Function prototypes - internal
 */
int		SinlineXL_DoInit(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoUnInit(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoAutoConfigure(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoConfigure(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoSetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoSetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetUpsState(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoSetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetUpsParams(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoSetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoSetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetDriverInfo(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetUpsCharacteristics(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetExtendedError(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoTestUpsLink(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetUPSStructures(eups_structs eType, void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoSetUPSStructures(eups_structs eType, void *lpvBuff, int *lpiBuffSize, int *lpiBuffErrPos);
int		SinlineXL_DoGetUpsCharacteristicMask(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetUpsCharacteristic(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetConfigParamsCount(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoSetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoSetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoUpdateConfig(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoUpsShutdown(void *lpvBuff, int *lpiBuffSize);

int		SinlineXL_DoGetUpsStatisticsCount(void *lpvBuff, int *lpiBuffSize);
int		SinlineXL_DoGetUpsStatistics(void *lpvBuff, int *lpiBuffSize);

int		SinlineXL_DoGetConfigFileName(void *lpvBuff, int *lpiBuffSize);

int		SinlineXL_DoReadConfig();

#else //SINLINEXL_DRIVER_BUILD

int		sinlinexl_ioctl(long lCommand, void *lpvBuff, int *lpiBuffSize);

#endif//SINLINEXL_DRIVER_BUILD

#endif//SINLINEXL_H
