/***************************************************************************
 *   Property rights (C) 2004-2006 by EVER Sp. z o.o.                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _SHMDEFS_H_
#define _SHMDEFS_H_

#include "structs.h"

// Enumerator typ� komend
typedef enum _shm_command_
{
	GET, SET, CMD
} shm_command;

// Enumerator typ� polece�dla komendy CMD
typedef enum _shm_actions_
{
	GET_PARAMS,		// zwr� dane
	UPS_CONFIG,		// konfiguruj UPS'a
	USER_CONFIG,	// konfiguruj zmienne aplikacji
	REINIT,			// reinicjalizuj
	SHUTDOWN,		// Zamknij usug�	SYS_SHUTDOWN,	// Zamknij system
	APPS_SHUTDOWN	// Zamknij aplikacje i zapisz otwarte pliki
} shm_actions;

// Wymiana danych - uniwersalna struktura
typedef struct _shm_exchange_
{
	// info
	shm_command		eCmd;
	shm_actions		eAction;
	
	// dane
	sups_characteristic		suc;
	sups_parameters			sup;
	sups_setup_parameters	susp;
	
	// ups info mask
	unsigned long	ulMask;
	// maks used to determine which UPS states are used from _ups_state_ enumerator
	unsigned long	ulUpsStateMask;
	// flag register used to determine which UPS states is actually set
	unsigned long	ulUpsState;

	// flagi
	int				iResult;		// "-1" oznacza blad; "0" oznacza sukces;

} shm_exchange, *lpshm_exchange;


// Definicje dla pami�i wymiany danych
#ifdef _WIN32_WINNT
#define SYS_SHMOBJ_PREFIX		"Global\\"
#else
#define SYS_SHMOBJ_PREFIX		""
#endif//_WIN32_WINNT

#define SHMEM_DATAEXCH_NAME		SYS_SHMOBJ_PREFIX"ps_dracena_dataexch"
#define SHMEM_DATAEXCH_SIZE		sizeof( shm_exchange )


#endif //_SHMDEFS_H_
