/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

class PagingModel
extends AbstractTableModel {
    protected ArrayList<String[]> data;
    public int[] col_sizes = null;
    public String filename = "";
    protected PageReader pr = null;
    protected int column_count = 0;

    public PagingModel(String string) {
        this.filename = string;
        if (string.equals("")) {
            return;
        }
        this.pr = new PageReader(string);
    }

    @Override
    public String getColumnName(int n) {
        return this.pr.getColumnName(n);
    }

    public boolean update() {
        if (this.filename.equals("")) {
            return false;
        }
        return this.pr.update();
    }

    public int progress() {
        if (this.filename.equals("")) {
            return 100;
        }
        return this.pr.progress();
    }

    public void finish() {
        int n;
        this.pr.finish();
        this.jumpToPage(1);
        this.col_sizes = new int[this.column_count];
        for (n = 0; n < this.column_count; ++n) {
            this.col_sizes[n] = 0;
        }
        for (n = 0; n < this.data.size(); ++n) {
            for (int i = 0; i < this.data.get(n).length; ++i) {
                if (this.data.get(n)[i].length() <= this.col_sizes[i]) continue;
                this.col_sizes[i] = this.data.get(n)[i].length();
            }
        }
        for (n = 0; n < Math.min(this.column_count, this.pr.getNumColumnLabels()); ++n) {
            if (this.pr.getColumnName(n).length() <= this.col_sizes[n]) continue;
            this.col_sizes[n] = this.pr.getColumnName(n).length();
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.data.get(n).length <= n2) {
            return "";
        }
        return this.data.get(n)[n2];
    }

    public String getToolTip(int n, int n2) {
        String string = this.getValueAt(n, n2).toString();
        String[] stringArray = this.data.get(n);
        return this.pr.getToolTip(string, n, n2, stringArray);
    }

    @Override
    public int getColumnCount() {
        return this.column_count;
    }

    @Override
    public int getRowCount() {
        if (this.pr == null) {
            return 0;
        }
        return Math.min(1000, this.data.size());
    }

    public boolean jumpToPage(int n) {
        if (this.pr == null) {
            return false;
        }
        this.data = new ArrayList();
        try {
            String[] stringArray;
            this.pr.jumpToPage(n);
            while ((stringArray = this.pr.getNextRecord()) != null) {
                this.data.add(stringArray);
                if (this.column_count >= stringArray.length) continue;
                this.column_count = stringArray.length;
            }
            this.fireTableDataChanged();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int numPages() {
        if (this.pr == null) {
            return 1;
        }
        return this.pr.getNumPages();
    }

    public String getHeader() {
        if (this.filename.equals("")) {
            return "BAMseek allows you to scroll through large SAM/BAM, FASTQ, VCF and SFF files.  Please go to 'File > Open' File to get started.    ";
        }
        if (this.pr == null || this.pr.invalid) {
            return null;
        }
        return this.pr.getHeader();
    }
}

