#ifndef sithwm_h_included
#define sithwm_h_included

#include <X11/X.h>
#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xmd.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <stdio.h>
#ifndef __cplusplus
#define _GNU_SOURCE
#endif
#include <string.h>

#ifndef NOLOG
# define LOG_INFO(...) printf(__VA_ARGS__)
# define LOG_ERROR(...) fprintf(stderr, __VA_ARGS__)
#else
# define LOG_INFO(...)
# define LOG_ERROR(...)
#endif

struct masktab;

#ifdef DEBUG
# define LOG_DEBUG(...) fprintf(stderr, __VA_ARGS__)
void prt_mask(unsigned int mask, const struct masktab*t);
#else
# define LOG_DEBUG(...)
#define prt_mask(m,t) ((void)0)
#endif

#define STRLEN (200)
extern XGCValues glob_gcv;
extern char global_buffer[STRLEN];

extern unsigned int     numlockmask;

/* Coordinates */

struct pos {
   int x,y;
};

struct area {
   struct pos pos;
   int w,h;
};

/* screen structure */

#define COL_BASE	('b')
#define COL_NO_OF	('j'-COL_BASE)

enum {INFOW_OFF, INFOW_CAPTION, INFOW_MAP, INFOW_MENU};

#define VIEW_HISTORY (2)
typedef struct ScreenInfo ScreenInfo;
struct ScreenInfo {
#ifndef STORMTROOPER
   Window infow;
   Colormap        cmap;
#endif
   unsigned char infow_func;
   unsigned char do_infow_func;
   Window hilit;
   Window root;
   GC gc[COL_NO_OF];
   unsigned long pixel[COL_NO_OF];
   struct area area;
   struct pos screen_set_at;
   struct pos last_pos;
#ifndef STORMTROOPER
   struct pos hist[VIEW_HISTORY];
   unsigned int hist_index;
#endif
   unsigned int hilit_funcmask;
};

extern ScreenInfo   *screens;
extern ScreenInfo*current_screen;
extern int          num_screens;
extern char default_name[2];

/* client structure */

enum { FL_NAMED=4, FL_REMOVE=2, FL_INPUT=1};
struct Client_d {
   Window  window;
   struct area area;
   unsigned char opts;
   char sticky;
   char border_color;
   char maxim_state;
};

#define HISTORY (4)
typedef struct Client Client;
struct Client {
   struct Client_d dyn;
   char *name;
   ScreenInfo      *screen;
   Client  *next;
#ifndef STORMTROOPER
   Drawable icon;
   //   Drawable icon_mask;
   unsigned int icon_width, icon_height;
   struct area hist[HISTORY];
   unsigned hist_index;
#endif
   struct pos last_cursor;
   struct pos last_screen;
};

#if DEATHSTAR
typedef struct Application Application;
struct Application {
   char *res_name;
   char *res_class;
   int geometry_mask;
   struct area area;
   char sticky;
   Application *next;
};
extern Application *head_app;
#endif

/* Declarations for global variables in main.c */
extern const char   *colnams[COL_NO_OF];
extern const char   *opt_font;

/* Commonly used X information */
extern Display      *dpy;
extern XFontStruct  *font;
extern int	    font_height;

extern Atom xa_wm_state;
extern Atom xa_wm_delete;
extern Atom xa_wm_protos;

/* Things that affect user interaction */

#ifdef STORMTROOPER
#define opt_solid_drag (0)
#define opt_popup_time_in (0)
#else
extern struct area	opt_popup_area;
extern int		opt_popup_stack_width;
extern int		opt_popup_time_in;
extern unsigned char	opt_qualify_caption;
extern int stacker_offset;
extern int opt_solid_drag;
extern const char*lock_command;
extern unsigned int infow_scaler;
#endif
extern char	local_popup_list;

#ifdef DEATHSTAR
extern int              opt_bw;
extern unsigned char	opt_snap;
extern char		opt_snap_to_windows;
extern int		opt_popup_timeout_a[];
#define opt_popup_timeout(lev) (opt_popup_timeout_a[(lev)&3])
#else
#define opt_bw (1)
#define opt_snap (0)
#define opt_popup_timeout(lev) (450)
#endif

/* Client tracking information */
extern Client *head_client;

/* client.c */
void make_new_client(Window w, ScreenInfo*s, int flags);
Client *find_client(Window w);
void place_client(ScreenInfo*screen, struct area *a);
void get_client_props(Client*client);

enum {

   /* Functions, normally shifted left */

   /* this first group requires a focused window to work on */
   FUNC_NONE, FUNC_MOVE, FUNC_HIST, FUNC_KILL,
   FUNC_LOWER, FUNC_RESIZE, FUNC_DRAGRESIZE,

   /* this group requires that windows exist, make sure FUNC_NEXT is
      first */
   FUNC_NEXT, FUNC_CIRCUL,

   /* this group should work anyway, make sure FUNC_MENU is first */
   FUNC_MENU, FUNC_PAN, FUNC_NEXT_SCREEN,
   FUNC_VIEW_HIST, FUNC_SPAWN,

	/* Only for window actions so it dont matter where they
           are placed. */
	XACT_ENTER, XACT_NEW, XACT_DELETED,

	FUNC_MAX,

        /* Modifiers for the functions. */
	FMOD_LOCAL	= 0x1,
	FMOD_SET_VIEW	= 0x2,
	FMOD_RAISE	= 0x4,
	FMOD_SETMOUSE	= 0x8,
	FMOD_FOCUS	= 0x10,
	FMOD_MAXIMISE	= 0x20,
	FMOD_FIX	= 0x40,
	FMOD_ABS	= 0x100,
	FMOD_INFO	= 0x200,
	FMOD_VIEW	= 0x400,
	FMOD_POPUP	= 0x800,
};

void select_client(Client *c, unsigned int func);
Client* select_window(Window w, unsigned int func);

#ifdef DO_EVENT_LOG
void log_window_event(const char*cmd, Client*c);
#else
#define log_window_event(x,y) ((void)1)
#endif

/* events.c */
struct Dragsweep{
   Client*c;
   unsigned fl;
   struct pos pos;
};
extern struct Dragsweep dragsweep;

void event_main_loop(void);

/* misc.c */
unsigned int hash_val(void*p, size_t len, unsigned int s);
int handle_xerror(Display *dsply, XErrorEvent *e);
void spawn(const char*command);
int intersect(struct area *r1, struct area *r2);


/* screen.c */
void setview(void);

void toviewpos(Client *c, struct pos*p);
void toworldpos(Client *c, int x, int y, struct pos*p);
const char *map_state_string(int map_state);

extern unsigned int last_current_info;
void update_info_window(ScreenInfo*screen, int pri);


void read_rcs(void);   
void do_menu(ScreenInfo*screen, XEvent*e);

#ifdef __GNUC__
extern char*strdup(const char*);
#endif
extern int putenv(char*);


// sithfunc
struct masktab {
   const char *name;
   unsigned int mask;
};
extern struct masktab modifiers[];
extern const struct masktab funcmasks[];
void init_funcs(FILE*f);
void do_func(ScreenInfo*screen, XEvent*e, KeySym key);
void func_grab(Window w);
unsigned int parse_modifiers(char *s);
unsigned int parse_mask(char *s, const struct masktab*t);
void parse_rc_line();

#define FUNC_SHIFT (24)

extern unsigned int setmodifiers[];
extern int min_size_for_func[];


#endif
