/* sithwm - Minimalist Window Manager for X
 * see README for Copyright, license and other details. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "sithwm.h"
#include <sys/select.h>
#include <unistd.h>

static int enter_focus_countdown;
unsigned int last_current_info;
unsigned char opt_qualify_caption = 1;
#ifndef STORMTROOPER
int opt_solid_drag = 1;
#endif
static void cleanup_clients(void)
{
#ifdef DEBUG
   int no_cli=0,no_del=0;
#endif
   Client *old_h = head_client;
   char bc_to_set = 'f'-COL_BASE;
   for (Client **p = &head_client;*p;) {
      Client*z=*p;

      if (z->dyn.opts&FL_REMOVE) {
	 *p = z->next;
#ifdef DEBUG
	 LOG_DEBUG("\tremove: 0x%lx\n", z->dyn.window);
	 no_del++;
#endif
	 if (z->name != default_name)
	    XFree(z->name);
	 free(z);
      } else {
#ifdef DEBUG
	 no_cli++;
#endif
	 if (bc_to_set != z->dyn.border_color) {
	    XSetWindowBorder(dpy, z->dyn.window, z->screen->pixel[(int)bc_to_set]);
	    z->dyn.border_color = bc_to_set;
	    enter_focus_countdown=5;
	 }
         bc_to_set = 'e'-COL_BASE;
         p = &z->next;
      }
   }

   if (head_client != old_h) {
      for (old_h=head_client ; old_h && old_h->screen != current_screen ; old_h = old_h->next)
	 ;
      select_client(old_h, XACT_DELETED<<FUNC_SHIFT);
   }
   
#ifdef DEBUG
   if (no_del)
      LOG_DEBUG("\tcleanup_clients() : window count now %d\n", no_cli);
#endif
}

struct Dragsweep dragsweep;

static Window was_focus;

#ifdef DEATHSTAR
int              opt_bw = 1;
unsigned char	opt_snap = 32;
char		opt_snap_to_windows;
int		opt_popup_timeout_a[] = {450,450,450,450};

static int absmin(int a, int b) {
   if (abs(a) < abs(b))
      return a;
   return b;
}

static void snap_client(Client *c)
{
   int dx = opt_snap, dy = opt_snap;
   struct area cc;
   cc.w = c->dyn.area.w;
   cc.h = c->dyn.area.h;
   toviewpos(c, &cc.pos);

   /* snap to screen border */
   dx = absmin(dx, -cc.pos.x);
   dy = absmin(dy, -cc.pos.y);
   dx = absmin(dx, c->screen->area.w - cc.pos.x - cc.w);
   dy = absmin(dy, c->screen->area.h - cc.pos.y - cc.h);

   if (opt_snap_to_windows) {
      Client *ci;
      for (ci = head_client; ci; ci = ci->next) {
	 if (ci != c && ci->screen == c->screen) {
	    struct pos cip;
	    toviewpos(ci, &cip);
	    if (cip.y - cc.h - cc.pos.y <= opt_snap && cc.pos.y - ci->dyn.area.h - cip.y <= opt_snap) {
	       dx = absmin(dx, cip.x + ci->dyn.area.w - cc.pos.x);
	       dx = absmin(dx, cip.x + ci->dyn.area.w - cc.pos.x - cc.w);
	       dx = absmin(dx, cip.x - cc.pos.x - cc.w);
	       dx = absmin(dx, cip.x - cc.pos.x);
	    }
	    if (cip.x - cc.w - cc.pos.x <= opt_snap && cc.pos.x - ci->dyn.area.w - cip.x <= opt_snap) {
	       dy = absmin(dy, cip.y + ci->dyn.area.h - cc.pos.y);
	       dy = absmin(dy, cip.y + ci->dyn.area.h - cc.pos.y - cc.h);
	       dy = absmin(dy, cip.y - cc.pos.y - cc.h);
	       dy = absmin(dy, cip.y - cc.pos.y);
	    }
	 }
      }
   }

   if (abs(dx) < opt_snap)
      cc.pos.x += dx;
   if (abs(dy) < opt_snap)
      cc.pos.y += dy;
   toworldpos(c, cc.pos.x, cc.pos.y, &c->dyn.area.pos);
}
#else
#define snap_client(x)
#endif /* def DEATHSTAR */

unsigned int infow_scaler;

void event_main_loop(void)
{
   static unsigned int infow_state_counter;
   static unsigned int infow_post_counter;
   static unsigned int has_waited_counter;
   static unsigned int thewt = 0;
   XEvent zevent;

   /* main event loop here */
   for (;;) {
      while (XCheckMaskEvent(dpy, -1, &zevent)) {
         ScreenInfo*screen = current_screen;
         for (ScreenInfo*s2 = screens; s2 < screens+num_screens; s2++) {
#ifndef STORMTROOPER
	    if (s2->infow == zevent.xany.window &&
		s2->infow_func<INFOW_MAP &&
		infow_post_counter!=has_waited_counter)
	    {
	       LOG_DEBUG("\tunmap capt, because event\n");
	       XUnmapWindow(dpy, zevent.xany.window);
	       s2->infow_func = INFOW_OFF;
	    }
#endif
	    if (s2->root == zevent.xkey.root || s2->root == zevent.xany.window)
	       screen = s2;
	 }

	 switch (zevent.type) {
	 case KeyPress:
	    LOG_DEBUG("KeyPress %lx +%d+%d\n", zevent.xkey.window, zevent.xkey.x, zevent.xkey.y);
	    infow_post_counter = has_waited_counter;
#ifndef STORMTROOPER
	    if (screen->infow_func == INFOW_MENU)
	       do_menu(screen, &zevent);
	    else
#endif
	    {
	       KeySym key = XKeycodeToKeysym(dpy,zevent.xkey.keycode,0);
	       do_func(screen, &zevent, key);
	    }
	    break;
	 case ButtonPress:
	    LOG_DEBUG("ButtonPress %lx +%d+%d\n", zevent.xbutton.window, zevent.xbutton.x, zevent.xbutton.y);
	    do_func(screen, &zevent, XK_Pointer_Button1+zevent.xbutton.button - Button1);
	    break;
	 case MotionNotify: {
	    LOG_DEBUG("MotionNotify %lx +%d+%d \n", zevent.xmotion.window, zevent.xmotion.x, zevent.xmotion.y);
	    Client* client = dragsweep.c;
	    if (client) {
	       int ox = zevent.xmotion.x + dragsweep.pos.x;
	       int oy = zevent.xmotion.y + dragsweep.pos.y;
	       if (client->dyn.sticky) {
		  ox -= screen->area.pos.x;
		  oy -= screen->area.pos.y;
	       }
	       if (dragsweep.fl) {
		  ox -= client->dyn.area.pos.x;
		  oy -= client->dyn.area.pos.y;
		  client->dyn.area.w = ox;
		  client->dyn.area.h = oy;
	       } else {
		  client->dyn.area.pos.x = ox;
		  client->dyn.area.pos.y = oy;
#ifdef DEATHSTAR
		  if (opt_snap)
		     snap_client(client);
#endif
	       }

	       if (opt_solid_drag)
		  select_client(client, FMOD_RAISE);
	       break;
	    }
	 } /* fall through, no drag so release everything. */
	 case ButtonRelease:
	    XUngrabPointer(dpy, CurrentTime);
            select_client(dragsweep.c, FMOD_RAISE);
	    dragsweep.c = 0;
	    break;
	 case ConfigureNotify:
	    {
	       Client* client = find_client(zevent.xconfigurerequest.window);
	       if (client) {
		  client->dyn.area.w = zevent.xconfigure.width;
		  client->dyn.area.h = zevent.xconfigure.height;
		  toworldpos(client, zevent.xconfigure.x,  zevent.xconfigure.y, &client->dyn.area.pos);
	       }
	    }
	    LOG_DEBUG("ConfigureNotify: 0x%lx configured to %dx%d+%d+%d\n", zevent.xconfigure.window,
		      zevent.xconfigure.width, zevent.xconfigure.height, zevent.xconfigure.x, zevent.xconfigure.y);
	    break;
	 case  MapNotify: {
	    if (
#ifndef STORMTROOPER
		zevent.xmap.window != screen->infow &&
#endif
		!select_window(zevent.xmap.window, FMOD_RAISE|FMOD_FOCUS))
	    {
	       make_new_client(zevent.xmap.window, screen, 0);
	    }
	    LOG_DEBUG("MapNotify: 0x%lx\n", zevent.xmap.window);
	 }break;
	 case UnmapNotify: {
	    was_focus = 0;
	    LOG_DEBUG("UnmapNotify: 0x%lx\n", zevent.xunmap.window);
	    Client*client = find_client(zevent.xunmap.window);
	    if (client)
	       client->dyn.opts |= FL_REMOVE;
	 }break;
	 case FocusIn:
	 case FocusOut:
	    was_focus = 0;
	    LOG_DEBUG("Focus%s: 0x%lx\n", (zevent.type==FocusIn)?"In":"Out",
		      zevent.xany.window);
	    break;
	 case EnterNotify:
	    LOG_DEBUG("EnterNotify: 0x%lx \n", zevent.xcrossing.window);
	    if (screen->infow_func!=INFOW_MENU)
	       select_window(zevent.xcrossing.window, (XACT_ENTER<<FUNC_SHIFT)|FMOD_FOCUS);
	    break;
	 case PropertyNotify: {
	    LOG_DEBUG("PropertyNotify: 0x%lx \n", zevent.xproperty.window);
	    Client *client = find_client(zevent.xproperty.window);
	    if (client) {
	       client->dyn.opts |= FL_NAMED;
	       get_client_props(client);
	    }
	    last_current_info = 0;
	 }break;
	 default:
	    LOG_DEBUG("default: 0x%lx %i\n", zevent.xany.window, zevent.type);
	 }
      }

      if (current_screen->infow_func <= INFOW_CAPTION &&
	  memcmp(&current_screen->area.pos, &current_screen->screen_set_at,sizeof(current_screen->screen_set_at))) {
	 current_screen->screen_set_at = current_screen->area.pos;
	 setview();
      }
#define WTSHIFT (6)

      cleanup_clients();

      Client *lhclient = head_client;

      int wx,wy;
      static Window win_i;
      int iter=0;
      for (ScreenInfo*s2=screens+num_screens-1 ; s2>= screens ; s2--) {
         Window root_r;
         unsigned int mask;
         int rx,ry;
         for (Window win_r = s2->root; iter<2; iter++)
         {
            win_i = win_r;
            if (!XQueryPointer(dpy, win_i, &root_r, &win_r,
                               &rx, &ry, &wx, &wy, &mask))
               break;
            current_screen = s2;
            s2->last_pos.x = rx;
            s2->last_pos.y = ry;
            int gen_key = (((ry<<5)+rx)<<5)+((int)mask);
            static unsigned int save_key;
            if (save_key != gen_key || (mask&modifiers[0].mask) ) {
               save_key = gen_key;
               thewt = 0;
            }
            if (!win_r)
               iter++;
         }

	 if (((has_waited_counter-infow_post_counter)>opt_popup_timeout(s2->infow_func)) ||
	     (s2->infow_func == INFOW_MAP && (mask&modifiers[0].mask) == 0) ||
	     (s2->infow_func == INFOW_CAPTION && (!lhclient || !(lhclient->dyn.opts&FL_NAMED)))
	     )
	 {
	    if (s2->infow_func == INFOW_MAP) {
	       select_window(s2->hilit, s2->hilit_funcmask);
	       s2->hilit = 0;
	       s2->do_infow_func = 0;
	    }
#ifndef STORMTROOPER
	    XUnmapWindow(dpy, s2->infow);
#endif
	    s2->infow_func = 0;
	 }
      }

      if (current_screen->infow_func != INFOW_MAP) {
	 infow_state_counter = 0;
	 infow_scaler = 0;
      } else {
	 infow_state_counter ++;
	 int scaler = infow_state_counter>opt_popup_time_in;
	 if (scaler != infow_scaler)
	    current_screen->do_infow_func = INFOW_MAP;
	 infow_scaler = scaler;
      }

      if (current_screen->do_infow_func) {
         int zz = current_screen->do_infow_func;
	 current_screen->do_infow_func = 0;
	 update_info_window(current_screen, zz);
	 infow_post_counter = has_waited_counter;
      }
      
      lhclient = head_client;

#ifndef NFOCUS
      {
         // We need to only set focus to windows that will take
         // explicit focus, also - only set focus when it changes (for
         // eg. vncviewer to work).
	 Window to_focus = 0;
#ifndef STORMTROOPER
         if (current_screen->infow_func > INFOW_CAPTION)
	    to_focus = current_screen->infow;
	 else
#endif
         {
	    if (lhclient && lhclient->screen==current_screen &&
		intersect(&lhclient->screen->area, &lhclient->dyn.area)) {
               if (!(lhclient->dyn.opts&FL_INPUT))
                  to_focus = lhclient->dyn.window;
            } else
               to_focus = PointerRoot;
	 }
         if (to_focus && to_focus != was_focus) {
            LOG_DEBUG("Set Focus : 0x%lx \n", to_focus);
	    XSetInputFocus(dpy, to_focus, RevertToPointerRoot, CurrentTime);
         }
         was_focus = to_focus;
      }

#else
      if (!was_focus) {
         XSetInputFocus(dpy, PointerRoot, RevertToPointerRoot, CurrentTime);
         was_focus = 1;
      }
#endif

      if (lhclient && (lhclient->dyn.opts&FL_NAMED) &&
	  lhclient->screen->infow_func<=INFOW_CAPTION &&
	  opt_qualify_caption) {
	 unsigned int nhash = hash_val(&lhclient->dyn, sizeof lhclient->dyn, 11);
	 if (nhash != last_current_info)
	 {
	    LOG_DEBUG("Caption: 0x%lx \n", lhclient->dyn.window);
	    lhclient->screen->do_infow_func = INFOW_CAPTION;
	    opt_qualify_caption &= 1;
	 }
	 last_current_info = nhash;
      }

      thewt++;
      struct timeval ttxx;
      ttxx.tv_usec=(thewt%(1<<WTSHIFT))*(1000000>>WTSHIFT);
      ttxx.tv_sec=thewt>>WTSHIFT;

      XFlush(dpy);
      int x_connect_fd = ConnectionNumber(dpy);
      fd_set fdset;
      FD_ZERO(&fdset);
      FD_SET(x_connect_fd, &fdset);

      if ( (dragsweep.c&&(!opt_solid_drag)) || enter_focus_countdown>0 ) {
	 Client *dc = dragsweep.c;
	 if (enter_focus_countdown>0) {
	    enter_focus_countdown--;
	    dc = lhclient;
	 }
	 thewt = 0;

	 if (dc && ((enter_focus_countdown&1)==0)) {
	    struct pos r;
	    ScreenInfo*screen = dc->screen;
	    toviewpos(dc, &r);
	    r.x += opt_bw-1;
	    r.y += opt_bw-1;
	    XGrabServer(dpy);
	    XDrawRectangle(dpy, screen->root, screen->gc['d'-COL_BASE],
			   r.x, r.y, dc->dyn.area.w+1, dc->dyn.area.h+1);
	    XFlush(dpy);
	    // Put in if drag rect will not show up:
	    // select(x_connect_fd + 1, &fdset, 0, 0, &ttxx);
	    XDrawRectangle(dpy, screen->root, screen->gc['d'-COL_BASE],
			   r.x, r.y, dc->dyn.area.w+1, dc->dyn.area.h+1);
	    XUngrabServer(dpy);
	 }
      }

      if (select(x_connect_fd + 1, &fdset, 0, 0, &ttxx) ) {
	 thewt = 0;
      } else {
	 has_waited_counter += thewt;
#ifndef STORMTROOPER
	 if (stacker_offset) {
	    current_screen->do_infow_func = current_screen->infow_func;
	    stacker_offset = 0;
	    thewt = 0;
	 }
#endif
	 if (lhclient) {
	    if (lhclient->dyn.window == win_i &&
		intersect(&lhclient->screen->area, &lhclient->dyn.area)) {
	       lhclient->last_screen = lhclient->screen->area.pos;
	       lhclient->last_cursor.x = wx;
	       lhclient->last_cursor.y = wy;
	    }
	    if ( thewt>18) {
#ifndef STORMTROOPER
	       if ( memcmp(&lhclient->hist[lhclient->hist_index], &lhclient->dyn.area, sizeof(lhclient->dyn.area)) ) {
		  lhclient->hist_index = (lhclient->hist_index+1)%HISTORY;
		  lhclient->hist[lhclient->hist_index] = lhclient->dyn.area;
	       }
#endif
	       log_window_event("P", lhclient);
	       lhclient->dyn.opts |= FL_NAMED;
	    }
	 }
#ifndef STORMTROOPER
	 if ( thewt>8 &&
	      memcmp(&current_screen->hist[current_screen->hist_index], &current_screen->area.pos, sizeof(current_screen->area.pos)) ) {
	    current_screen->hist_index = (current_screen->hist_index+1)%VIEW_HISTORY;
	    current_screen->hist[current_screen->hist_index] = current_screen->area.pos;
	 }
	 if (thewt>230 && lock_command) {
	    system(lock_command);
	    thewt = 0;
	 }
#endif
      }
   }
}
