/* $Id$ */
/*
 * memory allocation functions with error checking
 */
#if defined HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#include "common.h"

static void xmalloc_error(void);

void *xmalloc(size_t num)
{
  void *newmem;
  newmem = malloc(num);
  if (newmem == NULL) {
    xmalloc_error();
  }
  return newmem;
}

void *xrealloc(void *p, size_t num)
{
  void *newmem;
  if (p == NULL) {
    return xmalloc(num);
  }
  newmem = realloc(p, num);
  if (newmem == NULL) {
    xmalloc_error();
  }
  return newmem;
}

void *xcalloc(size_t num, size_t size)
{
  void *newmem;
  newmem = xmalloc(num*size);
  memset(newmem, 0x0, num*size);
  return newmem;
}

static void xmalloc_error(void)
{
  fprintf(stderr, "FATAL: Memory exhausted");
  exit(EXIT_FAILURE);
}
