/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public abstract class AbstractStatisticStyleRule
extends TextLevelRule {
    private static final Pattern OPENING_QUOTES = Pattern.compile("[\"\u201c\u201e\u00bb\u00ab]");
    private static final Pattern ENDING_QUOTES = Pattern.compile("[\"\u201c\u201d\u00bb\u00ab]");
    private static final boolean DEFAULT_ACTIVATION = false;
    private final int minPercent;
    private final int defaultMinPercent;
    private int wordCount = 0;
    private int numMatches = 0;
    private boolean withoutDirectSpeech = false;

    protected abstract int conditionFulfilled(AnalyzedTokenReadings[] var1, int var2);

    protected abstract boolean sentenceConditionFulfilled(AnalyzedTokenReadings[] var1, int var2);

    protected abstract boolean excludeDirectSpeech();

    protected abstract String getLimitMessage(int var1, double var2);

    protected abstract String getSentenceMessage();

    @Override
    public abstract String getConfigureText();

    public AbstractStatisticStyleRule(ResourceBundle messages, Language lang, UserConfig userConfig, int minPercent, boolean defaultActive) {
        super(messages);
        super.setCategory(new Category(new CategoryId("CREATIVE_WRITING"), messages.getString("category_creative_writing"), Category.Location.INTERNAL, false));
        if (!defaultActive) {
            this.setDefaultOff();
        }
        this.defaultMinPercent = minPercent;
        this.minPercent = this.getMinPercent(userConfig, minPercent);
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    private int getMinPercent(UserConfig userConfig, int minPercentDefault) {
        int confPercent;
        if (userConfig != null && (confPercent = userConfig.getConfigValueByID(this.getId())) >= 0) {
            return confPercent;
        }
        return minPercentDefault;
    }

    public AbstractStatisticStyleRule(ResourceBundle messages, Language lang, UserConfig userConfig, int minPercent) {
        this(messages, lang, userConfig, minPercent, false);
    }

    public double denominator() {
        return 100.0;
    }

    @Override
    public boolean hasConfigurableValue() {
        return true;
    }

    @Override
    public int getDefaultValue() {
        return this.defaultMinPercent;
    }

    @Override
    public int getMinConfigurableValue() {
        return 0;
    }

    @Override
    public int getMaxConfigurableValue() {
        return 100;
    }

    public int getWordCount() {
        return this.wordCount;
    }

    public int getNumberOfMatches() {
        return this.numMatches;
    }

    public void setWithoutDirectSpeech(boolean withoutDirectSpeech) {
        this.withoutDirectSpeech = withoutDirectSpeech;
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        ArrayList<Integer> startPos = new ArrayList<Integer>();
        ArrayList<Integer> endPos = new ArrayList<Integer>();
        ArrayList<AnalyzedSentence> relevantSentences = new ArrayList<AnalyzedSentence>();
        int pos = 0;
        this.wordCount = 0;
        boolean excludeDirectSpeech = this.excludeDirectSpeech();
        boolean isDirectSpeech = false;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            for (int n = 1; n < tokens.length; ++n) {
                AnalyzedTokenReadings token = tokens[n];
                String sToken = token.getToken();
                if (excludeDirectSpeech && !isDirectSpeech && OPENING_QUOTES.matcher(sToken).matches() && n < tokens.length - 1 && !tokens[n + 1].isWhitespaceBefore()) {
                    isDirectSpeech = true;
                    continue;
                }
                if (excludeDirectSpeech && isDirectSpeech && ENDING_QUOTES.matcher(sToken).matches() && n > 1 && !tokens[n].isWhitespaceBefore()) {
                    isDirectSpeech = false;
                    continue;
                }
                if (isDirectSpeech && (this.minPercent != 0 || this.withoutDirectSpeech) || token.isWhitespace() || token.isNonWord()) continue;
                ++this.wordCount;
                int nEnd = this.conditionFulfilled(tokens, n);
                if (nEnd < n) continue;
                if (this.sentenceConditionFulfilled(tokens, n)) {
                    RuleMatch ruleMatch = new RuleMatch(this, sentence, token.getStartPos() + pos, token.getEndPos() + pos, this.getSentenceMessage());
                    ruleMatches.add(ruleMatch);
                    continue;
                }
                startPos.add(token.getStartPos() + pos);
                endPos.add(tokens[nEnd].getEndPos() + pos);
                relevantSentences.add(sentence);
            }
            pos += sentence.getCorrectedTextLength();
        }
        this.numMatches = startPos.size() + ruleMatches.size();
        double percent = this.wordCount > 0 ? (double)this.numMatches * this.denominator() / (double)this.wordCount : 0.0;
        if (percent > (double)this.minPercent) {
            for (int i = 0; i < startPos.size(); ++i) {
                RuleMatch ruleMatch = new RuleMatch(this, (AnalyzedSentence)relevantSentences.get(i), (Integer)startPos.get(i), (Integer)endPos.get(i), this.getLimitMessage(this.minPercent, percent));
                ruleMatches.add(ruleMatch);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return -1;
    }
}

