/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.internal.AbstractReadableBuffer;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class NettyReadableBuffer
extends AbstractReadableBuffer {
    private final ByteBuf buffer;
    private boolean closed;

    NettyReadableBuffer(ByteBuf buffer) {
        this.buffer = (ByteBuf)Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
    }

    ByteBuf buffer() {
        return this.buffer;
    }

    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    public void skipBytes(int length) {
        this.buffer.skipBytes(length);
    }

    public int readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    public void readBytes(byte[] dest, int index, int length) {
        this.buffer.readBytes(dest, index, length);
    }

    public void readBytes(ByteBuffer dest) {
        this.buffer.readBytes(dest);
    }

    public void readBytes(OutputStream dest, int length) {
        try {
            this.buffer.readBytes(dest, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NettyReadableBuffer readBytes(int length) {
        return new NettyReadableBuffer(this.buffer.readRetainedSlice(length));
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset() + this.buffer.readerIndex();
    }

    public boolean markSupported() {
        return true;
    }

    public void mark() {
        this.buffer.markReaderIndex();
    }

    public void reset() {
        this.buffer.resetReaderIndex();
    }

    public boolean byteBufferSupported() {
        return this.buffer.nioBufferCount() > 0;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer.nioBufferCount() == 1 ? this.buffer.nioBuffer() : this.buffer.nioBuffers()[0];
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.buffer.release();
        }
    }
}

