/* { dg-do run { target le } } */

#include <stdint.h>

#define BS_VEC(type, num) type __attribute__((vector_size(num * sizeof(type))))
#define BITCAST(T, F, arg)                                                     \
    ((union {                                                                  \
        F src;                                                                 \
        T dst;                                                                 \
    })arg)                                                                     \
        .dst

uint64_t func_1()
{
    BS_VEC(uint64_t, 32) BS_VAR_0;
    BS_VAR_0 = BITCAST(
        BS_VEC(uint64_t, 32), BS_VEC(uint8_t, 256),
        __builtin_shufflevector(
            (BS_VEC(uint8_t, 2)){ 2 }, (BS_VEC(uint8_t, 2)){}, 1, 0, 2, 2, 2, 3,
            1, 2, 3, 1, 3, 3, 2, 1, 3, 0, 2, 2, 1, 2, 1, 3, 1, 1, 0, 0, 2, 0, 3,
            2, 2, 0, 1, 3, 1, 2, 0, 2, 0, 3, 0, 0, 2, 0, 2, 1, 3, 2, 3, 2, 1, 1,
            2, 3, 3, 3, 3, 0, 1, 2, 3, 2, 0, 2, 2, 2, 0, 3, 3, 3, 1, 3, 0, 0, 2,
            3, 1, 1, 2, 2, 1, 2, 0, 0, 3, 2, 2, 3, 2, 2, 3, 2, 0, 2, 2, 0, 2, 1,
            3, 1, 0, 2, 1, 3, 2, 1, 0, 2, 3, 0, 1, 3, 2, 1, 3, 1, 1, 3, 2, 2, 0,
            3, 2, 2, 0, 3, 0, 3, 2, 3, 1, 3, 2, 3, 3, 2, 2, 0, 0, 0, 2, 1, 3, 1,
            2, 2, 3, 0, 1, 3, 1, 1, 2, 0, 1, 2, 1, 2, 0, 2, 0, 2, 3, 3, 3, 1, 2,
            0, 3, 1, 2, 0, 1, 0, 3, 0, 0, 3, 2, 2, 0, 3, 1, 2, 0, 1, 1, 3, 0, 1,
            3, 1, 3, 2, 1, 3, 1, 2, 1, 1, 0, 1, 3, 3, 2, 3, 2, 2, 0, 2, 2, 2, 1,
            1, 0, 3, 1, 3, 0, 3, 0, 0, 1, 3, 3, 1, 2, 1, 1, 3, 1, 0, 2, 1, 3, 2,
            1, 3, 2, 2, 2, 3, 2, 0, 1, 3, 3, 3, 0, 0, 0, 1, 3, 2, 2, 1));
    return BS_VAR_0[0];
}

int main()
{
    uint64_t BS_CHECKSUM = func_1();
    if (BS_CHECKSUM != 0x0000000000000200ull)
      __builtin_abort ();
    return 0;
}
