package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetFileSystem invokes the nas.ResetFileSystem API synchronously
func (client *Client) ResetFileSystem(request *ResetFileSystemRequest) (response *ResetFileSystemResponse, err error) {
	response = CreateResetFileSystemResponse()
	err = client.DoAction(request, response)
	return
}

// ResetFileSystemWithChan invokes the nas.ResetFileSystem API asynchronously
func (client *Client) ResetFileSystemWithChan(request *ResetFileSystemRequest) (<-chan *ResetFileSystemResponse, <-chan error) {
	responseChan := make(chan *ResetFileSystemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetFileSystem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetFileSystemWithCallback invokes the nas.ResetFileSystem API asynchronously
func (client *Client) ResetFileSystemWithCallback(request *ResetFileSystemRequest, callback func(response *ResetFileSystemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetFileSystemResponse
		var err error
		defer close(result)
		response, err = client.ResetFileSystem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetFileSystemRequest is the request struct for api ResetFileSystem
type ResetFileSystemRequest struct {
	*requests.RpcRequest
	SnapshotId   string `position:"Query" name:"SnapshotId"`
	FileSystemId string `position:"Query" name:"FileSystemId"`
}

// ResetFileSystemResponse is the response struct for api ResetFileSystem
type ResetFileSystemResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResetFileSystemRequest creates a request to invoke ResetFileSystem API
func CreateResetFileSystemRequest() (request *ResetFileSystemRequest) {
	request = &ResetFileSystemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "ResetFileSystem", "", "")
	request.Method = requests.POST
	return
}

// CreateResetFileSystemResponse creates a response to parse from ResetFileSystem response
func CreateResetFileSystemResponse() (response *ResetFileSystemResponse) {
	response = &ResetFileSystemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
