package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFpShotFiles invokes the mts.ListFpShotFiles API synchronously
func (client *Client) ListFpShotFiles(request *ListFpShotFilesRequest) (response *ListFpShotFilesResponse, err error) {
	response = CreateListFpShotFilesResponse()
	err = client.DoAction(request, response)
	return
}

// ListFpShotFilesWithChan invokes the mts.ListFpShotFiles API asynchronously
func (client *Client) ListFpShotFilesWithChan(request *ListFpShotFilesRequest) (<-chan *ListFpShotFilesResponse, <-chan error) {
	responseChan := make(chan *ListFpShotFilesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFpShotFiles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFpShotFilesWithCallback invokes the mts.ListFpShotFiles API asynchronously
func (client *Client) ListFpShotFilesWithCallback(request *ListFpShotFilesRequest, callback func(response *ListFpShotFilesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFpShotFilesResponse
		var err error
		defer close(result)
		response, err = client.ListFpShotFiles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFpShotFilesRequest is the request struct for api ListFpShotFiles
type ListFpShotFilesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	FpDBId               string           `position:"Query" name:"FpDBId"`
	NextPageToken        string           `position:"Query" name:"NextPageToken"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ListFpShotFilesResponse is the response struct for api ListFpShotFiles
type ListFpShotFilesResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	NextPageToken  string         `json:"NextPageToken" xml:"NextPageToken"`
	FpShotFileList FpShotFileList `json:"FpShotFileList" xml:"FpShotFileList"`
}

// CreateListFpShotFilesRequest creates a request to invoke ListFpShotFiles API
func CreateListFpShotFilesRequest() (request *ListFpShotFilesRequest) {
	request = &ListFpShotFilesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "ListFpShotFiles", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListFpShotFilesResponse creates a response to parse from ListFpShotFiles response
func CreateListFpShotFilesResponse() (response *ListFpShotFilesResponse) {
	response = &ListFpShotFilesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
