package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteZnode invokes the mse.DeleteZnode API synchronously
func (client *Client) DeleteZnode(request *DeleteZnodeRequest) (response *DeleteZnodeResponse, err error) {
	response = CreateDeleteZnodeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteZnodeWithChan invokes the mse.DeleteZnode API asynchronously
func (client *Client) DeleteZnodeWithChan(request *DeleteZnodeRequest) (<-chan *DeleteZnodeResponse, <-chan error) {
	responseChan := make(chan *DeleteZnodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteZnode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteZnodeWithCallback invokes the mse.DeleteZnode API asynchronously
func (client *Client) DeleteZnodeWithCallback(request *DeleteZnodeRequest, callback func(response *DeleteZnodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteZnodeResponse
		var err error
		defer close(result)
		response, err = client.DeleteZnode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteZnodeRequest is the request struct for api DeleteZnode
type DeleteZnodeRequest struct {
	*requests.RpcRequest
	ClusterId      string `position:"Query" name:"ClusterId"`
	Path           string `position:"Query" name:"Path"`
	RequestPars    string `position:"Query" name:"RequestPars"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// DeleteZnodeResponse is the response struct for api DeleteZnode
type DeleteZnodeResponse struct {
	*responses.BaseResponse
	HttpCode  string `json:"HttpCode" xml:"HttpCode"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteZnodeRequest creates a request to invoke DeleteZnode API
func CreateDeleteZnodeRequest() (request *DeleteZnodeRequest) {
	request = &DeleteZnodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "DeleteZnode", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteZnodeResponse creates a response to parse from DeleteZnode response
func CreateDeleteZnodeResponse() (response *DeleteZnodeResponse) {
	response = &DeleteZnodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
