package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLocalJoinPermission invokes the linkwan.DeleteLocalJoinPermission API synchronously
func (client *Client) DeleteLocalJoinPermission(request *DeleteLocalJoinPermissionRequest) (response *DeleteLocalJoinPermissionResponse, err error) {
	response = CreateDeleteLocalJoinPermissionResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLocalJoinPermissionWithChan invokes the linkwan.DeleteLocalJoinPermission API asynchronously
func (client *Client) DeleteLocalJoinPermissionWithChan(request *DeleteLocalJoinPermissionRequest) (<-chan *DeleteLocalJoinPermissionResponse, <-chan error) {
	responseChan := make(chan *DeleteLocalJoinPermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLocalJoinPermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLocalJoinPermissionWithCallback invokes the linkwan.DeleteLocalJoinPermission API asynchronously
func (client *Client) DeleteLocalJoinPermissionWithCallback(request *DeleteLocalJoinPermissionRequest, callback func(response *DeleteLocalJoinPermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLocalJoinPermissionResponse
		var err error
		defer close(result)
		response, err = client.DeleteLocalJoinPermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLocalJoinPermissionRequest is the request struct for api DeleteLocalJoinPermission
type DeleteLocalJoinPermissionRequest struct {
	*requests.RpcRequest
	JoinPermissionId string `position:"Query" name:"JoinPermissionId"`
	IotInstanceId    string `position:"Query" name:"IotInstanceId"`
	ApiProduct       string `position:"Body" name:"ApiProduct"`
	ApiRevision      string `position:"Body" name:"ApiRevision"`
}

// DeleteLocalJoinPermissionResponse is the response struct for api DeleteLocalJoinPermission
type DeleteLocalJoinPermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteLocalJoinPermissionRequest creates a request to invoke DeleteLocalJoinPermission API
func CreateDeleteLocalJoinPermissionRequest() (request *DeleteLocalJoinPermissionRequest) {
	request = &DeleteLocalJoinPermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "DeleteLocalJoinPermission", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLocalJoinPermissionResponse creates a response to parse from DeleteLocalJoinPermission response
func CreateDeleteLocalJoinPermissionResponse() (response *DeleteLocalJoinPermissionResponse) {
	response = &DeleteLocalJoinPermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
