package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTag invokes the dm.ModifyTag API synchronously
// api document: https://help.aliyun.com/api/dm/modifytag.html
func (client *Client) ModifyTag(request *ModifyTagRequest) (response *ModifyTagResponse, err error) {
	response = CreateModifyTagResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTagWithChan invokes the dm.ModifyTag API asynchronously
// api document: https://help.aliyun.com/api/dm/modifytag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyTagWithChan(request *ModifyTagRequest) (<-chan *ModifyTagResponse, <-chan error) {
	responseChan := make(chan *ModifyTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTagWithCallback invokes the dm.ModifyTag API asynchronously
// api document: https://help.aliyun.com/api/dm/modifytag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyTagWithCallback(request *ModifyTagRequest, callback func(response *ModifyTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTagResponse
		var err error
		defer close(result)
		response, err = client.ModifyTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTagRequest is the request struct for api ModifyTag
type ModifyTagRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TagId                requests.Integer `position:"Query" name:"TagId"`
	TagName              string           `position:"Query" name:"TagName"`
}

// ModifyTagResponse is the response struct for api ModifyTag
type ModifyTagResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyTagRequest creates a request to invoke ModifyTag API
func CreateModifyTagRequest() (request *ModifyTagRequest) {
	request = &ModifyTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "ModifyTag", "", "")
	return
}

// CreateModifyTagResponse creates a response to parse from ModifyTag response
func CreateModifyTagResponse() (response *ModifyTagResponse) {
	response = &ModifyTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
