package batch

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccountKeyType enumerates the values for account key type.
type AccountKeyType string

const (
	// Primary The primary account key.
	Primary AccountKeyType = "Primary"
	// Secondary The secondary account key.
	Secondary AccountKeyType = "Secondary"
)

// PossibleAccountKeyTypeValues returns an array of possible values for the AccountKeyType const type.
func PossibleAccountKeyTypeValues() []AccountKeyType {
	return []AccountKeyType{Primary, Secondary}
}

// AllocationState enumerates the values for allocation state.
type AllocationState string

const (
	// Resizing The pool is resizing; that is, compute nodes are being added to or removed from the pool.
	Resizing AllocationState = "Resizing"
	// Steady The pool is not resizing. There are no changes to the number of nodes in the pool in progress. A
	// pool enters this state when it is created and when no operations are being performed on the pool to
	// change the number of nodes.
	Steady AllocationState = "Steady"
	// Stopping The pool was resizing, but the user has requested that the resize be stopped, but the stop
	// request has not yet been completed.
	Stopping AllocationState = "Stopping"
)

// PossibleAllocationStateValues returns an array of possible values for the AllocationState const type.
func PossibleAllocationStateValues() []AllocationState {
	return []AllocationState{Resizing, Steady, Stopping}
}

// AutoUserScope enumerates the values for auto user scope.
type AutoUserScope string

const (
	// AutoUserScopePool Specifies that the task runs as the common auto user account which is created on every
	// node in a pool.
	AutoUserScopePool AutoUserScope = "Pool"
	// AutoUserScopeTask Specifies that the service should create a new user for the task.
	AutoUserScopeTask AutoUserScope = "Task"
)

// PossibleAutoUserScopeValues returns an array of possible values for the AutoUserScope const type.
func PossibleAutoUserScopeValues() []AutoUserScope {
	return []AutoUserScope{AutoUserScopePool, AutoUserScopeTask}
}

// CachingType enumerates the values for caching type.
type CachingType string

const (
	// None The caching mode for the disk is not enabled.
	None CachingType = "None"
	// ReadOnly The caching mode for the disk is read only.
	ReadOnly CachingType = "ReadOnly"
	// ReadWrite The caching mode for the disk is read and write.
	ReadWrite CachingType = "ReadWrite"
)

// PossibleCachingTypeValues returns an array of possible values for the CachingType const type.
func PossibleCachingTypeValues() []CachingType {
	return []CachingType{None, ReadOnly, ReadWrite}
}

// CertificateFormat enumerates the values for certificate format.
type CertificateFormat string

const (
	// Cer The certificate is a base64-encoded X.509 certificate.
	Cer CertificateFormat = "Cer"
	// Pfx The certificate is a PFX (PKCS#12) formatted certificate or certificate chain.
	Pfx CertificateFormat = "Pfx"
)

// PossibleCertificateFormatValues returns an array of possible values for the CertificateFormat const type.
func PossibleCertificateFormatValues() []CertificateFormat {
	return []CertificateFormat{Cer, Pfx}
}

// CertificateProvisioningState enumerates the values for certificate provisioning state.
type CertificateProvisioningState string

const (
	// Deleting The user has requested that the certificate be deleted, but the delete operation has not yet
	// completed. You may not reference the certificate when creating or updating pools.
	Deleting CertificateProvisioningState = "Deleting"
	// Failed The user requested that the certificate be deleted, but there are pools that still have
	// references to the certificate, or it is still installed on one or more compute nodes. (The latter can
	// occur if the certificate has been removed from the pool, but the node has not yet restarted. Nodes
	// refresh their certificates only when they restart.) You may use the cancel certificate delete operation
	// to cancel the delete, or the delete certificate operation to retry the delete.
	Failed CertificateProvisioningState = "Failed"
	// Succeeded The certificate is available for use in pools.
	Succeeded CertificateProvisioningState = "Succeeded"
)

// PossibleCertificateProvisioningStateValues returns an array of possible values for the CertificateProvisioningState const type.
func PossibleCertificateProvisioningStateValues() []CertificateProvisioningState {
	return []CertificateProvisioningState{Deleting, Failed, Succeeded}
}

// CertificateStoreLocation enumerates the values for certificate store location.
type CertificateStoreLocation string

const (
	// CurrentUser Certificates should be installed to the CurrentUser certificate store.
	CurrentUser CertificateStoreLocation = "CurrentUser"
	// LocalMachine Certificates should be installed to the LocalMachine certificate store.
	LocalMachine CertificateStoreLocation = "LocalMachine"
)

// PossibleCertificateStoreLocationValues returns an array of possible values for the CertificateStoreLocation const type.
func PossibleCertificateStoreLocationValues() []CertificateStoreLocation {
	return []CertificateStoreLocation{CurrentUser, LocalMachine}
}

// CertificateVisibility enumerates the values for certificate visibility.
type CertificateVisibility string

const (
	// CertificateVisibilityRemoteUser The certificate should be visible to the user accounts under which users
	// remotely access the node.
	CertificateVisibilityRemoteUser CertificateVisibility = "RemoteUser"
	// CertificateVisibilityStartTask The certificate should be visible to the user account under which the
	// start task is run. Note that if AutoUser Scope is Pool for both the StartTask and a Task, this
	// certificate will be visible to the Task as well.
	CertificateVisibilityStartTask CertificateVisibility = "StartTask"
	// CertificateVisibilityTask The certificate should be visible to the user accounts under which job tasks
	// are run.
	CertificateVisibilityTask CertificateVisibility = "Task"
)

// PossibleCertificateVisibilityValues returns an array of possible values for the CertificateVisibility const type.
func PossibleCertificateVisibilityValues() []CertificateVisibility {
	return []CertificateVisibility{CertificateVisibilityRemoteUser, CertificateVisibilityStartTask, CertificateVisibilityTask}
}

// ComputeNodeDeallocationOption enumerates the values for compute node deallocation option.
type ComputeNodeDeallocationOption string

const (
	// Requeue Terminate running task processes and requeue the tasks. The tasks will run again when a node is
	// available. Remove nodes as soon as tasks have been terminated.
	Requeue ComputeNodeDeallocationOption = "Requeue"
	// RetainedData Allow currently running tasks to complete, then wait for all task data retention periods to
	// expire. Schedule no new tasks while waiting. Remove nodes when all task retention periods have expired.
	RetainedData ComputeNodeDeallocationOption = "RetainedData"
	// TaskCompletion Allow currently running tasks to complete. Schedule no new tasks while waiting. Remove
	// nodes when all tasks have completed.
	TaskCompletion ComputeNodeDeallocationOption = "TaskCompletion"
	// Terminate Terminate running tasks. The tasks will be completed with failureInfo indicating that they
	// were terminated, and will not run again. Remove nodes as soon as tasks have been terminated.
	Terminate ComputeNodeDeallocationOption = "Terminate"
)

// PossibleComputeNodeDeallocationOptionValues returns an array of possible values for the ComputeNodeDeallocationOption const type.
func PossibleComputeNodeDeallocationOptionValues() []ComputeNodeDeallocationOption {
	return []ComputeNodeDeallocationOption{Requeue, RetainedData, TaskCompletion, Terminate}
}

// ComputeNodeFillType enumerates the values for compute node fill type.
type ComputeNodeFillType string

const (
	// Pack As many tasks as possible (maxTasksPerNode) should be assigned to each node in the pool before any
	// tasks are assigned to the next node in the pool.
	Pack ComputeNodeFillType = "Pack"
	// Spread Tasks should be assigned evenly across all nodes in the pool.
	Spread ComputeNodeFillType = "Spread"
)

// PossibleComputeNodeFillTypeValues returns an array of possible values for the ComputeNodeFillType const type.
func PossibleComputeNodeFillTypeValues() []ComputeNodeFillType {
	return []ComputeNodeFillType{Pack, Spread}
}

// ContainerWorkingDirectory enumerates the values for container working directory.
type ContainerWorkingDirectory string

const (
	// ContainerImageDefault Using container image defined working directory. Beware that this directory will
	// not contain the resource files downloaded by Batch.
	ContainerImageDefault ContainerWorkingDirectory = "ContainerImageDefault"
	// TaskWorkingDirectory Use the standard Batch service task working directory, which will contain the Task
	// resource files populated by Batch.
	TaskWorkingDirectory ContainerWorkingDirectory = "TaskWorkingDirectory"
)

// PossibleContainerWorkingDirectoryValues returns an array of possible values for the ContainerWorkingDirectory const type.
func PossibleContainerWorkingDirectoryValues() []ContainerWorkingDirectory {
	return []ContainerWorkingDirectory{ContainerImageDefault, TaskWorkingDirectory}
}

// DiskEncryptionTarget enumerates the values for disk encryption target.
type DiskEncryptionTarget string

const (
	// OsDisk The OS Disk on the compute node is encrypted.
	OsDisk DiskEncryptionTarget = "OsDisk"
	// TemporaryDisk The temporary disk on the compute node is encrypted. On Linux this encryption applies to
	// other partitions (such as those on mounted data disks) when encryption occurs at boot time.
	TemporaryDisk DiskEncryptionTarget = "TemporaryDisk"
)

// PossibleDiskEncryptionTargetValues returns an array of possible values for the DiskEncryptionTarget const type.
func PossibleDiskEncryptionTargetValues() []DiskEncryptionTarget {
	return []DiskEncryptionTarget{OsDisk, TemporaryDisk}
}

// ElevationLevel enumerates the values for elevation level.
type ElevationLevel string

const (
	// Admin The user is a user with elevated access and operates with full Administrator permissions.
	Admin ElevationLevel = "Admin"
	// NonAdmin The user is a standard user without elevated access.
	NonAdmin ElevationLevel = "NonAdmin"
)

// PossibleElevationLevelValues returns an array of possible values for the ElevationLevel const type.
func PossibleElevationLevelValues() []ElevationLevel {
	return []ElevationLevel{Admin, NonAdmin}
}

// InboundEndpointProtocol enumerates the values for inbound endpoint protocol.
type InboundEndpointProtocol string

const (
	// TCP Use TCP for the endpoint.
	TCP InboundEndpointProtocol = "TCP"
	// UDP Use UDP for the endpoint.
	UDP InboundEndpointProtocol = "UDP"
)

// PossibleInboundEndpointProtocolValues returns an array of possible values for the InboundEndpointProtocol const type.
func PossibleInboundEndpointProtocolValues() []InboundEndpointProtocol {
	return []InboundEndpointProtocol{TCP, UDP}
}

// InterNodeCommunicationState enumerates the values for inter node communication state.
type InterNodeCommunicationState string

const (
	// Disabled Disable network communication between virtual machines.
	Disabled InterNodeCommunicationState = "Disabled"
	// Enabled Enable network communication between virtual machines.
	Enabled InterNodeCommunicationState = "Enabled"
)

// PossibleInterNodeCommunicationStateValues returns an array of possible values for the InterNodeCommunicationState const type.
func PossibleInterNodeCommunicationStateValues() []InterNodeCommunicationState {
	return []InterNodeCommunicationState{Disabled, Enabled}
}

// IPAddressProvisioningType enumerates the values for ip address provisioning type.
type IPAddressProvisioningType string

const (
	// BatchManaged A public IP will be created and managed by Batch. There may be multiple public IPs
	// depending on the size of the Pool.
	BatchManaged IPAddressProvisioningType = "BatchManaged"
	// NoPublicIPAddresses No public IP Address will be created for the Compute Nodes in the Pool.
	NoPublicIPAddresses IPAddressProvisioningType = "NoPublicIPAddresses"
	// UserManaged Public IPs are provided by the user and will be used to provision the Compute Nodes.
	UserManaged IPAddressProvisioningType = "UserManaged"
)

// PossibleIPAddressProvisioningTypeValues returns an array of possible values for the IPAddressProvisioningType const type.
func PossibleIPAddressProvisioningTypeValues() []IPAddressProvisioningType {
	return []IPAddressProvisioningType{BatchManaged, NoPublicIPAddresses, UserManaged}
}

// KeySource enumerates the values for key source.
type KeySource string

const (
	// MicrosoftBatch Batch creates and manages the encryption keys used to protect the account data.
	MicrosoftBatch KeySource = "Microsoft.Batch"
	// MicrosoftKeyVault The encryption keys used to protect the account data are stored in an external key
	// vault. If this is set then the Batch Account identity must be set to `SystemAssigned` and a valid Key
	// Identifier must also be supplied under the keyVaultProperties.
	MicrosoftKeyVault KeySource = "Microsoft.KeyVault"
)

// PossibleKeySourceValues returns an array of possible values for the KeySource const type.
func PossibleKeySourceValues() []KeySource {
	return []KeySource{MicrosoftBatch, MicrosoftKeyVault}
}

// LoginMode enumerates the values for login mode.
type LoginMode string

const (
	// Batch The LOGON32_LOGON_BATCH Win32 login mode. The batch login mode is recommended for long running
	// parallel processes.
	Batch LoginMode = "Batch"
	// Interactive The LOGON32_LOGON_INTERACTIVE Win32 login mode. Some applications require having permissions
	// associated with the interactive login mode. If this is the case for an application used in your task,
	// then this option is recommended.
	Interactive LoginMode = "Interactive"
)

// PossibleLoginModeValues returns an array of possible values for the LoginMode const type.
func PossibleLoginModeValues() []LoginMode {
	return []LoginMode{Batch, Interactive}
}

// NameAvailabilityReason enumerates the values for name availability reason.
type NameAvailabilityReason string

const (
	// AlreadyExists The requested name is already in use.
	AlreadyExists NameAvailabilityReason = "AlreadyExists"
	// Invalid The requested name is invalid.
	Invalid NameAvailabilityReason = "Invalid"
)

// PossibleNameAvailabilityReasonValues returns an array of possible values for the NameAvailabilityReason const type.
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return []NameAvailabilityReason{AlreadyExists, Invalid}
}

// NetworkSecurityGroupRuleAccess enumerates the values for network security group rule access.
type NetworkSecurityGroupRuleAccess string

const (
	// Allow Allow access.
	Allow NetworkSecurityGroupRuleAccess = "Allow"
	// Deny Deny access.
	Deny NetworkSecurityGroupRuleAccess = "Deny"
)

// PossibleNetworkSecurityGroupRuleAccessValues returns an array of possible values for the NetworkSecurityGroupRuleAccess const type.
func PossibleNetworkSecurityGroupRuleAccessValues() []NetworkSecurityGroupRuleAccess {
	return []NetworkSecurityGroupRuleAccess{Allow, Deny}
}

// PackageState enumerates the values for package state.
type PackageState string

const (
	// Active The application package is ready for use.
	Active PackageState = "Active"
	// Pending The application package has been created but has not yet been activated.
	Pending PackageState = "Pending"
)

// PossiblePackageStateValues returns an array of possible values for the PackageState const type.
func PossiblePackageStateValues() []PackageState {
	return []PackageState{Active, Pending}
}

// PoolAllocationMode enumerates the values for pool allocation mode.
type PoolAllocationMode string

const (
	// BatchService Pools will be allocated in subscriptions owned by the Batch service.
	BatchService PoolAllocationMode = "BatchService"
	// UserSubscription Pools will be allocated in a subscription owned by the user.
	UserSubscription PoolAllocationMode = "UserSubscription"
)

// PossiblePoolAllocationModeValues returns an array of possible values for the PoolAllocationMode const type.
func PossiblePoolAllocationModeValues() []PoolAllocationMode {
	return []PoolAllocationMode{BatchService, UserSubscription}
}

// PoolProvisioningState enumerates the values for pool provisioning state.
type PoolProvisioningState string

const (
	// PoolProvisioningStateDeleting The user has requested that the pool be deleted, but the delete operation
	// has not yet completed.
	PoolProvisioningStateDeleting PoolProvisioningState = "Deleting"
	// PoolProvisioningStateSucceeded The pool is available to run tasks subject to the availability of compute
	// nodes.
	PoolProvisioningStateSucceeded PoolProvisioningState = "Succeeded"
)

// PossiblePoolProvisioningStateValues returns an array of possible values for the PoolProvisioningState const type.
func PossiblePoolProvisioningStateValues() []PoolProvisioningState {
	return []PoolProvisioningState{PoolProvisioningStateDeleting, PoolProvisioningStateSucceeded}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// PrivateEndpointConnectionProvisioningStateFailed The user requested that the connection be updated and
	// it failed. You may retry the update operation.
	PrivateEndpointConnectionProvisioningStateFailed PrivateEndpointConnectionProvisioningState = "Failed"
	// PrivateEndpointConnectionProvisioningStateSucceeded The connection status is final and is ready for use
	// if Status is Approved.
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
	// PrivateEndpointConnectionProvisioningStateUpdating The user has requested that the connection status be
	// updated, but the update operation has not yet completed. You may not reference the connection when
	// connecting the Batch account.
	PrivateEndpointConnectionProvisioningStateUpdating PrivateEndpointConnectionProvisioningState = "Updating"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{PrivateEndpointConnectionProvisioningStateFailed, PrivateEndpointConnectionProvisioningStateSucceeded, PrivateEndpointConnectionProvisioningStateUpdating}
}

// PrivateLinkServiceConnectionStatus enumerates the values for private link service connection status.
type PrivateLinkServiceConnectionStatus string

const (
	// PrivateLinkServiceConnectionStatusApproved The private endpoint connection is approved and can be used
	// to access Batch account
	PrivateLinkServiceConnectionStatusApproved PrivateLinkServiceConnectionStatus = "Approved"
	// PrivateLinkServiceConnectionStatusDisconnected The private endpoint connection is disconnected and
	// cannot be used to access Batch account
	PrivateLinkServiceConnectionStatusDisconnected PrivateLinkServiceConnectionStatus = "Disconnected"
	// PrivateLinkServiceConnectionStatusPending The private endpoint connection is pending and cannot be used
	// to access Batch account
	PrivateLinkServiceConnectionStatusPending PrivateLinkServiceConnectionStatus = "Pending"
	// PrivateLinkServiceConnectionStatusRejected The private endpoint connection is rejected and cannot be
	// used to access Batch account
	PrivateLinkServiceConnectionStatusRejected PrivateLinkServiceConnectionStatus = "Rejected"
)

// PossiblePrivateLinkServiceConnectionStatusValues returns an array of possible values for the PrivateLinkServiceConnectionStatus const type.
func PossiblePrivateLinkServiceConnectionStatusValues() []PrivateLinkServiceConnectionStatus {
	return []PrivateLinkServiceConnectionStatus{PrivateLinkServiceConnectionStatusApproved, PrivateLinkServiceConnectionStatusDisconnected, PrivateLinkServiceConnectionStatusPending, PrivateLinkServiceConnectionStatusRejected}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCancelled The last operation for the account is cancelled.
	ProvisioningStateCancelled ProvisioningState = "Cancelled"
	// ProvisioningStateCreating The account is being created.
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting The account is being deleted.
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed The last operation for the account is failed.
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInvalid The account is in an invalid state.
	ProvisioningStateInvalid ProvisioningState = "Invalid"
	// ProvisioningStateSucceeded The account has been created and is ready for use.
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCancelled, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateInvalid, ProvisioningStateSucceeded}
}

// PublicNetworkAccessType enumerates the values for public network access type.
type PublicNetworkAccessType string

const (
	// PublicNetworkAccessTypeDisabled Disables public connectivity and enables private connectivity to Azure
	// Batch Service through private endpoint resource.
	PublicNetworkAccessTypeDisabled PublicNetworkAccessType = "Disabled"
	// PublicNetworkAccessTypeEnabled Enables connectivity to Azure Batch through public DNS.
	PublicNetworkAccessTypeEnabled PublicNetworkAccessType = "Enabled"
)

// PossiblePublicNetworkAccessTypeValues returns an array of possible values for the PublicNetworkAccessType const type.
func PossiblePublicNetworkAccessTypeValues() []PublicNetworkAccessType {
	return []PublicNetworkAccessType{PublicNetworkAccessTypeDisabled, PublicNetworkAccessTypeEnabled}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone Batch account has no identity associated with it. Setting `None` in update
	// account will remove existing identities.
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned Batch account has a system assigned identity with it.
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned}
}

// StorageAccountType enumerates the values for storage account type.
type StorageAccountType string

const (
	// PremiumLRS The data disk should use premium locally redundant storage.
	PremiumLRS StorageAccountType = "Premium_LRS"
	// StandardLRS The data disk should use standard locally redundant storage.
	StandardLRS StorageAccountType = "Standard_LRS"
)

// PossibleStorageAccountTypeValues returns an array of possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{PremiumLRS, StandardLRS}
}
