// Code generated by protoc-gen-go. DO NOT EDIT.
// source: vtgate.proto

package vtgate // import "vitess.io/vitess/go/vt/proto/vtgate"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import query "vitess.io/vitess/go/vt/proto/query"
import topodata "vitess.io/vitess/go/vt/proto/topodata"
import vtrpc "vitess.io/vitess/go/vt/proto/vtrpc"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// TransactionMode controls the execution of distributed transaction
// across multiple shards.
type TransactionMode int32

const (
	// UNSPECIFIED uses the transaction mode set by the VTGate flag 'transaction_mode'.
	TransactionMode_UNSPECIFIED TransactionMode = 0
	// SINGLE disallows distributed transactions.
	TransactionMode_SINGLE TransactionMode = 1
	// MULTI allows distributed transactions with best effort commit.
	TransactionMode_MULTI TransactionMode = 2
	// TWOPC is for distributed transactions with atomic commits.
	TransactionMode_TWOPC TransactionMode = 3
)

var TransactionMode_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "SINGLE",
	2: "MULTI",
	3: "TWOPC",
}
var TransactionMode_value = map[string]int32{
	"UNSPECIFIED": 0,
	"SINGLE":      1,
	"MULTI":       2,
	"TWOPC":       3,
}

func (x TransactionMode) String() string {
	return proto.EnumName(TransactionMode_name, int32(x))
}
func (TransactionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{0}
}

// Session objects are exchanged like cookies through various
// calls to VTGate. The behavior differs between V2 & V3 APIs.
// V3 APIs are Execute, ExecuteBatch and StreamExecute. All
// other APIs are V2. For the V3 APIs, the session
// must be sent with every call to Execute or ExecuteBatch.
// For the V2 APIs, Begin does not accept a session. It instead
// returns a brand new one with in_transaction set to true.
// After a call to Commit or Rollback, the session can be
// discarded. If you're not in a transaction, Session is
// an optional parameter for the V2 APIs.
type Session struct {
	// in_transaction is set to true if the session is in a transaction.
	InTransaction bool `protobuf:"varint,1,opt,name=in_transaction,json=inTransaction" json:"in_transaction,omitempty"`
	// shard_sessions keep track of per-shard transaction info.
	ShardSessions []*Session_ShardSession `protobuf:"bytes,2,rep,name=shard_sessions,json=shardSessions" json:"shard_sessions,omitempty"`
	// single_db is deprecated. Use transaction_mode instead.
	// The value specifies if the transaction should be restricted
	// to a single shard.
	// TODO(sougou): remove in 3.1
	SingleDb bool `protobuf:"varint,3,opt,name=single_db,json=singleDb" json:"single_db,omitempty"`
	// autocommit specifies if the session is in autocommit mode.
	// This is used only for V3.
	Autocommit bool `protobuf:"varint,4,opt,name=autocommit" json:"autocommit,omitempty"`
	// target_string is the target expressed as a string. Valid
	// names are: keyspace:shard@target, keyspace@target or @target.
	// This is used only for V3.
	TargetString string `protobuf:"bytes,5,opt,name=target_string,json=targetString" json:"target_string,omitempty"`
	// options is used only for V3.
	Options *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
	// transaction_mode specifies the current transaction mode.
	TransactionMode      TransactionMode `protobuf:"varint,7,opt,name=transaction_mode,json=transactionMode,enum=vtgate.TransactionMode" json:"transaction_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Session) Reset()         { *m = Session{} }
func (m *Session) String() string { return proto.CompactTextString(m) }
func (*Session) ProtoMessage()    {}
func (*Session) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{0}
}
func (m *Session) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Session.Unmarshal(m, b)
}
func (m *Session) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Session.Marshal(b, m, deterministic)
}
func (dst *Session) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Session.Merge(dst, src)
}
func (m *Session) XXX_Size() int {
	return xxx_messageInfo_Session.Size(m)
}
func (m *Session) XXX_DiscardUnknown() {
	xxx_messageInfo_Session.DiscardUnknown(m)
}

var xxx_messageInfo_Session proto.InternalMessageInfo

func (m *Session) GetInTransaction() bool {
	if m != nil {
		return m.InTransaction
	}
	return false
}

func (m *Session) GetShardSessions() []*Session_ShardSession {
	if m != nil {
		return m.ShardSessions
	}
	return nil
}

func (m *Session) GetSingleDb() bool {
	if m != nil {
		return m.SingleDb
	}
	return false
}

func (m *Session) GetAutocommit() bool {
	if m != nil {
		return m.Autocommit
	}
	return false
}

func (m *Session) GetTargetString() string {
	if m != nil {
		return m.TargetString
	}
	return ""
}

func (m *Session) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *Session) GetTransactionMode() TransactionMode {
	if m != nil {
		return m.TransactionMode
	}
	return TransactionMode_UNSPECIFIED
}

type Session_ShardSession struct {
	Target               *query.Target `protobuf:"bytes,1,opt,name=target" json:"target,omitempty"`
	TransactionId        int64         `protobuf:"varint,2,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Session_ShardSession) Reset()         { *m = Session_ShardSession{} }
func (m *Session_ShardSession) String() string { return proto.CompactTextString(m) }
func (*Session_ShardSession) ProtoMessage()    {}
func (*Session_ShardSession) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{0, 0}
}
func (m *Session_ShardSession) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Session_ShardSession.Unmarshal(m, b)
}
func (m *Session_ShardSession) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Session_ShardSession.Marshal(b, m, deterministic)
}
func (dst *Session_ShardSession) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Session_ShardSession.Merge(dst, src)
}
func (m *Session_ShardSession) XXX_Size() int {
	return xxx_messageInfo_Session_ShardSession.Size(m)
}
func (m *Session_ShardSession) XXX_DiscardUnknown() {
	xxx_messageInfo_Session_ShardSession.DiscardUnknown(m)
}

var xxx_messageInfo_Session_ShardSession proto.InternalMessageInfo

func (m *Session_ShardSession) GetTarget() *query.Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *Session_ShardSession) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// ExecuteRequest is the payload to Execute.
type ExecuteRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the session state.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// These values are deprecated. Use session instead.
	// TODO(sougou): remove in 3.1
	TabletType           topodata.TabletType   `protobuf:"varint,4,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	NotInTransaction     bool                  `protobuf:"varint,5,opt,name=not_in_transaction,json=notInTransaction" json:"not_in_transaction,omitempty"`
	KeyspaceShard        string                `protobuf:"bytes,6,opt,name=keyspace_shard,json=keyspaceShard" json:"keyspace_shard,omitempty"`
	Options              *query.ExecuteOptions `protobuf:"bytes,7,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExecuteRequest) Reset()         { *m = ExecuteRequest{} }
func (m *ExecuteRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteRequest) ProtoMessage()    {}
func (*ExecuteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{1}
}
func (m *ExecuteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteRequest.Unmarshal(m, b)
}
func (m *ExecuteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteRequest.Marshal(b, m, deterministic)
}
func (dst *ExecuteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteRequest.Merge(dst, src)
}
func (m *ExecuteRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteRequest.Size(m)
}
func (m *ExecuteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteRequest proto.InternalMessageInfo

func (m *ExecuteRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteRequest) GetNotInTransaction() bool {
	if m != nil {
		return m.NotInTransaction
	}
	return false
}

func (m *ExecuteRequest) GetKeyspaceShard() string {
	if m != nil {
		return m.KeyspaceShard
	}
	return ""
}

func (m *ExecuteRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteResponse is the returned value from Execute.
type ExecuteResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result               *query.QueryResult `protobuf:"bytes,3,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ExecuteResponse) Reset()         { *m = ExecuteResponse{} }
func (m *ExecuteResponse) String() string { return proto.CompactTextString(m) }
func (*ExecuteResponse) ProtoMessage()    {}
func (*ExecuteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{2}
}
func (m *ExecuteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteResponse.Unmarshal(m, b)
}
func (m *ExecuteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteResponse.Marshal(b, m, deterministic)
}
func (dst *ExecuteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteResponse.Merge(dst, src)
}
func (m *ExecuteResponse) XXX_Size() int {
	return xxx_messageInfo_ExecuteResponse.Size(m)
}
func (m *ExecuteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteResponse proto.InternalMessageInfo

func (m *ExecuteResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteShardsRequest is the payload to ExecuteShards.
type ExecuteShardsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,4,opt,name=keyspace" json:"keyspace,omitempty"`
	// shards to target the query to. A DML can only target one shard.
	Shards []string `protobuf:"bytes,5,rep,name=shards" json:"shards,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,6,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated.
	NotInTransaction bool `protobuf:"varint,7,opt,name=not_in_transaction,json=notInTransaction" json:"not_in_transaction,omitempty"`
	// options
	Options              *query.ExecuteOptions `protobuf:"bytes,8,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExecuteShardsRequest) Reset()         { *m = ExecuteShardsRequest{} }
func (m *ExecuteShardsRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteShardsRequest) ProtoMessage()    {}
func (*ExecuteShardsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{3}
}
func (m *ExecuteShardsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteShardsRequest.Unmarshal(m, b)
}
func (m *ExecuteShardsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteShardsRequest.Marshal(b, m, deterministic)
}
func (dst *ExecuteShardsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteShardsRequest.Merge(dst, src)
}
func (m *ExecuteShardsRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteShardsRequest.Size(m)
}
func (m *ExecuteShardsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteShardsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteShardsRequest proto.InternalMessageInfo

func (m *ExecuteShardsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteShardsRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteShardsRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteShardsRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *ExecuteShardsRequest) GetShards() []string {
	if m != nil {
		return m.Shards
	}
	return nil
}

func (m *ExecuteShardsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteShardsRequest) GetNotInTransaction() bool {
	if m != nil {
		return m.NotInTransaction
	}
	return false
}

func (m *ExecuteShardsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteShardsResponse is the returned value from ExecuteShards.
type ExecuteShardsResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result               *query.QueryResult `protobuf:"bytes,3,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ExecuteShardsResponse) Reset()         { *m = ExecuteShardsResponse{} }
func (m *ExecuteShardsResponse) String() string { return proto.CompactTextString(m) }
func (*ExecuteShardsResponse) ProtoMessage()    {}
func (*ExecuteShardsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{4}
}
func (m *ExecuteShardsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteShardsResponse.Unmarshal(m, b)
}
func (m *ExecuteShardsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteShardsResponse.Marshal(b, m, deterministic)
}
func (dst *ExecuteShardsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteShardsResponse.Merge(dst, src)
}
func (m *ExecuteShardsResponse) XXX_Size() int {
	return xxx_messageInfo_ExecuteShardsResponse.Size(m)
}
func (m *ExecuteShardsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteShardsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteShardsResponse proto.InternalMessageInfo

func (m *ExecuteShardsResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteShardsResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteShardsResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteKeyspaceIdsRequest is the payload to ExecuteKeyspaceIds.
type ExecuteKeyspaceIdsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,4,opt,name=keyspace" json:"keyspace,omitempty"`
	// keyspace_ids contains the list of keyspace_ids affected by this query.
	// Will be used to find the shards to send the query to.
	KeyspaceIds [][]byte `protobuf:"bytes,5,rep,name=keyspace_ids,json=keyspaceIds,proto3" json:"keyspace_ids,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,6,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated.
	NotInTransaction bool `protobuf:"varint,7,opt,name=not_in_transaction,json=notInTransaction" json:"not_in_transaction,omitempty"`
	// options
	Options              *query.ExecuteOptions `protobuf:"bytes,8,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExecuteKeyspaceIdsRequest) Reset()         { *m = ExecuteKeyspaceIdsRequest{} }
func (m *ExecuteKeyspaceIdsRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteKeyspaceIdsRequest) ProtoMessage()    {}
func (*ExecuteKeyspaceIdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{5}
}
func (m *ExecuteKeyspaceIdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteKeyspaceIdsRequest.Unmarshal(m, b)
}
func (m *ExecuteKeyspaceIdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteKeyspaceIdsRequest.Marshal(b, m, deterministic)
}
func (dst *ExecuteKeyspaceIdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteKeyspaceIdsRequest.Merge(dst, src)
}
func (m *ExecuteKeyspaceIdsRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteKeyspaceIdsRequest.Size(m)
}
func (m *ExecuteKeyspaceIdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteKeyspaceIdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteKeyspaceIdsRequest proto.InternalMessageInfo

func (m *ExecuteKeyspaceIdsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteKeyspaceIdsRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteKeyspaceIdsRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteKeyspaceIdsRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *ExecuteKeyspaceIdsRequest) GetKeyspaceIds() [][]byte {
	if m != nil {
		return m.KeyspaceIds
	}
	return nil
}

func (m *ExecuteKeyspaceIdsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteKeyspaceIdsRequest) GetNotInTransaction() bool {
	if m != nil {
		return m.NotInTransaction
	}
	return false
}

func (m *ExecuteKeyspaceIdsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteKeyspaceIdsResponse is the returned value from ExecuteKeyspaceIds.
type ExecuteKeyspaceIdsResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result               *query.QueryResult `protobuf:"bytes,3,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ExecuteKeyspaceIdsResponse) Reset()         { *m = ExecuteKeyspaceIdsResponse{} }
func (m *ExecuteKeyspaceIdsResponse) String() string { return proto.CompactTextString(m) }
func (*ExecuteKeyspaceIdsResponse) ProtoMessage()    {}
func (*ExecuteKeyspaceIdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{6}
}
func (m *ExecuteKeyspaceIdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteKeyspaceIdsResponse.Unmarshal(m, b)
}
func (m *ExecuteKeyspaceIdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteKeyspaceIdsResponse.Marshal(b, m, deterministic)
}
func (dst *ExecuteKeyspaceIdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteKeyspaceIdsResponse.Merge(dst, src)
}
func (m *ExecuteKeyspaceIdsResponse) XXX_Size() int {
	return xxx_messageInfo_ExecuteKeyspaceIdsResponse.Size(m)
}
func (m *ExecuteKeyspaceIdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteKeyspaceIdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteKeyspaceIdsResponse proto.InternalMessageInfo

func (m *ExecuteKeyspaceIdsResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteKeyspaceIdsResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteKeyspaceIdsResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteKeyRangesRequest is the payload to ExecuteKeyRanges.
type ExecuteKeyRangesRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to
	Keyspace string `protobuf:"bytes,4,opt,name=keyspace" json:"keyspace,omitempty"`
	// key_ranges contains the list of key ranges affected by this query.
	// Will be used to find the shards to send the query to.
	KeyRanges []*topodata.KeyRange `protobuf:"bytes,5,rep,name=key_ranges,json=keyRanges" json:"key_ranges,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,6,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated.
	NotInTransaction bool `protobuf:"varint,7,opt,name=not_in_transaction,json=notInTransaction" json:"not_in_transaction,omitempty"`
	// options
	Options              *query.ExecuteOptions `protobuf:"bytes,8,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExecuteKeyRangesRequest) Reset()         { *m = ExecuteKeyRangesRequest{} }
func (m *ExecuteKeyRangesRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteKeyRangesRequest) ProtoMessage()    {}
func (*ExecuteKeyRangesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{7}
}
func (m *ExecuteKeyRangesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteKeyRangesRequest.Unmarshal(m, b)
}
func (m *ExecuteKeyRangesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteKeyRangesRequest.Marshal(b, m, deterministic)
}
func (dst *ExecuteKeyRangesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteKeyRangesRequest.Merge(dst, src)
}
func (m *ExecuteKeyRangesRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteKeyRangesRequest.Size(m)
}
func (m *ExecuteKeyRangesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteKeyRangesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteKeyRangesRequest proto.InternalMessageInfo

func (m *ExecuteKeyRangesRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteKeyRangesRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteKeyRangesRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteKeyRangesRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *ExecuteKeyRangesRequest) GetKeyRanges() []*topodata.KeyRange {
	if m != nil {
		return m.KeyRanges
	}
	return nil
}

func (m *ExecuteKeyRangesRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteKeyRangesRequest) GetNotInTransaction() bool {
	if m != nil {
		return m.NotInTransaction
	}
	return false
}

func (m *ExecuteKeyRangesRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteKeyRangesResponse is the returned value from ExecuteKeyRanges.
type ExecuteKeyRangesResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result               *query.QueryResult `protobuf:"bytes,3,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ExecuteKeyRangesResponse) Reset()         { *m = ExecuteKeyRangesResponse{} }
func (m *ExecuteKeyRangesResponse) String() string { return proto.CompactTextString(m) }
func (*ExecuteKeyRangesResponse) ProtoMessage()    {}
func (*ExecuteKeyRangesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{8}
}
func (m *ExecuteKeyRangesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteKeyRangesResponse.Unmarshal(m, b)
}
func (m *ExecuteKeyRangesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteKeyRangesResponse.Marshal(b, m, deterministic)
}
func (dst *ExecuteKeyRangesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteKeyRangesResponse.Merge(dst, src)
}
func (m *ExecuteKeyRangesResponse) XXX_Size() int {
	return xxx_messageInfo_ExecuteKeyRangesResponse.Size(m)
}
func (m *ExecuteKeyRangesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteKeyRangesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteKeyRangesResponse proto.InternalMessageInfo

func (m *ExecuteKeyRangesResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteKeyRangesResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteKeyRangesResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteEntityIdsRequest is the payload to ExecuteEntityIds.
type ExecuteEntityIdsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,4,opt,name=keyspace" json:"keyspace,omitempty"`
	// entity_column_name is the column name to use.
	EntityColumnName string `protobuf:"bytes,5,opt,name=entity_column_name,json=entityColumnName" json:"entity_column_name,omitempty"`
	// entity_keyspace_ids are pairs of entity_column_name values
	// associated with its corresponding keyspace_id.
	EntityKeyspaceIds []*ExecuteEntityIdsRequest_EntityId `protobuf:"bytes,6,rep,name=entity_keyspace_ids,json=entityKeyspaceIds" json:"entity_keyspace_ids,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,7,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated.
	NotInTransaction bool `protobuf:"varint,8,opt,name=not_in_transaction,json=notInTransaction" json:"not_in_transaction,omitempty"`
	// options
	Options              *query.ExecuteOptions `protobuf:"bytes,9,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExecuteEntityIdsRequest) Reset()         { *m = ExecuteEntityIdsRequest{} }
func (m *ExecuteEntityIdsRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteEntityIdsRequest) ProtoMessage()    {}
func (*ExecuteEntityIdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{9}
}
func (m *ExecuteEntityIdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteEntityIdsRequest.Unmarshal(m, b)
}
func (m *ExecuteEntityIdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteEntityIdsRequest.Marshal(b, m, deterministic)
}
func (dst *ExecuteEntityIdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteEntityIdsRequest.Merge(dst, src)
}
func (m *ExecuteEntityIdsRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteEntityIdsRequest.Size(m)
}
func (m *ExecuteEntityIdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteEntityIdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteEntityIdsRequest proto.InternalMessageInfo

func (m *ExecuteEntityIdsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteEntityIdsRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteEntityIdsRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteEntityIdsRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *ExecuteEntityIdsRequest) GetEntityColumnName() string {
	if m != nil {
		return m.EntityColumnName
	}
	return ""
}

func (m *ExecuteEntityIdsRequest) GetEntityKeyspaceIds() []*ExecuteEntityIdsRequest_EntityId {
	if m != nil {
		return m.EntityKeyspaceIds
	}
	return nil
}

func (m *ExecuteEntityIdsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteEntityIdsRequest) GetNotInTransaction() bool {
	if m != nil {
		return m.NotInTransaction
	}
	return false
}

func (m *ExecuteEntityIdsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

type ExecuteEntityIdsRequest_EntityId struct {
	// type is the type of the entity's value. Can be NULL_TYPE.
	Type query.Type `protobuf:"varint,1,opt,name=type,enum=query.Type" json:"type,omitempty"`
	// value is the value for the entity. Not set if type is NULL_TYPE.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// keyspace_id is the associated keyspace_id for the entity.
	KeyspaceId           []byte   `protobuf:"bytes,3,opt,name=keyspace_id,json=keyspaceId,proto3" json:"keyspace_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecuteEntityIdsRequest_EntityId) Reset()         { *m = ExecuteEntityIdsRequest_EntityId{} }
func (m *ExecuteEntityIdsRequest_EntityId) String() string { return proto.CompactTextString(m) }
func (*ExecuteEntityIdsRequest_EntityId) ProtoMessage()    {}
func (*ExecuteEntityIdsRequest_EntityId) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{9, 0}
}
func (m *ExecuteEntityIdsRequest_EntityId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteEntityIdsRequest_EntityId.Unmarshal(m, b)
}
func (m *ExecuteEntityIdsRequest_EntityId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteEntityIdsRequest_EntityId.Marshal(b, m, deterministic)
}
func (dst *ExecuteEntityIdsRequest_EntityId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteEntityIdsRequest_EntityId.Merge(dst, src)
}
func (m *ExecuteEntityIdsRequest_EntityId) XXX_Size() int {
	return xxx_messageInfo_ExecuteEntityIdsRequest_EntityId.Size(m)
}
func (m *ExecuteEntityIdsRequest_EntityId) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteEntityIdsRequest_EntityId.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteEntityIdsRequest_EntityId proto.InternalMessageInfo

func (m *ExecuteEntityIdsRequest_EntityId) GetType() query.Type {
	if m != nil {
		return m.Type
	}
	return query.Type_NULL_TYPE
}

func (m *ExecuteEntityIdsRequest_EntityId) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ExecuteEntityIdsRequest_EntityId) GetKeyspaceId() []byte {
	if m != nil {
		return m.KeyspaceId
	}
	return nil
}

// ExecuteEntityIdsResponse is the returned value from ExecuteEntityIds.
type ExecuteEntityIdsResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result               *query.QueryResult `protobuf:"bytes,3,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ExecuteEntityIdsResponse) Reset()         { *m = ExecuteEntityIdsResponse{} }
func (m *ExecuteEntityIdsResponse) String() string { return proto.CompactTextString(m) }
func (*ExecuteEntityIdsResponse) ProtoMessage()    {}
func (*ExecuteEntityIdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{10}
}
func (m *ExecuteEntityIdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteEntityIdsResponse.Unmarshal(m, b)
}
func (m *ExecuteEntityIdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteEntityIdsResponse.Marshal(b, m, deterministic)
}
func (dst *ExecuteEntityIdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteEntityIdsResponse.Merge(dst, src)
}
func (m *ExecuteEntityIdsResponse) XXX_Size() int {
	return xxx_messageInfo_ExecuteEntityIdsResponse.Size(m)
}
func (m *ExecuteEntityIdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteEntityIdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteEntityIdsResponse proto.InternalMessageInfo

func (m *ExecuteEntityIdsResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteEntityIdsResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteEntityIdsResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteBatchRequest is the payload to ExecuteBatch.
type ExecuteBatchRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the session state.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// queries is a list of query and bind variables to execute.
	Queries []*query.BoundQuery `protobuf:"bytes,3,rep,name=queries" json:"queries,omitempty"`
	// These values are deprecated. Use session instead.
	// TODO(sougou): remove in 3.1
	TabletType           topodata.TabletType   `protobuf:"varint,4,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	AsTransaction        bool                  `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction" json:"as_transaction,omitempty"`
	KeyspaceShard        string                `protobuf:"bytes,6,opt,name=keyspace_shard,json=keyspaceShard" json:"keyspace_shard,omitempty"`
	Options              *query.ExecuteOptions `protobuf:"bytes,7,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExecuteBatchRequest) Reset()         { *m = ExecuteBatchRequest{} }
func (m *ExecuteBatchRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteBatchRequest) ProtoMessage()    {}
func (*ExecuteBatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{11}
}
func (m *ExecuteBatchRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteBatchRequest.Unmarshal(m, b)
}
func (m *ExecuteBatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteBatchRequest.Marshal(b, m, deterministic)
}
func (dst *ExecuteBatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteBatchRequest.Merge(dst, src)
}
func (m *ExecuteBatchRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteBatchRequest.Size(m)
}
func (m *ExecuteBatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteBatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteBatchRequest proto.InternalMessageInfo

func (m *ExecuteBatchRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteBatchRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteBatchRequest) GetQueries() []*query.BoundQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *ExecuteBatchRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteBatchRequest) GetAsTransaction() bool {
	if m != nil {
		return m.AsTransaction
	}
	return false
}

func (m *ExecuteBatchRequest) GetKeyspaceShard() string {
	if m != nil {
		return m.KeyspaceShard
	}
	return ""
}

func (m *ExecuteBatchRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteBatchResponse is the returned value from ExecuteBatch.
type ExecuteBatchResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// results contains the query results, only set if application level error is unset.
	Results              []*query.ResultWithError `protobuf:"bytes,3,rep,name=results" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ExecuteBatchResponse) Reset()         { *m = ExecuteBatchResponse{} }
func (m *ExecuteBatchResponse) String() string { return proto.CompactTextString(m) }
func (*ExecuteBatchResponse) ProtoMessage()    {}
func (*ExecuteBatchResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{12}
}
func (m *ExecuteBatchResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteBatchResponse.Unmarshal(m, b)
}
func (m *ExecuteBatchResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteBatchResponse.Marshal(b, m, deterministic)
}
func (dst *ExecuteBatchResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteBatchResponse.Merge(dst, src)
}
func (m *ExecuteBatchResponse) XXX_Size() int {
	return xxx_messageInfo_ExecuteBatchResponse.Size(m)
}
func (m *ExecuteBatchResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteBatchResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteBatchResponse proto.InternalMessageInfo

func (m *ExecuteBatchResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteBatchResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteBatchResponse) GetResults() []*query.ResultWithError {
	if m != nil {
		return m.Results
	}
	return nil
}

// BoundShardQuery represents a single query request for the
// specified list of shards. This is used in a list for
// ExecuteBatchShardsRequest.
type BoundShardQuery struct {
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,1,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// shards to target the query to. A DML can only target one shard.
	Shards               []string `protobuf:"bytes,3,rep,name=shards" json:"shards,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BoundShardQuery) Reset()         { *m = BoundShardQuery{} }
func (m *BoundShardQuery) String() string { return proto.CompactTextString(m) }
func (*BoundShardQuery) ProtoMessage()    {}
func (*BoundShardQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{13}
}
func (m *BoundShardQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoundShardQuery.Unmarshal(m, b)
}
func (m *BoundShardQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoundShardQuery.Marshal(b, m, deterministic)
}
func (dst *BoundShardQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoundShardQuery.Merge(dst, src)
}
func (m *BoundShardQuery) XXX_Size() int {
	return xxx_messageInfo_BoundShardQuery.Size(m)
}
func (m *BoundShardQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_BoundShardQuery.DiscardUnknown(m)
}

var xxx_messageInfo_BoundShardQuery proto.InternalMessageInfo

func (m *BoundShardQuery) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *BoundShardQuery) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *BoundShardQuery) GetShards() []string {
	if m != nil {
		return m.Shards
	}
	return nil
}

// ExecuteBatchShardsRequest is the payload to ExecuteBatchShards
type ExecuteBatchShardsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// queries carries all the queries to execute.
	Queries []*BoundShardQuery `protobuf:"bytes,3,rep,name=queries" json:"queries,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,4,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// as_transaction will execute the queries in this batch in a single transaction per shard, created for this purpose.
	// (this can be seen as adding a 'begin' before and 'commit' after the queries).
	// Only makes sense if tablet_type is master. If set, the Session is ignored.
	AsTransaction bool `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction" json:"as_transaction,omitempty"`
	// options
	Options              *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExecuteBatchShardsRequest) Reset()         { *m = ExecuteBatchShardsRequest{} }
func (m *ExecuteBatchShardsRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteBatchShardsRequest) ProtoMessage()    {}
func (*ExecuteBatchShardsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{14}
}
func (m *ExecuteBatchShardsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteBatchShardsRequest.Unmarshal(m, b)
}
func (m *ExecuteBatchShardsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteBatchShardsRequest.Marshal(b, m, deterministic)
}
func (dst *ExecuteBatchShardsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteBatchShardsRequest.Merge(dst, src)
}
func (m *ExecuteBatchShardsRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteBatchShardsRequest.Size(m)
}
func (m *ExecuteBatchShardsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteBatchShardsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteBatchShardsRequest proto.InternalMessageInfo

func (m *ExecuteBatchShardsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteBatchShardsRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteBatchShardsRequest) GetQueries() []*BoundShardQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *ExecuteBatchShardsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteBatchShardsRequest) GetAsTransaction() bool {
	if m != nil {
		return m.AsTransaction
	}
	return false
}

func (m *ExecuteBatchShardsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteBatchShardsResponse is the returned value from ExecuteBatchShards.
type ExecuteBatchShardsResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Results              []*query.QueryResult `protobuf:"bytes,3,rep,name=results" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ExecuteBatchShardsResponse) Reset()         { *m = ExecuteBatchShardsResponse{} }
func (m *ExecuteBatchShardsResponse) String() string { return proto.CompactTextString(m) }
func (*ExecuteBatchShardsResponse) ProtoMessage()    {}
func (*ExecuteBatchShardsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{15}
}
func (m *ExecuteBatchShardsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteBatchShardsResponse.Unmarshal(m, b)
}
func (m *ExecuteBatchShardsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteBatchShardsResponse.Marshal(b, m, deterministic)
}
func (dst *ExecuteBatchShardsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteBatchShardsResponse.Merge(dst, src)
}
func (m *ExecuteBatchShardsResponse) XXX_Size() int {
	return xxx_messageInfo_ExecuteBatchShardsResponse.Size(m)
}
func (m *ExecuteBatchShardsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteBatchShardsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteBatchShardsResponse proto.InternalMessageInfo

func (m *ExecuteBatchShardsResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteBatchShardsResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteBatchShardsResponse) GetResults() []*query.QueryResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// BoundKeyspaceIdQuery represents a single query request for the
// specified list of keyspace ids. This is used in a list for
// ExecuteBatchKeyspaceIdsRequest.
type BoundKeyspaceIdQuery struct {
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,1,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// keyspace_ids contains the list of keyspace_ids affected by this query.
	// Will be used to find the shards to send the query to.
	KeyspaceIds          [][]byte `protobuf:"bytes,3,rep,name=keyspace_ids,json=keyspaceIds,proto3" json:"keyspace_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BoundKeyspaceIdQuery) Reset()         { *m = BoundKeyspaceIdQuery{} }
func (m *BoundKeyspaceIdQuery) String() string { return proto.CompactTextString(m) }
func (*BoundKeyspaceIdQuery) ProtoMessage()    {}
func (*BoundKeyspaceIdQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{16}
}
func (m *BoundKeyspaceIdQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoundKeyspaceIdQuery.Unmarshal(m, b)
}
func (m *BoundKeyspaceIdQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoundKeyspaceIdQuery.Marshal(b, m, deterministic)
}
func (dst *BoundKeyspaceIdQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoundKeyspaceIdQuery.Merge(dst, src)
}
func (m *BoundKeyspaceIdQuery) XXX_Size() int {
	return xxx_messageInfo_BoundKeyspaceIdQuery.Size(m)
}
func (m *BoundKeyspaceIdQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_BoundKeyspaceIdQuery.DiscardUnknown(m)
}

var xxx_messageInfo_BoundKeyspaceIdQuery proto.InternalMessageInfo

func (m *BoundKeyspaceIdQuery) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *BoundKeyspaceIdQuery) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *BoundKeyspaceIdQuery) GetKeyspaceIds() [][]byte {
	if m != nil {
		return m.KeyspaceIds
	}
	return nil
}

// ExecuteBatchKeyspaceIdsRequest is the payload to ExecuteBatchKeyspaceId.
type ExecuteBatchKeyspaceIdsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session                `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	Queries []*BoundKeyspaceIdQuery `protobuf:"bytes,3,rep,name=queries" json:"queries,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,4,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// as_transaction will execute the queries in this batch in a single transaction per shard, created for this purpose.
	// (this can be seen as adding a 'begin' before and 'commit' after the queries).
	// Only makes sense if tablet_type is master. If set, the Session is ignored.
	AsTransaction bool `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction" json:"as_transaction,omitempty"`
	// options
	Options              *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExecuteBatchKeyspaceIdsRequest) Reset()         { *m = ExecuteBatchKeyspaceIdsRequest{} }
func (m *ExecuteBatchKeyspaceIdsRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteBatchKeyspaceIdsRequest) ProtoMessage()    {}
func (*ExecuteBatchKeyspaceIdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{17}
}
func (m *ExecuteBatchKeyspaceIdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteBatchKeyspaceIdsRequest.Unmarshal(m, b)
}
func (m *ExecuteBatchKeyspaceIdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteBatchKeyspaceIdsRequest.Marshal(b, m, deterministic)
}
func (dst *ExecuteBatchKeyspaceIdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteBatchKeyspaceIdsRequest.Merge(dst, src)
}
func (m *ExecuteBatchKeyspaceIdsRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteBatchKeyspaceIdsRequest.Size(m)
}
func (m *ExecuteBatchKeyspaceIdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteBatchKeyspaceIdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteBatchKeyspaceIdsRequest proto.InternalMessageInfo

func (m *ExecuteBatchKeyspaceIdsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteBatchKeyspaceIdsRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteBatchKeyspaceIdsRequest) GetQueries() []*BoundKeyspaceIdQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *ExecuteBatchKeyspaceIdsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteBatchKeyspaceIdsRequest) GetAsTransaction() bool {
	if m != nil {
		return m.AsTransaction
	}
	return false
}

func (m *ExecuteBatchKeyspaceIdsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteBatchKeyspaceIdsResponse is the returned value from ExecuteBatchKeyspaceId.
type ExecuteBatchKeyspaceIdsResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Results              []*query.QueryResult `protobuf:"bytes,3,rep,name=results" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ExecuteBatchKeyspaceIdsResponse) Reset()         { *m = ExecuteBatchKeyspaceIdsResponse{} }
func (m *ExecuteBatchKeyspaceIdsResponse) String() string { return proto.CompactTextString(m) }
func (*ExecuteBatchKeyspaceIdsResponse) ProtoMessage()    {}
func (*ExecuteBatchKeyspaceIdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{18}
}
func (m *ExecuteBatchKeyspaceIdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteBatchKeyspaceIdsResponse.Unmarshal(m, b)
}
func (m *ExecuteBatchKeyspaceIdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteBatchKeyspaceIdsResponse.Marshal(b, m, deterministic)
}
func (dst *ExecuteBatchKeyspaceIdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteBatchKeyspaceIdsResponse.Merge(dst, src)
}
func (m *ExecuteBatchKeyspaceIdsResponse) XXX_Size() int {
	return xxx_messageInfo_ExecuteBatchKeyspaceIdsResponse.Size(m)
}
func (m *ExecuteBatchKeyspaceIdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteBatchKeyspaceIdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteBatchKeyspaceIdsResponse proto.InternalMessageInfo

func (m *ExecuteBatchKeyspaceIdsResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteBatchKeyspaceIdsResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteBatchKeyspaceIdsResponse) GetResults() []*query.QueryResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// StreamExecuteRequest is the payload to StreamExecute.
type StreamExecuteRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,2,opt,name=query" json:"query,omitempty"`
	// These values are deprecated. Use session instead.
	// TODO(sougou): remove in 3.1
	TabletType    topodata.TabletType   `protobuf:"varint,3,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	KeyspaceShard string                `protobuf:"bytes,4,opt,name=keyspace_shard,json=keyspaceShard" json:"keyspace_shard,omitempty"`
	Options       *query.ExecuteOptions `protobuf:"bytes,5,opt,name=options" json:"options,omitempty"`
	// session carries the session state.
	Session              *Session `protobuf:"bytes,6,opt,name=session" json:"session,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamExecuteRequest) Reset()         { *m = StreamExecuteRequest{} }
func (m *StreamExecuteRequest) String() string { return proto.CompactTextString(m) }
func (*StreamExecuteRequest) ProtoMessage()    {}
func (*StreamExecuteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{19}
}
func (m *StreamExecuteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamExecuteRequest.Unmarshal(m, b)
}
func (m *StreamExecuteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamExecuteRequest.Marshal(b, m, deterministic)
}
func (dst *StreamExecuteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamExecuteRequest.Merge(dst, src)
}
func (m *StreamExecuteRequest) XXX_Size() int {
	return xxx_messageInfo_StreamExecuteRequest.Size(m)
}
func (m *StreamExecuteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamExecuteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamExecuteRequest proto.InternalMessageInfo

func (m *StreamExecuteRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *StreamExecuteRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *StreamExecuteRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *StreamExecuteRequest) GetKeyspaceShard() string {
	if m != nil {
		return m.KeyspaceShard
	}
	return ""
}

func (m *StreamExecuteRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *StreamExecuteRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

// StreamExecuteResponse is the returned value from StreamExecute.
// The session is currently not returned because StreamExecute is
// not expected to modify it.
type StreamExecuteResponse struct {
	// result contains the result data.
	// The first value contains only Fields information.
	// The next values contain the actual rows, a few values per result.
	Result               *query.QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamExecuteResponse) Reset()         { *m = StreamExecuteResponse{} }
func (m *StreamExecuteResponse) String() string { return proto.CompactTextString(m) }
func (*StreamExecuteResponse) ProtoMessage()    {}
func (*StreamExecuteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{20}
}
func (m *StreamExecuteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamExecuteResponse.Unmarshal(m, b)
}
func (m *StreamExecuteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamExecuteResponse.Marshal(b, m, deterministic)
}
func (dst *StreamExecuteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamExecuteResponse.Merge(dst, src)
}
func (m *StreamExecuteResponse) XXX_Size() int {
	return xxx_messageInfo_StreamExecuteResponse.Size(m)
}
func (m *StreamExecuteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamExecuteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamExecuteResponse proto.InternalMessageInfo

func (m *StreamExecuteResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// StreamExecuteShardsRequest is the payload to StreamExecuteShards.
type StreamExecuteShardsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,2,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,3,opt,name=keyspace" json:"keyspace,omitempty"`
	// shards to target the query to.
	Shards []string `protobuf:"bytes,4,rep,name=shards" json:"shards,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,5,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// options
	Options              *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *StreamExecuteShardsRequest) Reset()         { *m = StreamExecuteShardsRequest{} }
func (m *StreamExecuteShardsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamExecuteShardsRequest) ProtoMessage()    {}
func (*StreamExecuteShardsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{21}
}
func (m *StreamExecuteShardsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamExecuteShardsRequest.Unmarshal(m, b)
}
func (m *StreamExecuteShardsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamExecuteShardsRequest.Marshal(b, m, deterministic)
}
func (dst *StreamExecuteShardsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamExecuteShardsRequest.Merge(dst, src)
}
func (m *StreamExecuteShardsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamExecuteShardsRequest.Size(m)
}
func (m *StreamExecuteShardsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamExecuteShardsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamExecuteShardsRequest proto.InternalMessageInfo

func (m *StreamExecuteShardsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *StreamExecuteShardsRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *StreamExecuteShardsRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *StreamExecuteShardsRequest) GetShards() []string {
	if m != nil {
		return m.Shards
	}
	return nil
}

func (m *StreamExecuteShardsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *StreamExecuteShardsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// StreamExecuteShardsResponse is the returned value from StreamExecuteShards.
type StreamExecuteShardsResponse struct {
	// result contains the result data.
	// The first value contains only Fields information.
	// The next values contain the actual rows, a few values per result.
	Result               *query.QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamExecuteShardsResponse) Reset()         { *m = StreamExecuteShardsResponse{} }
func (m *StreamExecuteShardsResponse) String() string { return proto.CompactTextString(m) }
func (*StreamExecuteShardsResponse) ProtoMessage()    {}
func (*StreamExecuteShardsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{22}
}
func (m *StreamExecuteShardsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamExecuteShardsResponse.Unmarshal(m, b)
}
func (m *StreamExecuteShardsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamExecuteShardsResponse.Marshal(b, m, deterministic)
}
func (dst *StreamExecuteShardsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamExecuteShardsResponse.Merge(dst, src)
}
func (m *StreamExecuteShardsResponse) XXX_Size() int {
	return xxx_messageInfo_StreamExecuteShardsResponse.Size(m)
}
func (m *StreamExecuteShardsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamExecuteShardsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamExecuteShardsResponse proto.InternalMessageInfo

func (m *StreamExecuteShardsResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// StreamExecuteKeyspaceIdsRequest is the payload to StreamExecuteKeyspaceIds.
type StreamExecuteKeyspaceIdsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,2,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,3,opt,name=keyspace" json:"keyspace,omitempty"`
	// keyspace_ids contains the list of keyspace_ids affected by this query.
	// Will be used to find the shards to send the query to.
	KeyspaceIds [][]byte `protobuf:"bytes,4,rep,name=keyspace_ids,json=keyspaceIds,proto3" json:"keyspace_ids,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,5,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// options
	Options              *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *StreamExecuteKeyspaceIdsRequest) Reset()         { *m = StreamExecuteKeyspaceIdsRequest{} }
func (m *StreamExecuteKeyspaceIdsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamExecuteKeyspaceIdsRequest) ProtoMessage()    {}
func (*StreamExecuteKeyspaceIdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{23}
}
func (m *StreamExecuteKeyspaceIdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamExecuteKeyspaceIdsRequest.Unmarshal(m, b)
}
func (m *StreamExecuteKeyspaceIdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamExecuteKeyspaceIdsRequest.Marshal(b, m, deterministic)
}
func (dst *StreamExecuteKeyspaceIdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamExecuteKeyspaceIdsRequest.Merge(dst, src)
}
func (m *StreamExecuteKeyspaceIdsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamExecuteKeyspaceIdsRequest.Size(m)
}
func (m *StreamExecuteKeyspaceIdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamExecuteKeyspaceIdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamExecuteKeyspaceIdsRequest proto.InternalMessageInfo

func (m *StreamExecuteKeyspaceIdsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *StreamExecuteKeyspaceIdsRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *StreamExecuteKeyspaceIdsRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *StreamExecuteKeyspaceIdsRequest) GetKeyspaceIds() [][]byte {
	if m != nil {
		return m.KeyspaceIds
	}
	return nil
}

func (m *StreamExecuteKeyspaceIdsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *StreamExecuteKeyspaceIdsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// StreamExecuteKeyspaceIdsResponse is the returned value from StreamExecuteKeyspaceIds.
type StreamExecuteKeyspaceIdsResponse struct {
	// result contains the result data.
	// The first value contains only Fields information.
	// The next values contain the actual rows, a few values per result.
	Result               *query.QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamExecuteKeyspaceIdsResponse) Reset()         { *m = StreamExecuteKeyspaceIdsResponse{} }
func (m *StreamExecuteKeyspaceIdsResponse) String() string { return proto.CompactTextString(m) }
func (*StreamExecuteKeyspaceIdsResponse) ProtoMessage()    {}
func (*StreamExecuteKeyspaceIdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{24}
}
func (m *StreamExecuteKeyspaceIdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamExecuteKeyspaceIdsResponse.Unmarshal(m, b)
}
func (m *StreamExecuteKeyspaceIdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamExecuteKeyspaceIdsResponse.Marshal(b, m, deterministic)
}
func (dst *StreamExecuteKeyspaceIdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamExecuteKeyspaceIdsResponse.Merge(dst, src)
}
func (m *StreamExecuteKeyspaceIdsResponse) XXX_Size() int {
	return xxx_messageInfo_StreamExecuteKeyspaceIdsResponse.Size(m)
}
func (m *StreamExecuteKeyspaceIdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamExecuteKeyspaceIdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamExecuteKeyspaceIdsResponse proto.InternalMessageInfo

func (m *StreamExecuteKeyspaceIdsResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// StreamExecuteKeyRangesRequest is the payload to StreamExecuteKeyRanges.
type StreamExecuteKeyRangesRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,2,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,3,opt,name=keyspace" json:"keyspace,omitempty"`
	// key_ranges contains the list of key ranges affected by this query.
	// Will be used to find the shards to send the query to.
	KeyRanges []*topodata.KeyRange `protobuf:"bytes,4,rep,name=key_ranges,json=keyRanges" json:"key_ranges,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,5,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// options
	Options              *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *StreamExecuteKeyRangesRequest) Reset()         { *m = StreamExecuteKeyRangesRequest{} }
func (m *StreamExecuteKeyRangesRequest) String() string { return proto.CompactTextString(m) }
func (*StreamExecuteKeyRangesRequest) ProtoMessage()    {}
func (*StreamExecuteKeyRangesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{25}
}
func (m *StreamExecuteKeyRangesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamExecuteKeyRangesRequest.Unmarshal(m, b)
}
func (m *StreamExecuteKeyRangesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamExecuteKeyRangesRequest.Marshal(b, m, deterministic)
}
func (dst *StreamExecuteKeyRangesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamExecuteKeyRangesRequest.Merge(dst, src)
}
func (m *StreamExecuteKeyRangesRequest) XXX_Size() int {
	return xxx_messageInfo_StreamExecuteKeyRangesRequest.Size(m)
}
func (m *StreamExecuteKeyRangesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamExecuteKeyRangesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamExecuteKeyRangesRequest proto.InternalMessageInfo

func (m *StreamExecuteKeyRangesRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *StreamExecuteKeyRangesRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *StreamExecuteKeyRangesRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *StreamExecuteKeyRangesRequest) GetKeyRanges() []*topodata.KeyRange {
	if m != nil {
		return m.KeyRanges
	}
	return nil
}

func (m *StreamExecuteKeyRangesRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *StreamExecuteKeyRangesRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// StreamExecuteKeyRangesResponse is the returned value from StreamExecuteKeyRanges.
type StreamExecuteKeyRangesResponse struct {
	// result contains the result data.
	// The first value contains only Fields information.
	// The next values contain the actual rows, a few values per result.
	Result               *query.QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamExecuteKeyRangesResponse) Reset()         { *m = StreamExecuteKeyRangesResponse{} }
func (m *StreamExecuteKeyRangesResponse) String() string { return proto.CompactTextString(m) }
func (*StreamExecuteKeyRangesResponse) ProtoMessage()    {}
func (*StreamExecuteKeyRangesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{26}
}
func (m *StreamExecuteKeyRangesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamExecuteKeyRangesResponse.Unmarshal(m, b)
}
func (m *StreamExecuteKeyRangesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamExecuteKeyRangesResponse.Marshal(b, m, deterministic)
}
func (dst *StreamExecuteKeyRangesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamExecuteKeyRangesResponse.Merge(dst, src)
}
func (m *StreamExecuteKeyRangesResponse) XXX_Size() int {
	return xxx_messageInfo_StreamExecuteKeyRangesResponse.Size(m)
}
func (m *StreamExecuteKeyRangesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamExecuteKeyRangesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamExecuteKeyRangesResponse proto.InternalMessageInfo

func (m *StreamExecuteKeyRangesResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// BeginRequest is the payload to Begin.
type BeginRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// single_db is deprecated. Use transaction_mode instead.
	// The value specifies if the transaction should be restricted
	// to a single database.
	// TODO(sougou): remove in 3.1
	SingleDb             bool     `protobuf:"varint,2,opt,name=single_db,json=singleDb" json:"single_db,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BeginRequest) Reset()         { *m = BeginRequest{} }
func (m *BeginRequest) String() string { return proto.CompactTextString(m) }
func (*BeginRequest) ProtoMessage()    {}
func (*BeginRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{27}
}
func (m *BeginRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginRequest.Unmarshal(m, b)
}
func (m *BeginRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginRequest.Marshal(b, m, deterministic)
}
func (dst *BeginRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginRequest.Merge(dst, src)
}
func (m *BeginRequest) XXX_Size() int {
	return xxx_messageInfo_BeginRequest.Size(m)
}
func (m *BeginRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BeginRequest proto.InternalMessageInfo

func (m *BeginRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *BeginRequest) GetSingleDb() bool {
	if m != nil {
		return m.SingleDb
	}
	return false
}

// BeginResponse is the returned value from Begin.
type BeginResponse struct {
	// session is the initial session information to use for subsequent queries.
	Session              *Session `protobuf:"bytes,1,opt,name=session" json:"session,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BeginResponse) Reset()         { *m = BeginResponse{} }
func (m *BeginResponse) String() string { return proto.CompactTextString(m) }
func (*BeginResponse) ProtoMessage()    {}
func (*BeginResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{28}
}
func (m *BeginResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginResponse.Unmarshal(m, b)
}
func (m *BeginResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginResponse.Marshal(b, m, deterministic)
}
func (dst *BeginResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginResponse.Merge(dst, src)
}
func (m *BeginResponse) XXX_Size() int {
	return xxx_messageInfo_BeginResponse.Size(m)
}
func (m *BeginResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BeginResponse proto.InternalMessageInfo

func (m *BeginResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

// CommitRequest is the payload to Commit.
type CommitRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data to commit.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// atomic is deprecated. Use transaction_mode instead.
	// The value specifies if the commit should go through the
	// 2PC workflow to ensure atomicity.
	// TODO(sougou): remove in 3.1
	Atomic               bool     `protobuf:"varint,3,opt,name=atomic" json:"atomic,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitRequest) Reset()         { *m = CommitRequest{} }
func (m *CommitRequest) String() string { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()    {}
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{29}
}
func (m *CommitRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitRequest.Unmarshal(m, b)
}
func (m *CommitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitRequest.Marshal(b, m, deterministic)
}
func (dst *CommitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitRequest.Merge(dst, src)
}
func (m *CommitRequest) XXX_Size() int {
	return xxx_messageInfo_CommitRequest.Size(m)
}
func (m *CommitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitRequest proto.InternalMessageInfo

func (m *CommitRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *CommitRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *CommitRequest) GetAtomic() bool {
	if m != nil {
		return m.Atomic
	}
	return false
}

// CommitResponse is the returned value from Commit.
type CommitResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitResponse) Reset()         { *m = CommitResponse{} }
func (m *CommitResponse) String() string { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()    {}
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{30}
}
func (m *CommitResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitResponse.Unmarshal(m, b)
}
func (m *CommitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitResponse.Marshal(b, m, deterministic)
}
func (dst *CommitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitResponse.Merge(dst, src)
}
func (m *CommitResponse) XXX_Size() int {
	return xxx_messageInfo_CommitResponse.Size(m)
}
func (m *CommitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitResponse proto.InternalMessageInfo

// RollbackRequest is the payload to Rollback.
type RollbackRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data to rollback.
	Session              *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackRequest) Reset()         { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()    {}
func (*RollbackRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{31}
}
func (m *RollbackRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackRequest.Unmarshal(m, b)
}
func (m *RollbackRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackRequest.Marshal(b, m, deterministic)
}
func (dst *RollbackRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackRequest.Merge(dst, src)
}
func (m *RollbackRequest) XXX_Size() int {
	return xxx_messageInfo_RollbackRequest.Size(m)
}
func (m *RollbackRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackRequest proto.InternalMessageInfo

func (m *RollbackRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *RollbackRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

// RollbackResponse is the returned value from Rollback.
type RollbackResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackResponse) Reset()         { *m = RollbackResponse{} }
func (m *RollbackResponse) String() string { return proto.CompactTextString(m) }
func (*RollbackResponse) ProtoMessage()    {}
func (*RollbackResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{32}
}
func (m *RollbackResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackResponse.Unmarshal(m, b)
}
func (m *RollbackResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackResponse.Marshal(b, m, deterministic)
}
func (dst *RollbackResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackResponse.Merge(dst, src)
}
func (m *RollbackResponse) XXX_Size() int {
	return xxx_messageInfo_RollbackResponse.Size(m)
}
func (m *RollbackResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackResponse proto.InternalMessageInfo

// ResolveTransactionRequest is the payload to ResolveTransaction.
type ResolveTransactionRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// dtid is the dtid of the transaction to be resolved.
	Dtid                 string   `protobuf:"bytes,2,opt,name=dtid" json:"dtid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResolveTransactionRequest) Reset()         { *m = ResolveTransactionRequest{} }
func (m *ResolveTransactionRequest) String() string { return proto.CompactTextString(m) }
func (*ResolveTransactionRequest) ProtoMessage()    {}
func (*ResolveTransactionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{33}
}
func (m *ResolveTransactionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResolveTransactionRequest.Unmarshal(m, b)
}
func (m *ResolveTransactionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResolveTransactionRequest.Marshal(b, m, deterministic)
}
func (dst *ResolveTransactionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResolveTransactionRequest.Merge(dst, src)
}
func (m *ResolveTransactionRequest) XXX_Size() int {
	return xxx_messageInfo_ResolveTransactionRequest.Size(m)
}
func (m *ResolveTransactionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResolveTransactionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResolveTransactionRequest proto.InternalMessageInfo

func (m *ResolveTransactionRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ResolveTransactionRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// MessageStreamRequest is the request payload for MessageStream.
type MessageStreamRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// shard to target the query to, for unsharded keyspaces.
	Shard string `protobuf:"bytes,3,opt,name=shard" json:"shard,omitempty"`
	// KeyRange to target the query to, for sharded keyspaces.
	KeyRange *topodata.KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange" json:"key_range,omitempty"`
	// name is the message table name.
	Name                 string   `protobuf:"bytes,5,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MessageStreamRequest) Reset()         { *m = MessageStreamRequest{} }
func (m *MessageStreamRequest) String() string { return proto.CompactTextString(m) }
func (*MessageStreamRequest) ProtoMessage()    {}
func (*MessageStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{34}
}
func (m *MessageStreamRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MessageStreamRequest.Unmarshal(m, b)
}
func (m *MessageStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MessageStreamRequest.Marshal(b, m, deterministic)
}
func (dst *MessageStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageStreamRequest.Merge(dst, src)
}
func (m *MessageStreamRequest) XXX_Size() int {
	return xxx_messageInfo_MessageStreamRequest.Size(m)
}
func (m *MessageStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MessageStreamRequest proto.InternalMessageInfo

func (m *MessageStreamRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *MessageStreamRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *MessageStreamRequest) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *MessageStreamRequest) GetKeyRange() *topodata.KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *MessageStreamRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// MessageAckRequest is the request payload for MessageAck.
type MessageAckRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// keyspace to target the message to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// name is the message table name.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// ids is the list of ids to ack.
	Ids                  []*query.Value `protobuf:"bytes,4,rep,name=ids" json:"ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *MessageAckRequest) Reset()         { *m = MessageAckRequest{} }
func (m *MessageAckRequest) String() string { return proto.CompactTextString(m) }
func (*MessageAckRequest) ProtoMessage()    {}
func (*MessageAckRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{35}
}
func (m *MessageAckRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MessageAckRequest.Unmarshal(m, b)
}
func (m *MessageAckRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MessageAckRequest.Marshal(b, m, deterministic)
}
func (dst *MessageAckRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageAckRequest.Merge(dst, src)
}
func (m *MessageAckRequest) XXX_Size() int {
	return xxx_messageInfo_MessageAckRequest.Size(m)
}
func (m *MessageAckRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageAckRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MessageAckRequest proto.InternalMessageInfo

func (m *MessageAckRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *MessageAckRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *MessageAckRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MessageAckRequest) GetIds() []*query.Value {
	if m != nil {
		return m.Ids
	}
	return nil
}

// IdKeyspaceId represents an id and keyspace_id pair.
// The kesypace_id represents the routing info for id.
type IdKeyspaceId struct {
	// id represents the message id.
	Id *query.Value `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// keyspace_id is the associated keyspace_id for the id.
	KeyspaceId           []byte   `protobuf:"bytes,2,opt,name=keyspace_id,json=keyspaceId,proto3" json:"keyspace_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IdKeyspaceId) Reset()         { *m = IdKeyspaceId{} }
func (m *IdKeyspaceId) String() string { return proto.CompactTextString(m) }
func (*IdKeyspaceId) ProtoMessage()    {}
func (*IdKeyspaceId) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{36}
}
func (m *IdKeyspaceId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IdKeyspaceId.Unmarshal(m, b)
}
func (m *IdKeyspaceId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IdKeyspaceId.Marshal(b, m, deterministic)
}
func (dst *IdKeyspaceId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IdKeyspaceId.Merge(dst, src)
}
func (m *IdKeyspaceId) XXX_Size() int {
	return xxx_messageInfo_IdKeyspaceId.Size(m)
}
func (m *IdKeyspaceId) XXX_DiscardUnknown() {
	xxx_messageInfo_IdKeyspaceId.DiscardUnknown(m)
}

var xxx_messageInfo_IdKeyspaceId proto.InternalMessageInfo

func (m *IdKeyspaceId) GetId() *query.Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *IdKeyspaceId) GetKeyspaceId() []byte {
	if m != nil {
		return m.KeyspaceId
	}
	return nil
}

// MessageAckKeyspaceIdsRequest is the payload to MessageAckKeyspaceIds.
type MessageAckKeyspaceIdsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// Optional keyspace for message table.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// name is the message table name.
	Name                 string          `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	IdKeyspaceIds        []*IdKeyspaceId `protobuf:"bytes,4,rep,name=id_keyspace_ids,json=idKeyspaceIds" json:"id_keyspace_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *MessageAckKeyspaceIdsRequest) Reset()         { *m = MessageAckKeyspaceIdsRequest{} }
func (m *MessageAckKeyspaceIdsRequest) String() string { return proto.CompactTextString(m) }
func (*MessageAckKeyspaceIdsRequest) ProtoMessage()    {}
func (*MessageAckKeyspaceIdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{37}
}
func (m *MessageAckKeyspaceIdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MessageAckKeyspaceIdsRequest.Unmarshal(m, b)
}
func (m *MessageAckKeyspaceIdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MessageAckKeyspaceIdsRequest.Marshal(b, m, deterministic)
}
func (dst *MessageAckKeyspaceIdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageAckKeyspaceIdsRequest.Merge(dst, src)
}
func (m *MessageAckKeyspaceIdsRequest) XXX_Size() int {
	return xxx_messageInfo_MessageAckKeyspaceIdsRequest.Size(m)
}
func (m *MessageAckKeyspaceIdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageAckKeyspaceIdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MessageAckKeyspaceIdsRequest proto.InternalMessageInfo

func (m *MessageAckKeyspaceIdsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *MessageAckKeyspaceIdsRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *MessageAckKeyspaceIdsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MessageAckKeyspaceIdsRequest) GetIdKeyspaceIds() []*IdKeyspaceId {
	if m != nil {
		return m.IdKeyspaceIds
	}
	return nil
}

// ResolveTransactionResponse is the returned value from Rollback.
type ResolveTransactionResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResolveTransactionResponse) Reset()         { *m = ResolveTransactionResponse{} }
func (m *ResolveTransactionResponse) String() string { return proto.CompactTextString(m) }
func (*ResolveTransactionResponse) ProtoMessage()    {}
func (*ResolveTransactionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{38}
}
func (m *ResolveTransactionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResolveTransactionResponse.Unmarshal(m, b)
}
func (m *ResolveTransactionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResolveTransactionResponse.Marshal(b, m, deterministic)
}
func (dst *ResolveTransactionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResolveTransactionResponse.Merge(dst, src)
}
func (m *ResolveTransactionResponse) XXX_Size() int {
	return xxx_messageInfo_ResolveTransactionResponse.Size(m)
}
func (m *ResolveTransactionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResolveTransactionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResolveTransactionResponse proto.InternalMessageInfo

// SplitQueryRequest is the payload to SplitQuery.
//
// SplitQuery takes a "SELECT" query and generates a list of queries called
// "query-parts". Each query-part consists of the original query with an
// added WHERE clause that restricts the query-part to operate only on
// rows whose values in the the columns listed in the "split_column" field
// of the request (see below) are in a particular range.
//
// It is guaranteed that the set of rows obtained from
// executing each query-part on a database snapshot
// and merging (without deduping) the results is equal to the set of rows
// obtained from executing the original query on the same snapshot
// with the rows containing NULL values in any of the split_column's excluded.
//
// This is typically called by the MapReduce master when reading from Vitess.
// There it's desirable that the sets of rows returned by the query-parts
// have roughly the same size.
type SplitQueryRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// The query and bind variables to produce splits for.
	// The given query must be a simple query of the form
	// SELECT <cols> FROM <table> WHERE <filter>.
	// It must not contain subqueries nor any of the keywords
	// JOIN, GROUP BY, ORDER BY, LIMIT, DISTINCT.
	// Furthermore, <table> must be a single “concrete” table.
	// It cannot be a view.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// Each generated query-part will be restricted to rows whose values
	// in the columns listed in this field are in a particular range.
	// The list of columns named here must be a prefix of the list of
	// columns defining some index or primary key of the table
	// referenced in 'query'. For many tables using the primary key columns
	// (in order) is sufficient and this is the default if this field is omitted.
	// See the comment on the 'algorithm' field for more restrictions and
	// information.
	SplitColumn []string `protobuf:"bytes,4,rep,name=split_column,json=splitColumn" json:"split_column,omitempty"`
	// You can specify either an estimate of the number of query-parts to
	// generate or an estimate of the number of rows each query-part should
	// return.
	// Thus, exactly one of split_count or num_rows_per_query_part
	// should be nonzero.
	// The non-given parameter is calculated from the given parameter
	// using the formula: split_count * num_rows_per_query_pary = table_size,
	// where table_size is an approximation of the number of rows in the
	// table.
	// Note that if "split_count" is given it is regarded as an estimate.
	// The number of query-parts returned may differ slightly (in particular,
	// if it's not a whole multiple of the number of vitess shards).
	SplitCount          int64 `protobuf:"varint,5,opt,name=split_count,json=splitCount" json:"split_count,omitempty"`
	NumRowsPerQueryPart int64 `protobuf:"varint,6,opt,name=num_rows_per_query_part,json=numRowsPerQueryPart" json:"num_rows_per_query_part,omitempty"`
	// The algorithm to use to split the query. The split algorithm is performed
	// on each database shard in parallel. The lists of query-parts generated
	// by the shards are merged and returned to the caller.
	// Two algorithms are supported:
	//  EQUAL_SPLITS
	//    If this algorithm is selected then only the first 'split_column' given
	//    is used (or the first primary key column if the 'split_column' field is
	//    empty). In the rest of this algorithm's description, we refer to
	//    this column as "the split column".
	//    The split column must have numeric type (integral or floating point).
	//    The algorithm works by taking the interval [min, max], where min and
	//    max are the minimum and maximum values of the split column in
	//    the table-shard, respectively, and partitioning it into 'split_count'
	//    sub-intervals of equal size. The added WHERE clause of each query-part
	//    restricts that part to rows whose value in the split column belongs to
	//    a particular sub-interval. This is fast, but requires that the
	//    distribution of values of the split column be uniform in [min, max]
	//    for the number of rows returned by each query part to be roughly the
	//    same.
	//  FULL_SCAN
	//    If this algorithm is used then the split_column must be the primary key
	//    columns (in order).
	//    This algorithm performs a full-scan of the table-shard referenced
	//    in 'query' to get "boundary" rows that are num_rows_per_query_part
	//    apart when the table is ordered by the columns listed in
	//    'split_column'. It then restricts each query-part to the rows
	//    located between two successive boundary rows.
	//    This algorithm supports multiple split_column's of any type,
	//    but is slower than EQUAL_SPLITS.
	Algorithm query.SplitQueryRequest_Algorithm `protobuf:"varint,7,opt,name=algorithm,enum=query.SplitQueryRequest_Algorithm" json:"algorithm,omitempty"`
	// TODO(erez): This field is no longer used by the server code.
	// Remove this field after this new server code is released to prod.
	// We must keep it for now, so that clients can still send it to the old
	// server code currently in production.
	UseSplitQueryV2      bool     `protobuf:"varint,8,opt,name=use_split_query_v2,json=useSplitQueryV2" json:"use_split_query_v2,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SplitQueryRequest) Reset()         { *m = SplitQueryRequest{} }
func (m *SplitQueryRequest) String() string { return proto.CompactTextString(m) }
func (*SplitQueryRequest) ProtoMessage()    {}
func (*SplitQueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{39}
}
func (m *SplitQueryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitQueryRequest.Unmarshal(m, b)
}
func (m *SplitQueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitQueryRequest.Marshal(b, m, deterministic)
}
func (dst *SplitQueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitQueryRequest.Merge(dst, src)
}
func (m *SplitQueryRequest) XXX_Size() int {
	return xxx_messageInfo_SplitQueryRequest.Size(m)
}
func (m *SplitQueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitQueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SplitQueryRequest proto.InternalMessageInfo

func (m *SplitQueryRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *SplitQueryRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *SplitQueryRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *SplitQueryRequest) GetSplitColumn() []string {
	if m != nil {
		return m.SplitColumn
	}
	return nil
}

func (m *SplitQueryRequest) GetSplitCount() int64 {
	if m != nil {
		return m.SplitCount
	}
	return 0
}

func (m *SplitQueryRequest) GetNumRowsPerQueryPart() int64 {
	if m != nil {
		return m.NumRowsPerQueryPart
	}
	return 0
}

func (m *SplitQueryRequest) GetAlgorithm() query.SplitQueryRequest_Algorithm {
	if m != nil {
		return m.Algorithm
	}
	return query.SplitQueryRequest_EQUAL_SPLITS
}

func (m *SplitQueryRequest) GetUseSplitQueryV2() bool {
	if m != nil {
		return m.UseSplitQueryV2
	}
	return false
}

// SplitQueryResponse is the returned value from SplitQuery.
type SplitQueryResponse struct {
	// splits contains the queries to run to fetch the entire data set.
	Splits               []*SplitQueryResponse_Part `protobuf:"bytes,1,rep,name=splits" json:"splits,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *SplitQueryResponse) Reset()         { *m = SplitQueryResponse{} }
func (m *SplitQueryResponse) String() string { return proto.CompactTextString(m) }
func (*SplitQueryResponse) ProtoMessage()    {}
func (*SplitQueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{40}
}
func (m *SplitQueryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitQueryResponse.Unmarshal(m, b)
}
func (m *SplitQueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitQueryResponse.Marshal(b, m, deterministic)
}
func (dst *SplitQueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitQueryResponse.Merge(dst, src)
}
func (m *SplitQueryResponse) XXX_Size() int {
	return xxx_messageInfo_SplitQueryResponse.Size(m)
}
func (m *SplitQueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitQueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SplitQueryResponse proto.InternalMessageInfo

func (m *SplitQueryResponse) GetSplits() []*SplitQueryResponse_Part {
	if m != nil {
		return m.Splits
	}
	return nil
}

type SplitQueryResponse_KeyRangePart struct {
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,1,opt,name=keyspace" json:"keyspace,omitempty"`
	// key ranges to target the query to.
	KeyRanges            []*topodata.KeyRange `protobuf:"bytes,2,rep,name=key_ranges,json=keyRanges" json:"key_ranges,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SplitQueryResponse_KeyRangePart) Reset()         { *m = SplitQueryResponse_KeyRangePart{} }
func (m *SplitQueryResponse_KeyRangePart) String() string { return proto.CompactTextString(m) }
func (*SplitQueryResponse_KeyRangePart) ProtoMessage()    {}
func (*SplitQueryResponse_KeyRangePart) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{40, 0}
}
func (m *SplitQueryResponse_KeyRangePart) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitQueryResponse_KeyRangePart.Unmarshal(m, b)
}
func (m *SplitQueryResponse_KeyRangePart) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitQueryResponse_KeyRangePart.Marshal(b, m, deterministic)
}
func (dst *SplitQueryResponse_KeyRangePart) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitQueryResponse_KeyRangePart.Merge(dst, src)
}
func (m *SplitQueryResponse_KeyRangePart) XXX_Size() int {
	return xxx_messageInfo_SplitQueryResponse_KeyRangePart.Size(m)
}
func (m *SplitQueryResponse_KeyRangePart) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitQueryResponse_KeyRangePart.DiscardUnknown(m)
}

var xxx_messageInfo_SplitQueryResponse_KeyRangePart proto.InternalMessageInfo

func (m *SplitQueryResponse_KeyRangePart) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *SplitQueryResponse_KeyRangePart) GetKeyRanges() []*topodata.KeyRange {
	if m != nil {
		return m.KeyRanges
	}
	return nil
}

type SplitQueryResponse_ShardPart struct {
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,1,opt,name=keyspace" json:"keyspace,omitempty"`
	// shards to target the query to.
	Shards               []string `protobuf:"bytes,2,rep,name=shards" json:"shards,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SplitQueryResponse_ShardPart) Reset()         { *m = SplitQueryResponse_ShardPart{} }
func (m *SplitQueryResponse_ShardPart) String() string { return proto.CompactTextString(m) }
func (*SplitQueryResponse_ShardPart) ProtoMessage()    {}
func (*SplitQueryResponse_ShardPart) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{40, 1}
}
func (m *SplitQueryResponse_ShardPart) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitQueryResponse_ShardPart.Unmarshal(m, b)
}
func (m *SplitQueryResponse_ShardPart) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitQueryResponse_ShardPart.Marshal(b, m, deterministic)
}
func (dst *SplitQueryResponse_ShardPart) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitQueryResponse_ShardPart.Merge(dst, src)
}
func (m *SplitQueryResponse_ShardPart) XXX_Size() int {
	return xxx_messageInfo_SplitQueryResponse_ShardPart.Size(m)
}
func (m *SplitQueryResponse_ShardPart) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitQueryResponse_ShardPart.DiscardUnknown(m)
}

var xxx_messageInfo_SplitQueryResponse_ShardPart proto.InternalMessageInfo

func (m *SplitQueryResponse_ShardPart) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *SplitQueryResponse_ShardPart) GetShards() []string {
	if m != nil {
		return m.Shards
	}
	return nil
}

type SplitQueryResponse_Part struct {
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,1,opt,name=query" json:"query,omitempty"`
	// key_range_part is set if the query should be executed by
	// ExecuteKeyRanges.
	KeyRangePart *SplitQueryResponse_KeyRangePart `protobuf:"bytes,2,opt,name=key_range_part,json=keyRangePart" json:"key_range_part,omitempty"`
	// shard_part is set if the query should be executed by ExecuteShards.
	ShardPart *SplitQueryResponse_ShardPart `protobuf:"bytes,3,opt,name=shard_part,json=shardPart" json:"shard_part,omitempty"`
	// size is the approximate number of rows this query will return.
	Size                 int64    `protobuf:"varint,4,opt,name=size" json:"size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SplitQueryResponse_Part) Reset()         { *m = SplitQueryResponse_Part{} }
func (m *SplitQueryResponse_Part) String() string { return proto.CompactTextString(m) }
func (*SplitQueryResponse_Part) ProtoMessage()    {}
func (*SplitQueryResponse_Part) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{40, 2}
}
func (m *SplitQueryResponse_Part) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitQueryResponse_Part.Unmarshal(m, b)
}
func (m *SplitQueryResponse_Part) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitQueryResponse_Part.Marshal(b, m, deterministic)
}
func (dst *SplitQueryResponse_Part) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitQueryResponse_Part.Merge(dst, src)
}
func (m *SplitQueryResponse_Part) XXX_Size() int {
	return xxx_messageInfo_SplitQueryResponse_Part.Size(m)
}
func (m *SplitQueryResponse_Part) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitQueryResponse_Part.DiscardUnknown(m)
}

var xxx_messageInfo_SplitQueryResponse_Part proto.InternalMessageInfo

func (m *SplitQueryResponse_Part) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *SplitQueryResponse_Part) GetKeyRangePart() *SplitQueryResponse_KeyRangePart {
	if m != nil {
		return m.KeyRangePart
	}
	return nil
}

func (m *SplitQueryResponse_Part) GetShardPart() *SplitQueryResponse_ShardPart {
	if m != nil {
		return m.ShardPart
	}
	return nil
}

func (m *SplitQueryResponse_Part) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

// GetSrvKeyspaceRequest is the payload to GetSrvKeyspace.
type GetSrvKeyspaceRequest struct {
	// keyspace name to fetch.
	Keyspace             string   `protobuf:"bytes,1,opt,name=keyspace" json:"keyspace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSrvKeyspaceRequest) Reset()         { *m = GetSrvKeyspaceRequest{} }
func (m *GetSrvKeyspaceRequest) String() string { return proto.CompactTextString(m) }
func (*GetSrvKeyspaceRequest) ProtoMessage()    {}
func (*GetSrvKeyspaceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{41}
}
func (m *GetSrvKeyspaceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSrvKeyspaceRequest.Unmarshal(m, b)
}
func (m *GetSrvKeyspaceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSrvKeyspaceRequest.Marshal(b, m, deterministic)
}
func (dst *GetSrvKeyspaceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSrvKeyspaceRequest.Merge(dst, src)
}
func (m *GetSrvKeyspaceRequest) XXX_Size() int {
	return xxx_messageInfo_GetSrvKeyspaceRequest.Size(m)
}
func (m *GetSrvKeyspaceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSrvKeyspaceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSrvKeyspaceRequest proto.InternalMessageInfo

func (m *GetSrvKeyspaceRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

// GetSrvKeyspaceResponse is the returned value from GetSrvKeyspace.
type GetSrvKeyspaceResponse struct {
	// srv_keyspace is the topology object for the SrvKeyspace.
	SrvKeyspace          *topodata.SrvKeyspace `protobuf:"bytes,1,opt,name=srv_keyspace,json=srvKeyspace" json:"srv_keyspace,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GetSrvKeyspaceResponse) Reset()         { *m = GetSrvKeyspaceResponse{} }
func (m *GetSrvKeyspaceResponse) String() string { return proto.CompactTextString(m) }
func (*GetSrvKeyspaceResponse) ProtoMessage()    {}
func (*GetSrvKeyspaceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{42}
}
func (m *GetSrvKeyspaceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSrvKeyspaceResponse.Unmarshal(m, b)
}
func (m *GetSrvKeyspaceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSrvKeyspaceResponse.Marshal(b, m, deterministic)
}
func (dst *GetSrvKeyspaceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSrvKeyspaceResponse.Merge(dst, src)
}
func (m *GetSrvKeyspaceResponse) XXX_Size() int {
	return xxx_messageInfo_GetSrvKeyspaceResponse.Size(m)
}
func (m *GetSrvKeyspaceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSrvKeyspaceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetSrvKeyspaceResponse proto.InternalMessageInfo

func (m *GetSrvKeyspaceResponse) GetSrvKeyspace() *topodata.SrvKeyspace {
	if m != nil {
		return m.SrvKeyspace
	}
	return nil
}

// UpdateStreamRequest is the payload to UpdateStream.
type UpdateStreamRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// shard to target the query to, for unsharded keyspaces.
	Shard string `protobuf:"bytes,3,opt,name=shard" json:"shard,omitempty"`
	// KeyRange to target the query to, for sharded keyspaces.
	KeyRange *topodata.KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange" json:"key_range,omitempty"`
	// tablet_type is the type of tablets that this request is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,5,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// timestamp is the timestamp to start the stream from.  It is
	// unused is event is set, and we are only streaming from the shard
	// described by event.shard.
	Timestamp int64 `protobuf:"varint,6,opt,name=timestamp" json:"timestamp,omitempty"`
	// event is the event to start the stream from.
	// Note it is only used if we are streaming from exactly the same shard
	// as this event was coming from. Otherwise we can't use this event,
	// and will use the timestamp as a starting point.
	Event                *query.EventToken `protobuf:"bytes,7,opt,name=event" json:"event,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateStreamRequest) Reset()         { *m = UpdateStreamRequest{} }
func (m *UpdateStreamRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateStreamRequest) ProtoMessage()    {}
func (*UpdateStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{43}
}
func (m *UpdateStreamRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateStreamRequest.Unmarshal(m, b)
}
func (m *UpdateStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateStreamRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateStreamRequest.Merge(dst, src)
}
func (m *UpdateStreamRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateStreamRequest.Size(m)
}
func (m *UpdateStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateStreamRequest proto.InternalMessageInfo

func (m *UpdateStreamRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *UpdateStreamRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *UpdateStreamRequest) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *UpdateStreamRequest) GetKeyRange() *topodata.KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *UpdateStreamRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *UpdateStreamRequest) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *UpdateStreamRequest) GetEvent() *query.EventToken {
	if m != nil {
		return m.Event
	}
	return nil
}

// UpdateStreamResponse is streamed by UpdateStream.
type UpdateStreamResponse struct {
	// event is one event from the stream.
	Event *query.StreamEvent `protobuf:"bytes,1,opt,name=event" json:"event,omitempty"`
	// resume_timestamp is the timestamp to resume streaming from if the
	// client is interrupted. If the Update Stream only goes to one
	// shard, this is equal to event.timestamp. If the Update Stream
	// goes to multiple shards and aggregates, this is the minimum value
	// of the current timestamp for all shards.
	ResumeTimestamp      int64    `protobuf:"varint,2,opt,name=resume_timestamp,json=resumeTimestamp" json:"resume_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateStreamResponse) Reset()         { *m = UpdateStreamResponse{} }
func (m *UpdateStreamResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateStreamResponse) ProtoMessage()    {}
func (*UpdateStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_vtgate_229a16ae636de397, []int{44}
}
func (m *UpdateStreamResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateStreamResponse.Unmarshal(m, b)
}
func (m *UpdateStreamResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateStreamResponse.Marshal(b, m, deterministic)
}
func (dst *UpdateStreamResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateStreamResponse.Merge(dst, src)
}
func (m *UpdateStreamResponse) XXX_Size() int {
	return xxx_messageInfo_UpdateStreamResponse.Size(m)
}
func (m *UpdateStreamResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateStreamResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateStreamResponse proto.InternalMessageInfo

func (m *UpdateStreamResponse) GetEvent() *query.StreamEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *UpdateStreamResponse) GetResumeTimestamp() int64 {
	if m != nil {
		return m.ResumeTimestamp
	}
	return 0
}

func init() {
	proto.RegisterType((*Session)(nil), "vtgate.Session")
	proto.RegisterType((*Session_ShardSession)(nil), "vtgate.Session.ShardSession")
	proto.RegisterType((*ExecuteRequest)(nil), "vtgate.ExecuteRequest")
	proto.RegisterType((*ExecuteResponse)(nil), "vtgate.ExecuteResponse")
	proto.RegisterType((*ExecuteShardsRequest)(nil), "vtgate.ExecuteShardsRequest")
	proto.RegisterType((*ExecuteShardsResponse)(nil), "vtgate.ExecuteShardsResponse")
	proto.RegisterType((*ExecuteKeyspaceIdsRequest)(nil), "vtgate.ExecuteKeyspaceIdsRequest")
	proto.RegisterType((*ExecuteKeyspaceIdsResponse)(nil), "vtgate.ExecuteKeyspaceIdsResponse")
	proto.RegisterType((*ExecuteKeyRangesRequest)(nil), "vtgate.ExecuteKeyRangesRequest")
	proto.RegisterType((*ExecuteKeyRangesResponse)(nil), "vtgate.ExecuteKeyRangesResponse")
	proto.RegisterType((*ExecuteEntityIdsRequest)(nil), "vtgate.ExecuteEntityIdsRequest")
	proto.RegisterType((*ExecuteEntityIdsRequest_EntityId)(nil), "vtgate.ExecuteEntityIdsRequest.EntityId")
	proto.RegisterType((*ExecuteEntityIdsResponse)(nil), "vtgate.ExecuteEntityIdsResponse")
	proto.RegisterType((*ExecuteBatchRequest)(nil), "vtgate.ExecuteBatchRequest")
	proto.RegisterType((*ExecuteBatchResponse)(nil), "vtgate.ExecuteBatchResponse")
	proto.RegisterType((*BoundShardQuery)(nil), "vtgate.BoundShardQuery")
	proto.RegisterType((*ExecuteBatchShardsRequest)(nil), "vtgate.ExecuteBatchShardsRequest")
	proto.RegisterType((*ExecuteBatchShardsResponse)(nil), "vtgate.ExecuteBatchShardsResponse")
	proto.RegisterType((*BoundKeyspaceIdQuery)(nil), "vtgate.BoundKeyspaceIdQuery")
	proto.RegisterType((*ExecuteBatchKeyspaceIdsRequest)(nil), "vtgate.ExecuteBatchKeyspaceIdsRequest")
	proto.RegisterType((*ExecuteBatchKeyspaceIdsResponse)(nil), "vtgate.ExecuteBatchKeyspaceIdsResponse")
	proto.RegisterType((*StreamExecuteRequest)(nil), "vtgate.StreamExecuteRequest")
	proto.RegisterType((*StreamExecuteResponse)(nil), "vtgate.StreamExecuteResponse")
	proto.RegisterType((*StreamExecuteShardsRequest)(nil), "vtgate.StreamExecuteShardsRequest")
	proto.RegisterType((*StreamExecuteShardsResponse)(nil), "vtgate.StreamExecuteShardsResponse")
	proto.RegisterType((*StreamExecuteKeyspaceIdsRequest)(nil), "vtgate.StreamExecuteKeyspaceIdsRequest")
	proto.RegisterType((*StreamExecuteKeyspaceIdsResponse)(nil), "vtgate.StreamExecuteKeyspaceIdsResponse")
	proto.RegisterType((*StreamExecuteKeyRangesRequest)(nil), "vtgate.StreamExecuteKeyRangesRequest")
	proto.RegisterType((*StreamExecuteKeyRangesResponse)(nil), "vtgate.StreamExecuteKeyRangesResponse")
	proto.RegisterType((*BeginRequest)(nil), "vtgate.BeginRequest")
	proto.RegisterType((*BeginResponse)(nil), "vtgate.BeginResponse")
	proto.RegisterType((*CommitRequest)(nil), "vtgate.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "vtgate.CommitResponse")
	proto.RegisterType((*RollbackRequest)(nil), "vtgate.RollbackRequest")
	proto.RegisterType((*RollbackResponse)(nil), "vtgate.RollbackResponse")
	proto.RegisterType((*ResolveTransactionRequest)(nil), "vtgate.ResolveTransactionRequest")
	proto.RegisterType((*MessageStreamRequest)(nil), "vtgate.MessageStreamRequest")
	proto.RegisterType((*MessageAckRequest)(nil), "vtgate.MessageAckRequest")
	proto.RegisterType((*IdKeyspaceId)(nil), "vtgate.IdKeyspaceId")
	proto.RegisterType((*MessageAckKeyspaceIdsRequest)(nil), "vtgate.MessageAckKeyspaceIdsRequest")
	proto.RegisterType((*ResolveTransactionResponse)(nil), "vtgate.ResolveTransactionResponse")
	proto.RegisterType((*SplitQueryRequest)(nil), "vtgate.SplitQueryRequest")
	proto.RegisterType((*SplitQueryResponse)(nil), "vtgate.SplitQueryResponse")
	proto.RegisterType((*SplitQueryResponse_KeyRangePart)(nil), "vtgate.SplitQueryResponse.KeyRangePart")
	proto.RegisterType((*SplitQueryResponse_ShardPart)(nil), "vtgate.SplitQueryResponse.ShardPart")
	proto.RegisterType((*SplitQueryResponse_Part)(nil), "vtgate.SplitQueryResponse.Part")
	proto.RegisterType((*GetSrvKeyspaceRequest)(nil), "vtgate.GetSrvKeyspaceRequest")
	proto.RegisterType((*GetSrvKeyspaceResponse)(nil), "vtgate.GetSrvKeyspaceResponse")
	proto.RegisterType((*UpdateStreamRequest)(nil), "vtgate.UpdateStreamRequest")
	proto.RegisterType((*UpdateStreamResponse)(nil), "vtgate.UpdateStreamResponse")
	proto.RegisterEnum("vtgate.TransactionMode", TransactionMode_name, TransactionMode_value)
}

func init() { proto.RegisterFile("vtgate.proto", fileDescriptor_vtgate_229a16ae636de397) }

var fileDescriptor_vtgate_229a16ae636de397 = []byte{
	// 1858 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x5a, 0x5b, 0x8f, 0x23, 0x47,
	0x15, 0xa6, 0xbb, 0x7d, 0x3d, 0xbe, 0x6e, 0xad, 0x77, 0xd7, 0x71, 0x86, 0x1d, 0xa7, 0xc3, 0x28,
	0x4e, 0xb2, 0xf2, 0x10, 0x07, 0x02, 0x42, 0x48, 0x90, 0xf1, 0x0e, 0x91, 0x95, 0x9d, 0xcd, 0x50,
	0xf6, 0x26, 0x80, 0x88, 0x5a, 0x3d, 0x76, 0xc9, 0xdb, 0xd8, 0xee, 0x76, 0xba, 0xca, 0x0e, 0xc3,
	0x03, 0xca, 0x3f, 0x88, 0x78, 0x40, 0x42, 0x11, 0x12, 0x42, 0x42, 0x42, 0x42, 0xe2, 0x15, 0x09,
	0x78, 0xe1, 0x8d, 0x47, 0xc4, 0x13, 0xef, 0xfc, 0x01, 0x24, 0x7e, 0x41, 0xd4, 0x55, 0xd5, 0x17,
	0xf7, 0x8c, 0x3d, 0x1e, 0xcf, 0x45, 0xde, 0xb7, 0xae, 0x53, 0xd5, 0x55, 0xdf, 0xf9, 0xce, 0x57,
	0xa7, 0x4e, 0x97, 0x0d, 0xf9, 0x39, 0x1b, 0x9a, 0x8c, 0x34, 0xa7, 0xae, 0xc3, 0x1c, 0x94, 0x12,
	0xad, 0x5a, 0xee, 0x93, 0x19, 0x71, 0x4f, 0x85, 0xb1, 0x56, 0x64, 0xce, 0xd4, 0x19, 0x98, 0xcc,
	0x94, 0xed, 0xdc, 0x9c, 0xb9, 0xd3, 0xbe, 0x68, 0xe8, 0x7f, 0xd2, 0x20, 0xdd, 0x25, 0x94, 0x5a,
	0x8e, 0x8d, 0xf6, 0xa0, 0x68, 0xd9, 0x06, 0x73, 0x4d, 0x9b, 0x9a, 0x7d, 0x66, 0x39, 0x76, 0x55,
	0xa9, 0x2b, 0x8d, 0x0c, 0x2e, 0x58, 0x76, 0x2f, 0x34, 0xa2, 0x36, 0x14, 0xe9, 0x73, 0xd3, 0x1d,
	0x18, 0x54, 0xbc, 0x47, 0xab, 0x6a, 0x5d, 0x6b, 0xe4, 0x5a, 0x3b, 0x4d, 0x89, 0x45, 0xce, 0xd7,
	0xec, 0x7a, 0xa3, 0x64, 0x03, 0x17, 0x68, 0xa4, 0x45, 0xd1, 0xcb, 0x90, 0xa5, 0x96, 0x3d, 0x1c,
	0x13, 0x63, 0x70, 0x52, 0xd5, 0xf8, 0x32, 0x19, 0x61, 0x78, 0x7c, 0x82, 0x1e, 0x02, 0x98, 0x33,
	0xe6, 0xf4, 0x9d, 0xc9, 0xc4, 0x62, 0xd5, 0x04, 0xef, 0x8d, 0x58, 0xd0, 0xab, 0x50, 0x60, 0xa6,
	0x3b, 0x24, 0xcc, 0xa0, 0xcc, 0xb5, 0xec, 0x61, 0x35, 0x59, 0x57, 0x1a, 0x59, 0x9c, 0x17, 0xc6,
	0x2e, 0xb7, 0xa1, 0x7d, 0x48, 0x3b, 0x53, 0xc6, 0xf1, 0xa5, 0xea, 0x4a, 0x23, 0xd7, 0xba, 0xd7,
	0x14, 0xac, 0x1c, 0xfe, 0x9c, 0xf4, 0x67, 0x8c, 0x7c, 0x20, 0x3a, 0xb1, 0x3f, 0x0a, 0x1d, 0x40,
	0x39, 0xe2, 0xbb, 0x31, 0x71, 0x06, 0xa4, 0x9a, 0xae, 0x2b, 0x8d, 0x62, 0xeb, 0x81, 0xef, 0x59,
	0x84, 0x86, 0x23, 0x67, 0x40, 0x70, 0x89, 0x2d, 0x1a, 0x6a, 0x3f, 0x85, 0x7c, 0xd4, 0x6b, 0xb4,
	0x07, 0x29, 0x01, 0x8a, 0x53, 0x99, 0x6b, 0x15, 0x24, 0x86, 0x1e, 0x37, 0x62, 0xd9, 0xe9, 0x31,
	0x1f, 0x5d, 0xda, 0x1a, 0x54, 0xd5, 0xba, 0xd2, 0xd0, 0x70, 0x21, 0x62, 0xed, 0x0c, 0xf4, 0x7f,
	0xa9, 0x50, 0x94, 0xe8, 0x31, 0xf9, 0x64, 0x46, 0x28, 0x43, 0x8f, 0x20, 0xdb, 0x37, 0xc7, 0x63,
	0xe2, 0x7a, 0x2f, 0x89, 0x35, 0x4a, 0x4d, 0x11, 0xe0, 0x36, 0xb7, 0x77, 0x1e, 0xe3, 0x8c, 0x18,
	0xd1, 0x19, 0xa0, 0xd7, 0x21, 0x2d, 0x83, 0xc6, 0x17, 0x10, 0x63, 0xa3, 0x31, 0xc3, 0x7e, 0x3f,
	0x7a, 0x0d, 0x92, 0x1c, 0x2a, 0x0f, 0x4e, 0xae, 0x75, 0x47, 0x02, 0x3f, 0x70, 0x66, 0xf6, 0xe0,
	0x87, 0xde, 0x23, 0x16, 0xfd, 0xe8, 0x9b, 0x90, 0x63, 0xe6, 0xc9, 0x98, 0x30, 0x83, 0x9d, 0x4e,
	0x09, 0x8f, 0x56, 0xb1, 0x55, 0x69, 0x06, 0xa2, 0xeb, 0xf1, 0xce, 0xde, 0xe9, 0x94, 0x60, 0x60,
	0xc1, 0x33, 0x7a, 0x04, 0xc8, 0x76, 0x98, 0x11, 0x13, 0x5c, 0x92, 0xc7, 0xba, 0x6c, 0x3b, 0xac,
	0xb3, 0xa0, 0xb9, 0x3d, 0x28, 0x8e, 0xc8, 0x29, 0x9d, 0x9a, 0x7d, 0x62, 0x70, 0x21, 0xf1, 0x98,
	0x66, 0x71, 0xc1, 0xb7, 0x72, 0xd6, 0xa3, 0x31, 0x4f, 0xaf, 0x13, 0x73, 0xfd, 0x73, 0x05, 0x4a,
	0x01, 0xa3, 0x74, 0xea, 0xd8, 0x94, 0xa0, 0x3d, 0x48, 0x12, 0xd7, 0x75, 0xdc, 0x18, 0x9d, 0xf8,
	0xb8, 0x7d, 0xe8, 0x99, 0xb1, 0xe8, 0xbd, 0x0c, 0x97, 0x6f, 0x40, 0xca, 0x25, 0x74, 0x36, 0x66,
	0x92, 0x4c, 0x24, 0x51, 0x09, 0x1e, 0x79, 0x0f, 0x96, 0x23, 0xf4, 0xff, 0xaa, 0x50, 0x91, 0x88,
	0xb8, 0x4f, 0x74, 0x7b, 0x22, 0x5d, 0x83, 0x8c, 0x4f, 0x37, 0x0f, 0x73, 0x16, 0x07, 0x6d, 0x74,
	0x1f, 0x52, 0x3c, 0x2e, 0xb4, 0x9a, 0xac, 0x6b, 0x8d, 0x2c, 0x96, 0xad, 0xb8, 0x3a, 0x52, 0x57,
	0x52, 0x47, 0x7a, 0x89, 0x3a, 0x22, 0x61, 0xcf, 0xac, 0x15, 0xf6, 0x5f, 0x2b, 0x70, 0x2f, 0x46,
	0xf2, 0x56, 0x04, 0xff, 0xff, 0x2a, 0xbc, 0x24, 0x71, 0xbd, 0x2f, 0x99, 0xed, 0xbc, 0x28, 0x0a,
	0x78, 0x05, 0xf2, 0xc1, 0x16, 0xb5, 0xa4, 0x0e, 0xf2, 0x38, 0x37, 0x0a, 0xfd, 0xd8, 0x52, 0x31,
	0x7c, 0xa1, 0x40, 0xed, 0x3c, 0xd2, 0xb7, 0x42, 0x11, 0x9f, 0x69, 0xf0, 0x20, 0x04, 0x87, 0x4d,
	0x7b, 0x48, 0x5e, 0x10, 0x3d, 0xbc, 0x05, 0x30, 0x22, 0xa7, 0x86, 0xcb, 0x21, 0x73, 0x35, 0x78,
	0x9e, 0x06, 0xb1, 0xf6, 0xbd, 0xc1, 0xd9, 0x91, 0xef, 0xd7, 0x96, 0xea, 0xe3, 0x37, 0x0a, 0x54,
	0xcf, 0x86, 0x60, 0x2b, 0xd4, 0xf1, 0xd7, 0x44, 0xa0, 0x8e, 0x43, 0x9b, 0x59, 0xec, 0xf4, 0x85,
	0xc9, 0x16, 0x8f, 0x00, 0x11, 0x8e, 0xd8, 0xe8, 0x3b, 0xe3, 0xd9, 0xc4, 0x36, 0x6c, 0x73, 0x42,
	0x64, 0x1d, 0x57, 0x16, 0x3d, 0x6d, 0xde, 0xf1, 0xd4, 0x9c, 0x10, 0xf4, 0x23, 0xb8, 0x2b, 0x47,
	0x2f, 0xa4, 0x98, 0x14, 0x17, 0x55, 0xc3, 0x47, 0xba, 0x84, 0x89, 0xa6, 0x6f, 0xc0, 0x77, 0xc4,
	0x24, 0xef, 0x2f, 0x4f, 0x49, 0xe9, 0x2b, 0x49, 0x2e, 0x73, 0xb1, 0xe4, 0xb2, 0xeb, 0x48, 0xae,
	0x76, 0x02, 0x19, 0x1f, 0x34, 0xda, 0x85, 0x04, 0x87, 0xa6, 0x70, 0x68, 0x39, 0xbf, 0x80, 0xf4,
	0x10, 0xf1, 0x0e, 0x54, 0x81, 0xe4, 0xdc, 0x1c, 0xcf, 0x08, 0x0f, 0x5c, 0x1e, 0x8b, 0x06, 0xda,
	0x85, 0x5c, 0x84, 0x2b, 0x1e, 0xab, 0x3c, 0x86, 0x30, 0x1b, 0x47, 0x65, 0x1d, 0x61, 0x6c, 0x2b,
	0x64, 0xfd, 0x6f, 0x15, 0xee, 0x4a, 0x68, 0x07, 0x26, 0xeb, 0x3f, 0xbf, 0x71, 0x49, 0xbf, 0x09,
	0x69, 0x0f, 0x8d, 0x45, 0x68, 0x55, 0xe3, 0x9a, 0x3a, 0x47, 0xd4, 0xfe, 0x88, 0x4d, 0x0b, 0xde,
	0x3d, 0x28, 0x9a, 0xf4, 0x9c, 0x62, 0xb7, 0x60, 0xd2, 0xdb, 0xa8, 0x74, 0xbf, 0x50, 0x82, 0xba,
	0x52, 0x72, 0x7a, 0x63, 0xa1, 0xfe, 0x3a, 0xa4, 0x45, 0x20, 0x7d, 0x36, 0xef, 0x4b, 0x6c, 0x22,
	0xcc, 0x1f, 0x59, 0xec, 0xb9, 0x98, 0xda, 0x1f, 0xa6, 0xdb, 0x50, 0xe2, 0x4c, 0x73, 0xdf, 0x38,
	0xdd, 0x61, 0x96, 0x51, 0x2e, 0x91, 0x65, 0xd4, 0xa5, 0x55, 0xa9, 0x16, 0xad, 0x4a, 0xf5, 0xbf,
	0x84, 0x75, 0x16, 0x27, 0xe3, 0x96, 0x2a, 0xed, 0xb7, 0xe2, 0x32, 0x0b, 0x3e, 0x2c, 0x63, 0xde,
	0xdf, 0x96, 0xd8, 0x2e, 0xfb, 0x8d, 0xac, 0xff, 0x36, 0xac, 0x95, 0x16, 0x88, 0xbb, 0x31, 0x2d,
	0x3d, 0x8a, 0x6b, 0xe9, 0xbc, 0xbc, 0x11, 0xe8, 0xe8, 0x97, 0x50, 0xe1, 0x4c, 0x86, 0x19, 0xfe,
	0x1a, 0xc5, 0x14, 0x2f, 0x70, 0xb5, 0x33, 0x05, 0xae, 0xfe, 0x0f, 0x15, 0x1e, 0x46, 0xe9, 0xb9,
	0xcd, 0x22, 0xfe, 0x9d, 0xb8, 0xb8, 0x76, 0x16, 0xc4, 0x15, 0xa3, 0x64, 0x6b, 0x15, 0xf6, 0x7b,
	0x05, 0x76, 0x97, 0x52, 0xb8, 0x25, 0x32, 0xfb, 0xa3, 0x0a, 0x95, 0x2e, 0x73, 0x89, 0x39, 0xb9,
	0xd2, 0x6d, 0x4c, 0xa0, 0x4a, 0xf5, 0x72, 0x57, 0x2c, 0xda, 0xfa, 0x21, 0x8a, 0x1d, 0x25, 0x89,
	0x0b, 0x8e, 0x92, 0xe4, 0x5a, 0x17, 0x65, 0x11, 0x5e, 0x53, 0xab, 0x79, 0xd5, 0xdb, 0x70, 0x2f,
	0x46, 0x94, 0x0c, 0x61, 0x58, 0x0e, 0x28, 0x17, 0x96, 0x03, 0x9f, 0xab, 0x50, 0x5b, 0x98, 0xe5,
	0x2a, 0xe9, 0x7a, 0x6d, 0xd2, 0xa3, 0xa9, 0x40, 0x5b, 0x7a, 0xae, 0x24, 0x56, 0xdd, 0x76, 0x24,
	0xd7, 0x0c, 0xd4, 0xa5, 0x37, 0x49, 0x07, 0x5e, 0x3e, 0x97, 0x90, 0x0d, 0xc8, 0xfd, 0x9d, 0x0a,
	0xbb, 0x0b, 0x73, 0x5d, 0x39, 0x67, 0x5d, 0x0b, 0xc3, 0xf1, 0x64, 0x9b, 0xb8, 0xf0, 0x36, 0xe1,
	0xc6, 0xc8, 0x7e, 0x0a, 0xf5, 0xe5, 0x04, 0x6d, 0xc0, 0xf8, 0x9f, 0x55, 0xf8, 0x6a, 0x7c, 0xc2,
	0xab, 0x7c, 0xd8, 0x5f, 0x0b, 0xdf, 0x8b, 0x5f, 0xeb, 0x89, 0x0d, 0xbe, 0xd6, 0x6f, 0x8c, 0xff,
	0x27, 0xf0, 0x70, 0x19, 0x5d, 0x1b, 0xb0, 0xff, 0x63, 0xc8, 0x1f, 0x90, 0xa1, 0x65, 0x6f, 0xc6,
	0xf5, 0xc2, 0xcf, 0x16, 0xea, 0xe2, 0xcf, 0x16, 0xfa, 0x77, 0xa0, 0x20, 0xa7, 0x96, 0xb8, 0x22,
	0x89, 0x52, 0xb9, 0x20, 0x51, 0x7e, 0xa6, 0x40, 0xa1, 0xcd, 0x7f, 0xdd, 0xb8, 0xf1, 0x42, 0xe1,
	0x3e, 0xa4, 0x4c, 0xe6, 0x4c, 0xac, 0xbe, 0xfc, 0xdd, 0x45, 0xb6, 0xf4, 0x32, 0x14, 0x7d, 0x04,
	0x02, 0xbf, 0xfe, 0x33, 0x28, 0x61, 0x67, 0x3c, 0x3e, 0x31, 0xfb, 0xa3, 0x9b, 0x46, 0xa5, 0x23,
	0x28, 0x87, 0x6b, 0xc9, 0xf5, 0x3f, 0x86, 0x97, 0x30, 0xa1, 0xce, 0x78, 0x4e, 0x22, 0x25, 0xc5,
	0x66, 0x48, 0x10, 0x24, 0x06, 0x4c, 0xfe, 0xae, 0x92, 0xc5, 0xfc, 0x59, 0xff, 0xbb, 0x02, 0x95,
	0x23, 0x42, 0xa9, 0x39, 0x24, 0x42, 0x60, 0x9b, 0x4d, 0xbd, 0xaa, 0x66, 0xac, 0x40, 0x52, 0x9c,
	0xbc, 0x62, 0xbf, 0x89, 0x06, 0xda, 0x87, 0x6c, 0xb0, 0xd9, 0xf8, 0x99, 0x7c, 0xfe, 0x5e, 0xcb,
	0xf8, 0x7b, 0xcd, 0x43, 0x1f, 0xb9, 0x1f, 0xe1, 0xcf, 0xfa, 0xaf, 0x14, 0xb8, 0x23, 0xd1, 0xbf,
	0xbb, 0x69, 0x7c, 0x56, 0x41, 0xf7, 0xd7, 0xd4, 0xc2, 0x35, 0xd1, 0x43, 0xd0, 0xfc, 0x64, 0x9c,
	0x6b, 0xe5, 0xe5, 0x2e, 0xfb, 0xd0, 0x1c, 0xcf, 0x08, 0xf6, 0x3a, 0xf4, 0x23, 0xc8, 0x77, 0x22,
	0x95, 0x26, 0xda, 0x01, 0x35, 0x80, 0xb1, 0x38, 0x5c, 0xb5, 0x06, 0xf1, 0x2b, 0x0a, 0xf5, 0xcc,
	0x15, 0xc5, 0xdf, 0x14, 0xd8, 0x09, 0x5d, 0xbc, 0xf2, 0xc1, 0x74, 0x59, 0x6f, 0xbf, 0x0b, 0x25,
	0x6b, 0x60, 0x9c, 0x39, 0x86, 0x72, 0xad, 0x8a, 0xaf, 0xe2, 0xa8, 0xb3, 0xb8, 0x60, 0x45, 0x5a,
	0x54, 0xdf, 0x81, 0xda, 0x79, 0xe2, 0x95, 0xd2, 0xfe, 0x9f, 0x0a, 0x77, 0xba, 0xd3, 0xb1, 0xc5,
	0x64, 0x8e, 0xba, 0x6e, 0x7f, 0xd6, 0xbe, 0xa4, 0x7b, 0x05, 0xf2, 0xd4, 0xc3, 0x21, 0xef, 0xe1,
	0x64, 0x41, 0x93, 0xe3, 0x36, 0x71, 0x03, 0xe7, 0xc5, 0xc9, 0x1f, 0x32, 0xb3, 0x19, 0x17, 0xa1,
	0x86, 0x41, 0x8e, 0x98, 0xd9, 0x0c, 0x7d, 0x03, 0x1e, 0xd8, 0xb3, 0x89, 0xe1, 0x3a, 0x9f, 0x52,
	0x63, 0x4a, 0x5c, 0x83, 0xcf, 0x6c, 0x4c, 0x4d, 0x97, 0xf1, 0x14, 0xaf, 0xe1, 0xbb, 0xf6, 0x6c,
	0x82, 0x9d, 0x4f, 0xe9, 0x31, 0x71, 0xf9, 0xe2, 0xc7, 0xa6, 0xcb, 0xd0, 0xf7, 0x21, 0x6b, 0x8e,
	0x87, 0x8e, 0x6b, 0xb1, 0xe7, 0x13, 0x79, 0xf1, 0xa6, 0x4b, 0x98, 0x67, 0x98, 0x69, 0xbe, 0xeb,
	0x8f, 0xc4, 0xe1, 0x4b, 0xe8, 0x4d, 0x40, 0x33, 0x4a, 0x0c, 0x01, 0x4e, 0x2c, 0x3a, 0x6f, 0xc9,
	0x5b, 0xb8, 0xd2, 0x8c, 0x92, 0x70, 0x9a, 0x0f, 0x5b, 0xfa, 0x3f, 0x35, 0x40, 0xd1, 0x79, 0x65,
	0x8e, 0xfe, 0x16, 0xa4, 0xf8, 0xfb, 0xb4, 0xaa, 0xf0, 0xd8, 0xee, 0x06, 0x19, 0xea, 0xcc, 0xd8,
	0xa6, 0x07, 0x1b, 0xcb, 0xe1, 0xb5, 0x8f, 0x21, 0xef, 0xef, 0x54, 0xee, 0x4e, 0x34, 0x1a, 0xca,
	0xca, 0xd3, 0x55, 0x5d, 0xe3, 0x74, 0xad, 0x7d, 0x0f, 0xb2, 0xbc, 0xaa, 0xbb, 0x70, 0xee, 0xb0,
	0x16, 0x55, 0xa3, 0xb5, 0x68, 0xed, 0x3f, 0x0a, 0x24, 0xf8, 0xcb, 0x6b, 0x7f, 0xfc, 0x1e, 0xf1,
	0xef, 0x05, 0x81, 0x52, 0x44, 0x4f, 0x24, 0xed, 0xd7, 0x56, 0x50, 0x12, 0xa5, 0x00, 0xe7, 0x47,
	0x51, 0x42, 0xda, 0x00, 0xe2, 0x7f, 0x02, 0x7c, 0x2a, 0xa1, 0xc3, 0xaf, 0xad, 0x98, 0x2a, 0x70,
	0x17, 0x67, 0x69, 0xe0, 0x39, 0x82, 0x04, 0xb5, 0x7e, 0x21, 0xb2, 0xa4, 0x86, 0xf9, 0xb3, 0xfe,
	0x36, 0xdc, 0x7b, 0x8f, 0xb0, 0xae, 0x3b, 0xf7, 0xb7, 0x9b, 0xbf, 0x7d, 0x56, 0xd0, 0xa4, 0x63,
	0xb8, 0x1f, 0x7f, 0x49, 0x2a, 0xe0, 0xdb, 0x90, 0xa7, 0xee, 0xdc, 0x58, 0x78, 0xd3, 0xab, 0x4a,
	0x82, 0xf0, 0x44, 0x5f, 0xca, 0xd1, 0xb0, 0xa1, 0xff, 0x41, 0x85, 0xbb, 0xcf, 0xa6, 0x03, 0x93,
	0x6d, 0xfb, 0xf9, 0xb1, 0x61, 0xa9, 0xb6, 0x03, 0x59, 0x66, 0x4d, 0x08, 0x65, 0xe6, 0x64, 0x2a,
	0x77, 0x72, 0x68, 0xf0, 0x74, 0x45, 0xe6, 0xc4, 0x66, 0xf2, 0x02, 0xd2, 0xd7, 0xd5, 0xa1, 0x67,
	0xeb, 0x39, 0x23, 0x62, 0x63, 0xd1, 0xaf, 0x8f, 0xa0, 0xb2, 0xc8, 0x92, 0x24, 0xbe, 0xe1, 0x4f,
	0xb0, 0x58, 0xb5, 0xc9, 0x62, 0xcf, 0xeb, 0x91, 0x33, 0xa0, 0xd7, 0xa1, 0xec, 0x95, 0x6f, 0x13,
	0x62, 0x84, 0x78, 0xc4, 0x3f, 0x24, 0x4a, 0xc2, 0xde, 0xf3, 0xcd, 0x6f, 0x3c, 0x86, 0x52, 0xec,
	0x5f, 0x1a, 0xa8, 0x04, 0xb9, 0x67, 0x4f, 0xbb, 0xc7, 0x87, 0xed, 0xce, 0x0f, 0x3a, 0x87, 0x8f,
	0xcb, 0x5f, 0x41, 0x00, 0xa9, 0x6e, 0xe7, 0xe9, 0x7b, 0x4f, 0x0e, 0xcb, 0x0a, 0xca, 0x42, 0xf2,
	0xe8, 0xd9, 0x93, 0x5e, 0xa7, 0xac, 0x7a, 0x8f, 0xbd, 0x8f, 0x3e, 0x38, 0x6e, 0x97, 0xb5, 0x83,
	0x77, 0xa0, 0x64, 0x39, 0xcd, 0xb9, 0xc5, 0x08, 0xa5, 0xe2, 0x9f, 0x32, 0x3f, 0x79, 0x55, 0xb6,
	0x2c, 0x67, 0x5f, 0x3c, 0xed, 0x0f, 0x9d, 0xfd, 0x39, 0xdb, 0xe7, 0xbd, 0xfb, 0x42, 0xd6, 0x27,
	0x29, 0xde, 0x7a, 0xfb, 0xcb, 0x00, 0x00, 0x00, 0xff, 0xff, 0x61, 0xd9, 0xf8, 0xab, 0x97, 0x23,
	0x00, 0x00,
}
