/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.Abbreviator;

public class ClassNameAbbreviator
implements Abbreviator {
    private static final int BUF_LIMIT = 256;
    private static final int MAX_DOTS = 12;
    final int targetLength;
    StringBuffer buf;

    public ClassNameAbbreviator(int targetLength) {
        this.targetLength = targetLength;
        this.buf = new StringBuffer(targetLength);
    }

    public String abbreviate(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Class name may not be null");
        }
        int inLen = className.length();
        if (inLen < this.targetLength) {
            return className;
        }
        if (this.buf.capacity() > 256) {
            this.buf = new StringBuffer(this.targetLength);
        }
        this.buf.setLength(0);
        int[] dotArray = new int[12];
        int[] lengthArray = new int[12];
        int dotCount = this.computeIndexes(className, dotArray);
        if (dotCount == 0) {
            return className;
        }
        this.computeLengthArray(className, dotArray, lengthArray, dotCount);
        int i = 0;
        while (i <= dotCount) {
            if (i == 0) {
                this.buf.append(className.substring(0, lengthArray[i] - 1));
            } else {
                this.buf.append(className.substring(dotArray[i - 1], dotArray[i - 1] + lengthArray[i]));
            }
            ++i;
        }
        return this.buf.toString();
    }

    int computeIndexes(String className, int[] dotArray) {
        int dotCount;
        int k = 0;
        for (dotCount = 0; (k = className.indexOf(46, k)) != -1 && dotCount < 12; ++dotCount) {
            dotArray[dotCount] = k++;
        }
        return dotCount;
    }

    void computeLengthArray(String className, int[] dotArray, int[] lengthArray, int dotCount) {
        int toTrim = className.length() - this.targetLength;
        int i = 0;
        while (i < dotCount) {
            int available;
            int len;
            int previousDotPosition = -1;
            if (i > 0) {
                previousDotPosition = dotArray[i - 1];
            }
            int n = len = (available = dotArray[i] - previousDotPosition - 1) < 1 ? available : 1;
            len = toTrim > 0 ? (available < 1 ? available : 1) : available;
            toTrim -= available - len;
            lengthArray[i] = len + 1;
            ++i;
        }
        int lastDotIndex = dotCount - 1;
        lengthArray[dotCount] = className.length() - dotArray[lastDotIndex];
    }

    static void printArray(String msg, int[] ia) {
        System.out.print(msg);
        int i = 0;
        while (i < ia.length) {
            if (i == 0) {
                System.out.print(ia[i]);
            } else {
                System.out.print(", " + ia[i]);
            }
            ++i;
        }
        System.out.println();
    }
}

