/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.spi.ContextAwareBase;

public abstract class RollingPolicyBase
extends ContextAwareBase
implements RollingPolicy {
    protected int compressionMode = 0;
    protected FileNamePattern fileNamePattern;
    protected String fileNamePatternStr;
    private FileAppender parent;
    private boolean started;

    protected void determineCompressionMode() {
        if (this.fileNamePatternStr.endsWith(".gz")) {
            this.addInfo("Will use gz compression");
            this.compressionMode = 1;
        } else if (this.fileNamePatternStr.endsWith(".zip")) {
            this.addInfo("Will use zip compression");
            this.compressionMode = 2;
        } else {
            this.addInfo("No compression will be used");
            this.compressionMode = 0;
        }
    }

    public void setFileNamePattern(String fnp) {
        this.fileNamePatternStr = fnp;
    }

    public String getFileNamePattern() {
        return this.fileNamePatternStr;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public void setParent(FileAppender appender) {
        this.addInfo("Adding parent to RollingPolicy: " + appender.getName());
        this.parent = appender;
    }

    public String getParentFileName() {
        return this.parent.getFile();
    }

    protected void setParentFileName(String newFileName) {
        this.parent.setFile(newFileName);
    }
}

