#include "config.h"

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/file.h>
#include <fcntl.h>
#include "timselsysdep.h"
#include "uostr.h"
#include "uoio.h"
#include "uogetopt.h"
#include "smtp.h"
#include "smtptools.h"
#include "str_ulong.h"

char *myhostname=0;

/* user changeable options */
char *greeting=NULL;
static char *content_type;
static char *transfer_encoding;
static char *date;
static char *from;
static char *to;
static char *cc;
static char *bcc;
static char *subject;
static char *return_path;
static char *reply_to;
static uostr_t extra_header={0};

static void
h_callback(struct uogetopt *uo UO_ATTRIB_UNUSED, const char *s)
{
	uostr_xadd_cstr(&extra_header,s);
	uostr_xadd_char(&extra_header,'\n');
}

static struct uogetopt myopts[]={
	{'b',"bcc", UOGO_STRING,&bcc,0, "`bcc' addresses\n"
		"separate multiple addresses with commas.\n","ADDRESS"},
	{'c',"cc", UOGO_STRING,&cc,0, "`cc' addresses\n"
		"separate multiple addresses with commas.\n","ADDRESS"},
	{'d',"date", UOGO_STRING,&date,0, "Date-Header\n"
		"`now' is a legal value, as is `today'\n","RFC-Date"},
	{'f',"from", UOGO_STRING,&from,0, "`From' address (you)","ADDRESS"},
	{'h',"header", UOGO_CALLBACK,&h_callback,0, "extra header line\n"
		"Use a complete header line: `Keyword: content'" ,"ADDRESS"},
	{'p',"return-path", UOGO_STRING,&return_path,0, "`Reply-Path' address\n","ADDRESS"},
	{'r',"reply-to", UOGO_STRING,&reply_to,0, "`Reply-To' address\n","ADDRESS"},
	{'s',"subject", UOGO_STRING,&subject,0, "subject\n","ADDRESS"},
	{'t',"to", UOGO_STRING,&to,0, "`To' addresses\n"
		"separate multiple addresses with commas.\n","ADDRESS"},
	{'C',"content-type", UOGO_STRING,&content_type,0, "content_type","??/???"},
	{'E',"content-transfer-encoding", UOGO_STRING,&transfer_encoding,0, "content-transfer-encoding","??/???"},
	{0,0}
};

struct part {
	const char *fname;
	const char *content_type;
	const char *transfer_encoding;
	struct part *next;
};
struct part *anker;
struct part *end_anker;

static int 
translate_exitcode(int exitcode)
{
	switch(exitcode) {
	case SMTP_SUCCESS: return (0);
	case SMTP_DEFER: return (111);
	case SMTP_FATAL: return (100);
	default: return (111); /* should never arrive here */
	}
}

int 
main(int argc, char **argv)
{
	char buf[128];
	const char *argv0;
	uostr_t boundary;
	uoio_t o;
	uoio_t e;
	boundary.data=0;
	argv0=strrchr(argv[0],'/'); if (!argv0) argv0=argv[0]; else argv0++;

	if (gethostname(buf,sizeof(buf)-1)==-1) {
		uostr_t s;s.data=0;
		uostr_xdup_cstrmulti(&s,argv0,": hostname too long, gethostname failed: ",strerror(errno),"\n",0);
		write(2,s.data,s.len);
		_exit(translate_exitcode(SMTP_DEFER));
	} else {
		buf[sizeof(buf)-1]=0;
		myhostname=malloc(strlen(buf)+1);
		if (!myhostname) {
			write(2,argv0,strlen(argv0));
			write(2,": out of memory\n",16);
			_exit(translate_exitcode(SMTP_DEFER));
		}
		memcpy(myhostname,buf,strlen(buf)+1);
	}
	greeting=myhostname;

	if (-1==putenv("POSIXLY_CORRECT=sure")) {
		write(2,argv0,strlen(argv0));
		write(2,": putenv failed\n",16);
	}
	while (1) {
		struct part *pa=malloc(sizeof(struct part));
		if (!pa) {
			write(2,argv0,strlen(argv0));
			write(2,": ",2);
			write(2,"out of memory\n",14);
			_exit(1);
		}
		memset(pa,0,sizeof(*pa));
		uogetopt(argv0,PACKAGE,VERSION,&argc,argv,uogetopt_out,
			"usage: mkmail [options]",myopts,0);
		if (argc==1) {
			/* work on stdin */
			if (anker) break;
			pa->fname="-";
			pa->content_type=content_type;
			pa->transfer_encoding=transfer_encoding;
			anker=pa;
			break;
		} else {
			pa->fname=argv[1];
			pa->content_type=content_type;
			pa->transfer_encoding=transfer_encoding;
			if (end_anker)
				end_anker->next=pa;
			else
				anker=pa;
			end_anker=pa;
		}
		argc--;
		argv++;
		if (argc==1) break;
	}

	uoio_assign_w(&o,1,write,0);
	uoio_assign_w(&e,2,write,0);

	/* header */
	if (return_path) {
		if (*return_path=='<') uoio_write_cstrmulti(&o,"Return-Path: ",return_path,"\n",0);
		else uoio_write_cstrmulti(&o,"Return-Path: <",return_path,">\n",0);
	}
	if (from) uoio_write_cstrmulti(&o,"From: ",from,"\n",0);
	if (to) uoio_write_cstrmulti(&o,"To: ",to,"\n",0);
	if (cc) uoio_write_cstrmulti(&o,"Cc: ",cc,"\n",0);
	if (bcc) uoio_write_cstrmulti(&o,"Bcc: ",bcc,"\n",0);
	if (subject) uoio_write_cstrmulti(&o,"Subject: ",subject,"\n",0);
	if (reply_to) uoio_write_cstrmulti(&o,"Reply-To: ",reply_to,"\n",0);
	if (date) {
		char timebuf[40];
		if (0==strcmp(date,"now") || 0==strcmp(date,"today")) {
			time_t t;
			struct tm *tm;
			size_t l;
			static const char *months[] = { 
				"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec" };

			time(&t); tm=gmtime(&t);
			if (0==strcmp(date,"today")) { tm->tm_hour=0; tm->tm_min=0; tm->tm_sec=0; }
			l=0;
			if (tm->tm_mday<10) timebuf[l++]='0'; l+=str_ulong(timebuf+l,tm->tm_mday); timebuf[l++]=' ';
			memcpy(timebuf+l,months[tm->tm_mon],3); l+=3; timebuf[l++]=' ';
			l+=str_ulong(timebuf+l,tm->tm_year+1900); timebuf[l++]=' ';
			if (tm->tm_hour<10) timebuf[l++]='0'; l+=str_ulong(timebuf+l,tm->tm_hour); timebuf[l++]=':';
			if (tm->tm_min<10) timebuf[l++]='0'; l+=str_ulong(timebuf+l,tm->tm_min); timebuf[l++]=':';
			if (tm->tm_sec<10) timebuf[l++]='0'; l+=str_ulong(timebuf+l,tm->tm_sec); timebuf[l++]=0;
			date=timebuf;
		}
		uoio_write_cstrmulti(&o,"Date: ",date,"\n",0);
	}
	if (extra_header.data) uoio_write_uostr(&o,&extra_header);

	if (anker->next) {
		/* make it multipart */
		char numbuf[STR_ULONG];
		struct timeval tv;
		/* we need an unique boundary. And since we do not know what we will
		 * read we will try to be somewhat unique ...
		 * Oh, one way to make it _almost_ sure that the boundary is unique
		 * is to use \0 in it. On the other hand you'll rarely find a mail
		 * reader beeing able to handle this.
		 * [later: Oh, well, mutt seems to be able to!]
		 *
		 * what a stupid design! To know a unique string you have to read
		 * the huge messages _twice_.
		 */
		uostr_xdup_cstr(&boundary,"%s%mkmail-"); /* idiots around? */
		uostr_xadd_cstr(&boundary,myhostname);
		uostr_xadd_char(&boundary,'-');
		str_ulong_base(numbuf,getpid(),14);
		uostr_xadd_cstr(&boundary,numbuf);
		uostr_xadd_char(&boundary,'-');
		gettimeofday(&tv,0);
		str_ulong_base(numbuf,tv.tv_sec,32);
		uostr_xadd_cstr(&boundary,numbuf);
		uostr_xadd_char(&boundary,'.');
		str_ulong_base(numbuf,tv.tv_usec,32);
		uostr_xadd_cstr(&boundary,numbuf);
		uostr_x0(&boundary);
		uoio_write_cstrmulti(&o,"Mime-Version: 1.0\n"
			"Content-Type: multipart/mixed; boundary=",boundary.data,"\n",0);
	} else if (content_type) {
		uoio_write_cstrmulti(&o,"Mime-Version: 1.0\n"
			"Content-Type: ",content_type,"\n",0);
		if (transfer_encoding) {
			uoio_write_cstr(&o,"Content-Transfer-Encoding: ");
			uoio_write_cstr(&o,transfer_encoding);
			uoio_write_char(&o,'\n');
		}
	} else if (transfer_encoding) {
		uoio_write_cstr(&o,"Mime-Version: 1.0\n");
		uoio_write_cstr(&o,"Content-Transfer-Encoding: ");
		uoio_write_cstr(&o,transfer_encoding);
		uoio_write_char(&o,'\n');
	}
	/* finish header */
	uoio_write_char(&o,'\n');

	while (anker) {
		int fd;
		if (boundary.data) {
			uoio_write_cstr(&o,"--");
			uoio_write_cstr(&o,boundary.data);
			uoio_write_char(&o,'\n');
			if (anker->content_type) {
				uoio_write_cstr(&o,"Content-Type: ");
				uoio_write_cstr(&o,anker->content_type);
				uoio_write_char(&o,'\n');
			}
			if (anker->content_type) {
				uoio_write_cstr(&o,"Content-Transfer-Encoding: ");
				uoio_write_cstr(&o,anker->transfer_encoding);
				uoio_write_char(&o,'\n');
			}
			uoio_write_char(&o,'\n');
		}
		if (0==strcmp(anker->fname,"-")) 
			fd=0;
		else {
			fd=open(anker->fname,O_RDONLY);
			if (fd==-1) {
				uoio_write_cstrmulti(&e,argv0,": cannot open: ",anker->fname,": ",strerror(errno),"\n",0);
				uoio_flush(&e);
				_exit(1);
			}
		}
		{
			uoio_t i;
			char *s;
			ssize_t len;
			uoio_assign_r(&i,fd,read,0);
			while (1) {
				len=uoio_getdelim_zc(&i,&s,'\n');
				if (len==-1) {
					uoio_write_cstrmulti(&e,argv0,": cannot read ",
						(0==strcmp(anker->fname,"-")) ? "stdin" : anker->fname,
						": ",strerror(errno),0);
					uoio_flush(&e);
					_exit(1);
				}
				if (len==0) break;
				uoio_write_mem(&o,s,len);
			}
			if (0!=strcmp(anker->fname,"-"))
				close(fd);
		}
		anker=anker->next;
		if (boundary.data) 
			uoio_write_char(&o,'\n'); /* finish part */
	}
	if (boundary.data) {
		uoio_write_cstr(&o,"--");
		uoio_write_cstr(&o,boundary.data);
		uoio_write_cstr(&o,"--");
		uoio_write_char(&o,'\n');
	}
	uoio_flush(&o);
	_exit(0);
}
