/*
** connect.c -- TCP/IP portion of the portmon daemon
** Copyright (C) 2002 Nik Reiman <nik@aboleo.net>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <netdb.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/timeb.h>
#include <sys/types.h>

#include "portmon.h"
#include "config.h"

int sockfd;
int response;

void alarm_signal(int sig)
{
 response = -3;
 close(sockfd);
 return;
}

int tcp_ping(struct sockaddr_in addr, int port)
{
 struct timeb start_time, end_time;

 ftime(&start_time);
 response = 0;

 if(signal(SIGALRM, alarm_signal) == SIG_ERR) {
  perror("SIGALRM");
  exit(2);
 }

 // create a socket
 if((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
  snprintf(err_msg, STRLARGE, "Unable to create a socket\n");
  log_write(err_msg);
  return (-1);
 }

 alarm(timeout);
 if(connect(sockfd, (struct sockaddr *)&addr, sizeof(struct sockaddr)) == -1) {
  response = -2;
 }
 alarm(0);

 if(response == -2) {
  snprintf(err_msg, STRLARGE, "Connection refused to %s:%d\n",
           inet_ntoa(addr.sin_addr), port);
  if(verbose) {
   printf("connection refused\n");
  }
  log_write(err_msg);
 }
 else if(response == -3) {
  snprintf(err_msg, STRLARGE, "Connection timed out to %s:%d\n",
           inet_ntoa(addr.sin_addr), port);
  if(verbose) {
   printf("connection timed out\n");
  }
  log_write(err_msg);
 }

 close(sockfd);

 ftime(&end_time);
 if(response >= 0) {
  response = (((int)end_time.time * 1000) + (int)end_time.millitm) -
   (((int)start_time.time * 1000) + (int)start_time.millitm);
  if(verbose) {
   printf("response time %dms\n", response);
  }
 }
 return (response);
}
