/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.accessories;

import com.charliemouse.cambozola.Accessory;
import com.charliemouse.cambozola.shared.AppID;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;

public class InfoAccessory
extends Accessory {
    protected InfoFrame m_infoFrame = null;
    protected Point m_frameLoc = new Point(20, 20);

    public String getName() {
        return "Information";
    }

    public String getDescription() {
        return "Display information on the stream";
    }

    public String getIconLocation() {
        return "info.gif";
    }

    public void actionPerformed(Point point) {
        if (this.m_infoFrame == null) {
            this.m_infoFrame = new InfoFrame();
        } else {
            this.m_infoFrame.close();
        }
    }

    class InfoFrame
    extends Frame
    implements ActionListener,
    Runnable {
        TextField fpsValue;

        public InfoFrame() {
            AppID appID = AppID.getAppID();
            this.setTitle(appID.getAppName());
            this.setLayout(new BorderLayout());
            Panel panel = new Panel();
            panel.setLayout(new GridLayout(3, 1));
            panel.add(new Label(appID.getAppName() + " " + appID.getFullVersion(), 1));
            panel.add(new Label(appID.getCopyright(), 1));
            panel.add(new Label(appID.getLocURL(), 1));
            this.add((Component)panel, "North");
            Panel panel2 = new Panel();
            panel2.setLayout(new GridLayout(2, 1));
            Panel panel3 = new Panel();
            panel3.setLayout(new FlowLayout());
            panel3.add(new Label("URL:"));
            TextField textField = new TextField("" + InfoAccessory.this.getViewerAttributes().getStream().getStreamURL(), 30);
            textField.setEditable(false);
            panel3.add(textField);
            panel2.add(panel3);
            Panel panel4 = new Panel();
            panel4.add(new Label("FPS:"));
            panel4.setLayout(new FlowLayout());
            this.fpsValue = new TextField(30);
            this.fpsValue.setEditable(false);
            this.updateFPS();
            panel4.add(this.fpsValue);
            panel2.add(panel4);
            this.add((Component)panel2, "Center");
            Button button = new Button("Close");
            button.addActionListener(this);
            Panel panel5 = new Panel();
            panel5.setLayout(new FlowLayout());
            panel5.add(button);
            this.add((Component)panel5, "South");
            this.pack();
            this.validate();
            if (InfoAccessory.this.m_frameLoc != null) {
                ((Component)this).setLocation(InfoAccessory.this.m_frameLoc);
            }
            ((Component)this).setVisible(true);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ InfoFrame this$1;
                {
                    this.this$1 = infoFrame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.close();
                }
            });
            new Thread(this).start();
        }

        public void run() {
            do {
                this.updateFPS();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.isVisible());
        }

        private void updateFPS() {
            String string = null;
            string = InfoAccessory.this.getViewerAttributes().getStream() == null ? "No image stream yet." : NumberFormat.getInstance().format(InfoAccessory.this.getViewerAttributes().getStream().getFPS());
            this.fpsValue.setText(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.close();
        }

        public void close() {
            InfoAccessory.this.m_frameLoc = this.getLocation();
            ((Component)this).setVisible(false);
            InfoAccessory.this.m_infoFrame = null;
            this.dispose();
        }
    }
}

