/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.languagetool.rules.ConfusionString;

public class ScoredConfusionSet {
    private List<ConfusionString> confusionWords;
    private final float score;

    public ScoredConfusionSet(float score, List<ConfusionString> words2) {
        if (score <= 0.0f) {
            throw new IllegalArgumentException("factor must be > 0: " + score);
        }
        this.score = score;
        this.confusionWords = words2;
    }

    public float getScore() {
        return this.score;
    }

    public List<String> getConfusionTokens() {
        return this.confusionWords.stream().map(ConfusionString::getString).collect(Collectors.toList());
    }

    public List<Optional<String>> getTokenDescriptions() {
        return this.confusionWords.stream().map(ConfusionString::getDescription).map(Optional::ofNullable).collect(Collectors.toList());
    }

    public String toString() {
        return this.confusionWords.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScoredConfusionSet other = (ScoredConfusionSet)o;
        return Objects.equals(this.confusionWords, other.confusionWords) && Objects.equals(Float.valueOf(this.score), Float.valueOf(other.score));
    }

    public int hashCode() {
        return Objects.hash(this.confusionWords, Float.valueOf(this.score));
    }
}

