/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.languagetool.rules.ConfusionString;
import org.languagetool.tools.StringTools;

public class ConfusionPair {
    private final ConfusionString term1;
    private final ConfusionString term2;
    private final long factor;
    private final boolean bidirectional;

    public ConfusionPair(ConfusionString cs1, ConfusionString cs2, long factor, boolean bidirectional) {
        this.term1 = Objects.requireNonNull(cs1);
        this.term2 = Objects.requireNonNull(cs2);
        if (factor < 1L) {
            throw new IllegalArgumentException("factor must be >= 1: " + factor);
        }
        this.factor = factor;
        this.bidirectional = bidirectional;
    }

    public ConfusionPair(String token1, String token2, Long factor, boolean bidirectional) {
        this.term1 = new ConfusionString(token1, null);
        this.term2 = new ConfusionString(token2, null);
        if (factor < 1L) {
            throw new IllegalArgumentException("factor must be >= 1: " + factor);
        }
        this.factor = factor;
        this.bidirectional = bidirectional;
    }

    public long getFactor() {
        return this.factor;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public ConfusionString getTerm1() {
        return this.term1;
    }

    public ConfusionString getTerm2() {
        return this.term2;
    }

    public List<ConfusionString> getTerms() {
        return Collections.unmodifiableList(Arrays.asList(this.term1, this.term2));
    }

    public List<ConfusionString> getUppercaseFirstCharTerms() {
        ArrayList<ConfusionString> result2 = new ArrayList<ConfusionString>();
        result2.add(new ConfusionString(StringTools.uppercaseFirstChar(this.term1.getString()), this.term1.getDescription()));
        result2.add(new ConfusionString(StringTools.uppercaseFirstChar(this.term2.getString()), this.term2.getDescription()));
        return Collections.unmodifiableList(result2);
    }

    public String toString() {
        return this.term1 + (this.bidirectional ? "; " : " -> ") + this.term2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfusionPair that = (ConfusionPair)o;
        return this.factor == that.factor && this.bidirectional == that.bidirectional && this.term1.equals(that.term1) && this.term2.equals(that.term2);
    }

    public int hashCode() {
        return Objects.hash(this.term1, this.term2, this.factor, this.bidirectional);
    }
}

