/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.text.lookup.AbstractStringLookup;
import org.apache.commons.text.lookup.IllegalArgumentExceptions;

final class UrlDecoderStringLookup
extends AbstractStringLookup {
    static final UrlDecoderStringLookup INSTANCE = new UrlDecoderStringLookup();

    private UrlDecoderStringLookup() {
    }

    String decode(String key2, String enc) throws UnsupportedEncodingException {
        return URLDecoder.decode(key2, enc);
    }

    @Override
    public String lookup(String key2) {
        if (key2 == null) {
            return null;
        }
        String enc = StandardCharsets.UTF_8.name();
        try {
            return this.decode(key2, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw IllegalArgumentExceptions.format(e, "%s: source=%s, encoding=%s", e, key2, enc);
        }
    }
}

