/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Key;
import com.intellij.platform.execution.serviceView.ServiceViewActionProvider;
import com.intellij.platform.execution.serviceView.ServiceViewState;
import com.intellij.platform.execution.serviceView.ServiceViewUi;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ServiceViewSingleUi
implements ServiceViewUi {
    private final SimpleToolWindowPanel myMainPanel = new SimpleToolWindowPanel(ServiceViewSingleUi.isHorizontal());
    private final JPanel myMessagePanel = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"service.view.empty.tab.text", (Object[])new Object[0]));

    ServiceViewSingleUi() {
        ComponentUtil.putClientProperty((JComponent)this.myMainPanel, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> JBIterable.of((Object)this.myMessagePanel).filter(component -> this.myMainPanel != component.getParent()).iterator());
        this.myMessagePanel.setFocusable(true);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        SimpleToolWindowPanel simpleToolWindowPanel = this.myMainPanel;
        if (simpleToolWindowPanel == null) {
            ServiceViewSingleUi.$$$reportNull$$$0(0);
        }
        return simpleToolWindowPanel;
    }

    @Override
    public void saveState(@NotNull ServiceViewState state) {
        if (state == null) {
            ServiceViewSingleUi.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void setServiceToolbar(@NotNull ServiceViewActionProvider actionManager) {
        if (actionManager == null) {
            ServiceViewSingleUi.$$$reportNull$$$0(2);
        }
        boolean horizontal = ServiceViewSingleUi.isHorizontal();
        ActionToolbar toolbar = actionManager.createServiceToolbar((JComponent)this.myMainPanel, horizontal);
        this.myMainPanel.setToolbar(actionManager.wrapServiceToolbar(toolbar.getComponent(), horizontal));
    }

    @Override
    public void setMasterComponent(@NotNull JComponent component, @NotNull ServiceViewActionProvider actionManager) {
        if (component == null) {
            ServiceViewSingleUi.$$$reportNull$$$0(3);
        }
        if (actionManager == null) {
            ServiceViewSingleUi.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void setDetailsComponent(@Nullable JComponent component) {
        if (component == null) {
            component = this.myMessagePanel;
        }
        if (component.getParent() == this.myMainPanel) {
            return;
        }
        this.myMainPanel.setContent(component);
        if (ServiceViewUIUtils.isNewServicesUIEnabled()) {
            this.myMainPanel.getToolbar().setVisible(ServiceViewActionProvider.isActionToolBarRequired(component));
        }
    }

    @Override
    public void setDetailsComponentVisible(boolean visible) {
    }

    @Override
    public void setNavBar(@NotNull JComponent component) {
        if (component == null) {
            ServiceViewSingleUi.$$$reportNull$$$0(5);
        }
    }

    @Override
    @Nullable
    public JComponent updateNavBar(boolean isSideComponent) {
        return null;
    }

    @Override
    public void setMasterComponentVisible(boolean visible) {
    }

    @Override
    @Nullable
    public JComponent getDetailsComponent() {
        JComponent content = this.myMainPanel.getContent();
        return content == this.myMessagePanel ? null : content;
    }

    @Override
    public void setSplitOrientation(boolean verticalSplit) {
    }

    private static boolean isHorizontal() {
        return ServiceViewUIUtils.isNewServicesUIEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceViewSingleUi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewSingleUi";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setServiceToolbar";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setMasterComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setNavBar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

