/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.qt.common;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.qt.common.QtBundle;
import com.intellij.qt.common.QtPathProvider;
import com.intellij.qt.common.settings.QtSettings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class QtFileType
extends LanguageFileType
implements INativeFileType {
    private final String myName;
    @Nls
    private final String myDisplayName;
    private final @NlsContexts.Label String myDescription;
    private final String myDefaultExtension;

    QtFileType(@NonNls String name, @NotNull @Nls String displayName, @NlsContexts.Label String description, String defaultExtension) {
        if (displayName == null) {
            QtFileType.$$$reportNull$$$0(0);
        }
        super((Language)XMLLanguage.INSTANCE, true);
        this.myName = name;
        this.myDisplayName = displayName;
        this.myDescription = description;
        this.myDefaultExtension = defaultExtension;
    }

    @NotNull
    @NonNls
    public String getName() {
        String string = this.myName;
        if (string == null) {
            QtFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NlsContexts.Label
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            QtFileType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            QtFileType.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        String string = this.myDefaultExtension;
        if (string == null) {
            QtFileType.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static void openInEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            QtFileType.$$$reportNull$$$0(5);
        }
        if (file == null) {
            QtFileType.$$$reportNull$$$0(6);
        }
        new OpenFileDescriptor(project, file).navigateInEditor(project, true);
    }

    public boolean openFileInAssociatedApplication(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            QtFileType.$$$reportNull$$$0(7);
        }
        if (file == null) {
            QtFileType.$$$reportNull$$$0(8);
        }
        String toolName = this.getToolName();
        Path toolPath = null;
        QtSettings qtSettings = QtSettings.getInstance(project);
        @NotNull @NlsSafe String binPath = qtSettings.getResultingQtBinDir();
        if (!binPath.isEmpty()) {
            Path fullPath = Path.of(binPath, toolName);
            if (fullPath.toFile().exists()) {
                toolPath = fullPath;
            } else if (SystemInfo.isWindows && (fullPath = Path.of(binPath, toolName + ".exe")).toFile().exists()) {
                toolPath = fullPath;
            }
        }
        if (toolPath == null) {
            DumbService dumbService = DumbService.getInstance((Project)project);
            List qtPathProviders = dumbService.filterByDumbAwareness((Collection)QtPathProvider.EP_NAME.getExtensionsIfPointIsRegistered());
            for (QtPathProvider qtPathProvider : qtPathProviders) {
                toolPath = qtPathProvider.findQtTool(project, file, toolName);
            }
        }
        if (toolPath == null) {
            QtFileType.openInEditor(project, file);
            return true;
        }
        try {
            Runtime.getRuntime().exec(new String[]{toolPath.toString(), file.getPath()});
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)QtBundle.message("qt.error.failed.run.qt.designer", e.getMessage()), (String)QtBundle.message("qt.run.designer.error", new Object[0]));
            QtFileType.openInEditor(project, file);
        }
        return true;
    }

    protected abstract String getToolName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/qt/common/QtFileType";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/qt/common/QtFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openInEditor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openFileInAssociatedApplication";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

