/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitObjectType;
import git4idea.commands.GitRebaseCommandResult;
import git4idea.commands.GitShallowCloneOptions;
import git4idea.push.GitPushParams;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface Git {
    @NotNull
    public static Git getInstance() {
        Git git = (Git)ApplicationManager.getApplication().getService(Git.class);
        if (git == null) {
            Git.$$$reportNull$$$0(0);
        }
        return git;
    }

    @NotNull
    public GitCommandResult runCommand(@NotNull Computable<? extends GitLineHandler> var1);

    @NotNull
    public GitCommandResult runCommand(@NotNull GitLineHandler var1);

    @NotNull
    public GitCommandResult runCommandWithoutCollectingOutput(@NotNull GitLineHandler var1);

    @NotNull
    public GitCommandResult init(@NotNull Project var1, @NotNull VirtualFile var2, GitLineHandlerListener ... var3);

    public Set<FilePath> ignoredFilePaths(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable Collection<? extends FilePath> var3) throws VcsException;

    public Set<FilePath> ignoredFilePathsNoChunk(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable List<String> var3) throws VcsException;

    @Deprecated
    @NotNull
    public @Unmodifiable Set<VirtualFile> untrackedFiles(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable Collection<? extends VirtualFile> var3) throws VcsException;

    public Set<FilePath> untrackedFilePaths(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable Collection<FilePath> var3) throws VcsException;

    @NotNull
    public Collection<FilePath> untrackedFilePathsNoChunk(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable List<String> var3) throws VcsException;

    @NotNull
    default public GitCommandResult clone(@Nullable Project project, @NotNull File parentDirectory, @NotNull String url, @NotNull String clonedDirectoryName, GitLineHandlerListener ... progressListeners) {
        if (parentDirectory == null) {
            Git.$$$reportNull$$$0(1);
        }
        if (url == null) {
            Git.$$$reportNull$$$0(2);
        }
        if (clonedDirectoryName == null) {
            Git.$$$reportNull$$$0(3);
        }
        if (progressListeners == null) {
            Git.$$$reportNull$$$0(4);
        }
        GitCommandResult gitCommandResult = this.clone(project, parentDirectory, url, clonedDirectoryName, (GitShallowCloneOptions)null, progressListeners);
        if (gitCommandResult == null) {
            Git.$$$reportNull$$$0(5);
        }
        return gitCommandResult;
    }

    @NotNull
    public GitCommandResult clone(@Nullable Project var1, @NotNull File var2, @NotNull String var3, @NotNull String var4, @Nullable GitShallowCloneOptions var5, GitLineHandlerListener ... var6);

    @NotNull
    public GitCommandResult config(@NotNull GitRepository var1, String ... var2);

    @NotNull
    public GitCommandResult diff(@NotNull GitRepository var1, @NotNull List<String> var2, @NotNull String var3);

    @NotNull
    public GitCommandResult merge(@NotNull GitRepository var1, @NotNull String var2, @Nullable List<String> var3, GitLineHandlerListener ... var4);

    @NotNull
    public GitCommandResult checkout(@NotNull GitRepository var1, @NotNull String var2, @Nullable String var3, boolean var4, boolean var5, GitLineHandlerListener ... var6);

    @NotNull
    public GitCommandResult checkout(@NotNull GitRepository var1, @NotNull String var2, @Nullable String var3, boolean var4, boolean var5, boolean var6, GitLineHandlerListener ... var7);

    @NotNull
    public GitCommandResult checkoutNewBranch(@NotNull GitRepository var1, @NotNull String var2, @Nullable GitLineHandlerListener var3);

    @NotNull
    public GitCommandResult createNewTag(@NotNull GitRepository var1, @NotNull String var2, @Nullable GitLineHandlerListener var3, @NotNull String var4);

    @NotNull
    public GitCommandResult deleteTag(@NotNull GitRepository var1, @NotNull String var2, GitLineHandlerListener ... var3);

    @NotNull
    public GitCommandResult branchDelete(@NotNull GitRepository var1, @NotNull String var2, boolean var3, GitLineHandlerListener ... var4);

    @NotNull
    public GitCommandResult branchCreate(@NotNull GitRepository var1, @NotNull String var2, @NotNull String var3);

    @NotNull
    public GitCommandResult setUpstream(@NotNull GitRepository var1, @NotNull String var2, @NotNull String var3);

    @NotNull
    public GitCommandResult branchCreate(@NotNull GitRepository var1, @NotNull String var2, @NotNull String var3, boolean var4);

    @NotNull
    public GitCommandResult renameBranch(@NotNull GitRepository var1, @NotNull String var2, @NotNull String var3, GitLineHandlerListener ... var4);

    @NotNull
    public GitCommandResult reset(@NotNull GitRepository var1, @NotNull GitResetMode var2, @NotNull String var3, GitLineHandlerListener ... var4);

    @NotNull
    public GitCommandResult resetMerge(@NotNull GitRepository var1, @Nullable String var2);

    @NotNull
    public GitCommandResult tip(@NotNull GitRepository var1, @NotNull String var2);

    @NotNull
    public GitCommandResult push(@NotNull GitRepository var1, @NotNull String var2, @Nullable String var3, @NotNull String var4, boolean var5, GitLineHandlerListener ... var6);

    @NotNull
    public GitCommandResult push(@NotNull GitRepository var1, @NotNull GitPushParams var2, GitLineHandlerListener ... var3);

    @NotNull
    public GitCommandResult show(@NotNull GitRepository var1, String ... var2);

    @NotNull
    public GitCommandResult cherryPick(@NotNull GitRepository var1, @NotNull String var2, boolean var3, boolean var4, GitLineHandlerListener ... var5);

    @NotNull
    public GitCommandResult getUnmergedFiles(@NotNull GitRepository var1);

    @NotNull
    public GitCommandResult checkAttr(@NotNull GitRepository var1, @NotNull Collection<String> var2, @NotNull Collection<? extends VirtualFile> var3);

    @NotNull
    public GitCommandResult stashSave(@NotNull GitRepository var1, @NotNull String var2);

    @NotNull
    public GitCommandResult stashPop(@NotNull GitRepository var1, GitLineHandlerListener ... var2);

    @NotNull
    public GitCommandResult fetch(@NotNull GitRepository var1, @NotNull GitRemote var2, @NotNull List<? extends GitLineHandlerListener> var3, String ... var4);

    @NotNull
    public GitCommandResult addRemote(@NotNull GitRepository var1, @NotNull String var2, @NotNull String var3);

    @NotNull
    public GitCommandResult removeRemote(@NotNull GitRepository var1, @NotNull GitRemote var2);

    @NotNull
    public GitCommandResult renameRemote(@NotNull GitRepository var1, @NotNull String var2, @NotNull String var3);

    @NotNull
    public GitCommandResult setRemoteUrl(@NotNull GitRepository var1, @NotNull String var2, @NotNull String var3);

    @NotNull
    public GitCommandResult lsRemote(@NotNull Project var1, @NotNull File var2, @NotNull String var3);

    @NotNull
    public GitCommandResult lsRemote(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull GitRemote var3, String ... var4);

    @NotNull
    public GitCommandResult lsRemoteRefs(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull GitRemote var3, @NotNull List<String> var4, String ... var5);

    @NotNull
    public GitCommandResult remotePrune(@NotNull GitRepository var1, @NotNull GitRemote var2);

    @NotNull
    public GitRebaseCommandResult rebase(@NotNull GitRepository var1, @NotNull GitRebaseParams var2, GitLineHandlerListener ... var3);

    @NotNull
    public GitRebaseCommandResult rebaseAbort(@NotNull GitRepository var1, GitLineHandlerListener ... var2);

    @NotNull
    public GitRebaseCommandResult rebaseContinue(@NotNull GitRepository var1, GitLineHandlerListener ... var2);

    @NotNull
    public GitRebaseCommandResult rebaseSkip(@NotNull GitRepository var1, GitLineHandlerListener ... var2);

    @NotNull
    public GitCommandResult revert(@NotNull GitRepository var1, @NotNull String var2, boolean var3, GitLineHandlerListener ... var4);

    @Nullable
    public Hash resolveReference(@NotNull GitRepository var1, @NotNull String var2);

    @NotNull
    public GitCommandResult getObjectType(@NotNull GitRepository var1, @NotNull String var2);

    @Nullable
    public GitObjectType getObjectTypeEnum(@NotNull GitRepository var1, @NotNull String var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/Git";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clonedDirectoryName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/Git";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

