/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.jmxDriver;

import com.intellij.driver.impl.Invoker;
import com.intellij.driver.impl.InvokerMBean;
import com.intellij.driver.model.RdTarget;
import com.intellij.driver.model.transport.Ref;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.util.PlatformUtils;
import com.jetbrains.performancePlugin.jmxDriver.RemoteDevInvoker;
import io.opentelemetry.context.Context;
import java.awt.Component;
import java.lang.management.ManagementFactory;
import java.util.function.Supplier;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J@\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00170\u00162\u0010\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00190\u00162\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/performancePlugin/jmxDriver/InvokerService;", "", "<init>", "()V", "myInvoker", "Lcom/intellij/driver/impl/InvokerMBean;", "rdTarget", "Lcom/intellij/driver/model/RdTarget;", "getRdTarget", "()Lcom/intellij/driver/model/RdTarget;", "invoker", "getInvoker", "()Lcom/intellij/driver/impl/InvokerMBean;", "isReady", "", "putReference", "Lcom/intellij/driver/model/transport/Ref;", "c", "Ljava/awt/Component;", "register", "", "tracerSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/platform/diagnostic/telemetry/IJTracer;", "timedContextSupplier", "Lio/opentelemetry/context/Context;", "screenshotAction", "Lkotlin/Function1;", "", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nInvokerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvokerService.kt\ncom/jetbrains/performancePlugin/jmxDriver/InvokerService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class InvokerService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private InvokerMBean myInvoker;
    @NotNull
    private final RdTarget rdTarget = PlatformUtils.isJetBrainsClient() ? RdTarget.FRONTEND : (AppMode.isRemoteDevHost() ? RdTarget.BACKEND : RdTarget.DEFAULT);
    @NotNull
    private static final String BACKEND_JMX_PORT_PROPERTY = "rdct.tests.backendJmxPort";
    @NotNull
    private static final String BACKEND_JMX_HOST_PROPERTY = "rdct.tests.backendJmxHost";
    private static final String jmxBackendPort = System.getProperty("rdct.tests.backendJmxPort");
    private static final String jmxBackendHost = System.getProperty("rdct.tests.backendJmxHost", "127.0.0.1");
    @NotNull
    private static final Logger log;

    @NotNull
    public final RdTarget getRdTarget() {
        return this.rdTarget;
    }

    @NotNull
    public final InvokerMBean getInvoker() {
        InvokerMBean invokerMBean = this.myInvoker;
        if (invokerMBean == null) {
            throw new IllegalStateException("Invoker is not registered");
        }
        return invokerMBean;
    }

    public final boolean isReady() {
        return this.myInvoker != null;
    }

    @NotNull
    public final Ref putReference(@NotNull Component c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Ref ref = this.getInvoker().putAdhocReference(c);
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"putAdhocReference(...)");
        return ref;
    }

    public final void register(@NotNull Supplier<? extends IJTracer> tracerSupplier, @NotNull Supplier<? extends Context> timedContextSupplier, @NotNull Function1<? super String, String> screenshotAction) throws JMException {
        String remoteJmxAddress;
        Intrinsics.checkNotNullParameter(tracerSupplier, (String)"tracerSupplier");
        Intrinsics.checkNotNullParameter(timedContextSupplier, (String)"timedContextSupplier");
        Intrinsics.checkNotNullParameter(screenshotAction, (String)"screenshotAction");
        ObjectName objectName = new ObjectName("com.intellij.driver:type=Invoker");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Invoker localInvoker = new Invoker(this.rdTarget, tracerSupplier, timedContextSupplier, arg_0 -> InvokerService.register$lambda$0(screenshotAction, arg_0));
        String string = jmxBackendPort;
        if (string != null) {
            String it = string;
            boolean bl = false;
            v1 = jmxBackendHost + ":" + it;
        } else {
            v1 = remoteJmxAddress = null;
        }
        if (PlatformUtils.isJetBrainsClient() && remoteJmxAddress != null) {
            log.info("Remote Dev Mode, " + remoteJmxAddress);
            this.myInvoker = new RemoteDevInvoker(localInvoker, remoteJmxAddress);
        } else {
            this.myInvoker = localInvoker;
        }
        server.registerMBean(this.getInvoker(), objectName);
    }

    private static final String register$lambda$0(Function1 $tmp0, String p0) {
        return (String)$tmp0.invoke((Object)p0);
    }

    @JvmStatic
    @NotNull
    public static final InvokerService getInstance() {
        return Companion.getInstance();
    }

    static {
        Logger logger = Logger.getInstance(InvokerService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\f\u001a\n \n*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/performancePlugin/jmxDriver/InvokerService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/performancePlugin/jmxDriver/InvokerService;", "BACKEND_JMX_PORT_PROPERTY", "", "BACKEND_JMX_HOST_PROPERTY", "jmxBackendPort", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "jmxBackendHost", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final InvokerService getInstance() {
            Object object = ApplicationManager.getApplication().getService(InvokerService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (InvokerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

