/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.collaboration.ui.SimpleEventListener;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import git4idea.remote.hosting.GitHostingUrlUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ObservableProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.util.GithubGitHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u001c\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J/\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00170\u0016H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0007J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020\u001dH\u0003J\u001e\u0010$\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u0007\u0018\u00010%2\u0006\u0010#\u001a\u00020\u001dH\u0003J\u0010\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020\u001dH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SERVICE_DISPLAY_NAME", "", "ENTERPRISE_SERVICE_DISPLAY_NAME", "GIT_AUTH_PASSWORD_SUBSTITUTE", "addCancellationListener", "Ljava/util/concurrent/ScheduledFuture;", "run", "Lkotlin/Function0;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "thread", "Ljava/lang/Thread;", "runInterruptable", "T", "task", "Lcom/intellij/openapi/util/ThrowableComputable;", "Ljava/io/IOException;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "getErrorTextFromException", "e", "", "getGitRepository", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findGithubRemoteUrl", "repository", "findGithubRemote", "Lcom/intellij/openapi/util/Pair;", "Lgit4idea/repo/GitRemote;", "isRepositoryOnGitHub", "", "Delegates", "intellij.vcs.github"})
public final class GithubUtil {
    @NotNull
    public static final GithubUtil INSTANCE = new GithubUtil();
    @JvmField
    @NotNull
    public static final Logger LOG;
    @NlsSafe
    @NotNull
    public static final String SERVICE_DISPLAY_NAME = "GitHub";
    @NlsSafe
    @NotNull
    public static final String ENTERPRISE_SERVICE_DISPLAY_NAME = "GitHub Enterprise";
    @NotNull
    public static final String GIT_AUTH_PASSWORD_SUBSTITUTE = "x-oauth-basic";

    private GithubUtil() {
    }

    @JvmStatic
    @NotNull
    public static final ScheduledFuture<?> addCancellationListener(@NotNull Function0<Unit> run2) {
        Intrinsics.checkNotNullParameter(run2, (String)"run");
        ScheduledFuture<?> scheduledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> GithubUtil.addCancellationListener$lambda$0(run2), 1000L, 300L, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleWithFixedDelay(...)");
        return scheduledFuture;
    }

    private final ScheduledFuture<?> addCancellationListener(ProgressIndicator indicator, Thread thread) {
        return GithubUtil.addCancellationListener((Function0<Unit>)((Function0)() -> GithubUtil.addCancellationListener$lambda$1(indicator, thread)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final <T> T runInterruptable(@NotNull ProgressIndicator indicator, @NotNull ThrowableComputable<T, IOException> task) throws IOException {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        ScheduledFuture<?> future = null;
        try {
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNull((Object)thread);
            future = INSTANCE.addCancellationListener(indicator, thread);
            Object object = task.compute();
            return (T)object;
        }
        finally {
            ScheduledFuture<?> scheduledFuture = future;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
            Thread.interrupted();
        }
    }

    @JvmStatic
    @NlsSafe
    @NotNull
    public static final String getErrorTextFromException(@NotNull Throwable e) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof UnknownHostException) {
            object = "Unknown host: " + e.getMessage();
        } else {
            String string = StringUtil.notNullize((String)e.getMessage(), (String)"Unknown error");
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"notNullize(...)");
        }
        return object;
    }

    @JvmStatic
    @Deprecated(message="{@link GithubGitHelper}", replaceWith=@ReplaceWith(expression="GithubGitHelper.findGitRepository(project, file)", imports={"org.jetbrains.plugins.github.util.GithubGitHelper"}))
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public static final GitRepository getGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GithubGitHelper.Companion.findGitRepository(project, file);
    }

    @JvmStatic
    @Deprecated(message="{@link GithubGitHelper}")
    private static final String findGithubRemoteUrl(GitRepository repository) {
        Pair<GitRemote, String> pair = GithubUtil.findGithubRemote(repository);
        if (pair == null) {
            return null;
        }
        Pair<GitRemote, String> remote = pair;
        return (String)remote.getSecond();
    }

    @JvmStatic
    @Deprecated(message="{@link org.jetbrains.plugins.github.api.GithubServerPath}, {@link GithubGitHelper}")
    private static final Pair<GitRemote, String> findGithubRemote(GitRepository repository) {
        GithubAuthenticationManager githubAuthenticationManager = GithubAuthenticationManager.Companion.getInstance();
        Project project = repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = githubAuthenticationManager.getSingleOrDefaultAccount(project);
        if (object == null || (object = object.getServer()) == null) {
            return null;
        }
        GithubAccount server = object;
        Pair githubRemote = null;
        block0: for (GitRemote gitRemote : repository.getRemotes()) {
            for (String remoteUrl : gitRemote.getUrls()) {
                String remoteName;
                URI uRI = ((GithubServerPath)((Object)server)).toURI();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                Intrinsics.checkNotNull((Object)remoteUrl);
                if (!GitHostingUrlUtil.match((URI)uRI, (String)remoteUrl)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)gitRemote.getName(), (String)"getName(...)");
                if (Intrinsics.areEqual((Object)"github", (Object)remoteName) || Intrinsics.areEqual((Object)"origin", (Object)remoteName)) {
                    return Pair.create((Object)gitRemote, (Object)remoteUrl);
                }
                if (githubRemote != null) continue block0;
                githubRemote = Pair.create((Object)gitRemote, (Object)remoteUrl);
                continue block0;
            }
        }
        return githubRemote;
    }

    @JvmStatic
    @Deprecated(message="{@link org.jetbrains.plugins.github.api.GithubServerPath}")
    @ApiStatus.ScheduledForRemoval
    public static final boolean isRepositoryOnGitHub(@NotNull GitRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        return GithubUtil.findGithubRemoteUrl(repository) != null;
    }

    private static final void addCancellationListener$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Unit addCancellationListener$lambda$1(ProgressIndicator $indicator, Thread $thread) {
        if ($indicator.isCanceled()) {
            $thread.interrupt();
        }
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance((String)"github");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUtil$Delegates;", "", "<init>", "()V", "observableField", "Lkotlin/properties/ObservableProperty;", "T", "initialValue", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/collaboration/ui/SimpleEventListener;", "(Ljava/lang/Object;Lcom/intellij/util/EventDispatcher;)Lkotlin/properties/ObservableProperty;", "intellij.vcs.github"})
    public static final class Delegates {
        @NotNull
        public static final Delegates INSTANCE = new Delegates();

        private Delegates() {
        }

        @NotNull
        public final <T> ObservableProperty<T> observableField(T initialValue, @NotNull EventDispatcher<SimpleEventListener> dispatcher) {
            Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
            return new ObservableProperty<T>(initialValue, dispatcher){
                final /* synthetic */ EventDispatcher<SimpleEventListener> $dispatcher;
                {
                    this.$dispatcher = $dispatcher;
                    super($initialValue);
                }

                protected void afterChange(KProperty<?> property, T oldValue, T newValue) {
                    Intrinsics.checkNotNullParameter(property, (String)"property");
                    ((SimpleEventListener)this.$dispatcher.getMulticaster()).eventOccurred();
                }
            };
        }
    }
}

