/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.RootDomParentStrategy;
import com.intellij.util.xml.stubs.ElementStub;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomRootInvocationHandler
extends DomInvocationHandler {
    private static final Logger LOG = Logger.getInstance(DomRootInvocationHandler.class);
    private final DomFileElementImpl<?> myParent;

    public DomRootInvocationHandler(Class aClass, RootDomParentStrategy strategy, @NotNull DomFileElementImpl<?> fileElement, @NotNull EvaluatedXmlName tagName, @Nullable ElementStub stub) {
        if (fileElement == null) {
            DomRootInvocationHandler.$$$reportNull$$$0(0);
        }
        if (tagName == null) {
            DomRootInvocationHandler.$$$reportNull$$$0(1);
        }
        super(aClass, strategy, tagName, new AbstractDomChildDescriptionImpl(aClass){

            @NotNull
            public List<? extends DomElement> getValues(@NotNull DomElement parent) {
                if (parent == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public int compareTo(AbstractDomChildDescriptionImpl o) {
                throw new UnsupportedOperationException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/xml/impl/DomRootInvocationHandler$1", "getValues"));
            }
        }, fileElement.getManager(), true, stub);
        this.myParent = fileElement;
    }

    @Override
    public void undefineInternal() {
        try {
            XmlTag tag = this.getXmlTag();
            if (tag != null) {
                this.deleteTag(tag);
                this.detach();
                this.fireUndefinedEvent();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DomRootInvocationHandler)) {
            return false;
        }
        DomRootInvocationHandler handler2 = (DomRootInvocationHandler)((Object)obj);
        return this.myParent.equals(handler2.myParent);
    }

    @Override
    public int hashCode() {
        return this.myParent.hashCode();
    }

    @Override
    public boolean exists() {
        return this.getStub() != null || this.getXmlElement() != null;
    }

    @Override
    @NotNull
    public String getXmlElementNamespace() {
        String string = this.getXmlName().getNamespace((XmlElement)this.getFile(), this.getFile());
        if (string == null) {
            DomRootInvocationHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected String checkValidity() {
        XmlTag tag = (XmlTag)this.getXmlElement();
        if (tag != null && !tag.isValid()) {
            return "invalid root tag";
        }
        String s = this.myParent.checkValidity();
        if (s != null) {
            return "root: " + s;
        }
        return null;
    }

    @NotNull
    public DomFileElementImpl<?> getParent() {
        DomFileElementImpl<?> domFileElementImpl = this.myParent;
        if (domFileElementImpl == null) {
            DomRootInvocationHandler.$$$reportNull$$$0(3);
        }
        return domFileElementImpl;
    }

    @Override
    public DomElement createPathStableCopy() {
        DomFileElement stableCopy = (DomFileElement)this.myParent.createStableCopy();
        return this.getManager().createStableValue(() -> stableCopy.isValid() ? stableCopy.getRootElement() : null);
    }

    @Override
    protected XmlTag setEmptyXmlTag() {
        XmlTag[] result2 = new XmlTag[]{null};
        this.getManager().runChange(() -> {
            try {
                String namespace = this.getXmlElementNamespace();
                @NonNls Object nsDecl = StringUtil.isEmpty((String)namespace) ? "" : " xmlns=\"" + namespace + "\"";
                XmlFile xmlFile = this.getFile();
                XmlTag tag = XmlElementFactory.getInstance((Project)xmlFile.getProject()).createTagFromText((CharSequence)("<" + this.getXmlElementName() + (String)nsDecl + "/>"));
                result2[0] = ((XmlDocument)xmlFile.getDocument().replace((PsiElement)((XmlFile)tag.getContainingFile()).getDocument())).getRootTag();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
        return result2[0];
    }

    @Override
    @NotNull
    public final DomNameStrategy getNameStrategy() {
        Class<?> rawType = this.getRawType();
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(rawType, this.isAttribute());
        if (strategy != null) {
            DomNameStrategy domNameStrategy = strategy;
            if (domNameStrategy == null) {
                DomRootInvocationHandler.$$$reportNull$$$0(4);
            }
            return domNameStrategy;
        }
        DomNameStrategy domNameStrategy = DomNameStrategy.HYPHEN_STRATEGY;
        if (domNameStrategy == null) {
            DomRootInvocationHandler.$$$reportNull$$$0(5);
        }
        return domNameStrategy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DomRootInvocationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DomRootInvocationHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlElementNamespace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

