/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.coverage;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.coverage.CoverageEngine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.InstrumentationOptions;
import com.intellij.rt.coverage.util.CoverageReport;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.coverage.CoverageLanguage;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageInspectionBaseKt;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageStatisticsKt;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.UtilsKt;
import org.jetbrains.qodana.staticAnalysis.inspections.coverageData.CoverageStatisticsData;
import org.jetbrains.qodana.staticAnalysis.inspections.coverageData.CoverageStatisticsDataKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.stat.CoverageFeatureEventsCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J \u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H&J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H&J \u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J0\u0010+\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J \u0010,\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u0013\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0004\u00a2\u0006\u0002\u00102J\r\u00103\u001a\u000704\u00a2\u0006\u0002\b5H\u0004J.\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u001f\u001a\u00020 2\u0006\u00108\u001a\u00020\u001d2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020;0:H\u0004J \u0010<\u001a\u00020\u00172\u0006\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020;2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0018\u0010?\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J \u0010@\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020C0BJ\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020HH\u0004R \u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR \u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0011\u0010\u0003\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006J"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageInspectionBase;", "Lcom/intellij/codeInspection/GlobalSimpleInspectionTool;", "<init>", "()V", "methodThreshold", "", "getMethodThreshold$annotations", "getMethodThreshold", "()I", "setMethodThreshold", "(I)V", "classThreshold", "getClassThreshold$annotations", "getClassThreshold", "setClassThreshold", "warnMissingCoverage", "", "getWarnMissingCoverage$annotations", "getWarnMissingCoverage", "()Z", "setWarnMissingCoverage", "(Z)V", "loadCoverage", "", "globalContext", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "loadReportForIncrementalAnalysis", "loadReportData", "data", "Lcom/intellij/rt/coverage/data/ProjectData;", "checker", "file", "Lcom/intellij/psi/PsiFile;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "validateFileType", "cleanup", "inspectionStarted", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "Lcom/intellij/codeInspection/GlobalInspectionContext;", "problemDescriptionsProcessor", "Lcom/intellij/codeInspection/ProblemDescriptionsProcessor;", "checkFile", "inspectionFinished", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "defaultThresholdOpts", "", "Lcom/intellij/codeInspection/options/OptRegularComponent;", "()[Lcom/intellij/codeInspection/options/OptRegularComponent;", "missingCoverageOpt", "Lcom/intellij/codeInspection/options/OptCheckbox;", "Lorg/jetbrains/annotations/NotNull;", "getClassData", "Lcom/intellij/rt/coverage/data/ClassData;", "report", "pathsMap", "", "", "saveCoverageData", "context", "engine", "processReportData", "computeCoverageData", "engineType", "Lkotlin/reflect/KClass;", "Lcom/intellij/coverage/CoverageEngine;", "provideCoverageFiles", "", "Ljava/io/File;", "highlightedElement", "Lcom/intellij/psi/PsiElement;", "element", "intellij.qodana.coverage"})
@SourceDebugExtension(value={"SMAP\nCoverageInspectionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageInspectionBase.kt\norg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageInspectionBase\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n216#2:159\n217#2:162\n216#2,2:163\n13402#3,2:160\n1#4:165\n*S KotlinDebug\n*F\n+ 1 CoverageInspectionBase.kt\norg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageInspectionBase\n*L\n114#1:159\n114#1:162\n126#1:163,2\n115#1:160,2\n*E\n"})
public abstract class CoverageInspectionBase
extends GlobalSimpleInspectionTool {
    private int methodThreshold = 50;
    private int classThreshold = 50;
    private boolean warnMissingCoverage;

    public final int getMethodThreshold() {
        return this.methodThreshold;
    }

    public final void setMethodThreshold(int n) {
        this.methodThreshold = n;
    }

    public static /* synthetic */ void getMethodThreshold$annotations() {
    }

    public final int getClassThreshold() {
        return this.classThreshold;
    }

    public final void setClassThreshold(int n) {
        this.classThreshold = n;
    }

    public static /* synthetic */ void getClassThreshold$annotations() {
    }

    public final boolean getWarnMissingCoverage() {
        return this.warnMissingCoverage;
    }

    public final void setWarnMissingCoverage(boolean bl) {
        this.warnMissingCoverage = bl;
    }

    public static /* synthetic */ void getWarnMissingCoverage$annotations() {
    }

    public abstract void loadCoverage(@NotNull QodanaGlobalInspectionContext var1);

    public void loadReportForIncrementalAnalysis(@NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
    }

    protected final void loadReportData(@NotNull QodanaGlobalInspectionContext globalContext, @NotNull ProjectData data) {
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (UtilsKt.isLocalChanges(globalContext)) {
            this.processReportData(data, globalContext);
        }
    }

    public abstract void checker(@NotNull PsiFile var1, @NotNull ProblemsHolder var2, @NotNull QodanaGlobalInspectionContext var3);

    public abstract boolean validateFileType(@NotNull PsiFile var1);

    public abstract void cleanup(@NotNull QodanaGlobalInspectionContext var1);

    public void inspectionStarted(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        Intrinsics.checkNotNullParameter((Object)problemDescriptionsProcessor, (String)"problemDescriptionsProcessor");
        if (!(globalContext instanceof QodanaGlobalInspectionContext) || UtilsKt.isUnderLocalChangesOnOldCode((QodanaGlobalInspectionContext)globalContext)) {
            return;
        }
        this.loadCoverage((QodanaGlobalInspectionContext)globalContext);
        this.loadReportForIncrementalAnalysis((QodanaGlobalInspectionContext)globalContext);
    }

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        Intrinsics.checkNotNullParameter((Object)problemDescriptionsProcessor, (String)"problemDescriptionsProcessor");
        if (!(globalContext instanceof QodanaGlobalInspectionContext) || UtilsKt.isUnderLocalChangesOnOldCode((QodanaGlobalInspectionContext)globalContext) || !this.validateFileType(file) || TestSourcesFilter.isTestSources((VirtualFile)file.getVirtualFile(), (Project)((QodanaGlobalInspectionContext)globalContext).getProject())) {
            return;
        }
        this.checker(file, problemsHolder, (QodanaGlobalInspectionContext)globalContext);
    }

    public void inspectionFinished(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        Intrinsics.checkNotNullParameter((Object)problemDescriptionsProcessor, (String)"problemDescriptionsProcessor");
        if (!(globalContext instanceof QodanaGlobalInspectionContext)) {
            return;
        }
        this.cleanup((QodanaGlobalInspectionContext)globalContext);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = (OptRegularComponent[])ArraysKt.plus((Object[])this.defaultThresholdOpts(), (Object)this.missingCoverageOpt());
        OptPane optPane = OptPane.pane((OptRegularComponent[])Arrays.copyOf(optRegularComponentArray, optRegularComponentArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    protected final OptRegularComponent[] defaultThresholdOpts() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.number((String)"classThreshold", (String)QodanaBundle.message("class.coverage.threshold.value", new Object[0]), (int)1, (int)100), OptPane.number((String)"methodThreshold", (String)QodanaBundle.message("method.coverage.threshold.value", new Object[0]), (int)1, (int)100)};
        return optRegularComponentArray;
    }

    @NotNull
    protected final OptCheckbox missingCoverageOpt() {
        OptCheckbox optCheckbox = OptPane.checkbox((String)"warnMissingCoverage", (String)QodanaBundle.message("missing.coverage.tracking.message", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]);
        Intrinsics.checkNotNullExpressionValue((Object)optCheckbox, (String)"checkbox(...)");
        return optCheckbox;
    }

    @Nullable
    protected final ClassData getClassData(@NotNull PsiFile file, @NotNull ProjectData report2, @NotNull Map<String, String> pathsMap) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        Intrinsics.checkNotNullParameter(pathsMap, (String)"pathsMap");
        String string = file.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String normalizedPath = UtilsKt.normalizeFilePath(string);
        String path = pathsMap.getOrDefault(normalizedPath, normalizedPath);
        return report2.getClassData(path);
    }

    protected final void saveCoverageData(@NotNull QodanaGlobalInspectionContext context, @NotNull String engine, @NotNull ProjectData data) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Path fileData = context.getConfig().getCoverage().getCoveragePath().resolve(engine);
        Path fileSourceMap = context.getConfig().getCoverage().getCoveragePath().resolve(engine + ".sourceMap");
        Files.createDirectories(fileData.getParent(), new FileAttribute[0]);
        Map map2 = data.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getClasses(...)");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object[] $this$forEach$iv2;
            Map.Entry element$iv;
            Map.Entry c = element$iv = iterator2.next();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((ClassData)c.getValue()).getLines(), (String)"getLines(...)");
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                LineData ld;
                Object element$iv2;
                Object l = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                LineData lineData = ld = l instanceof LineData ? (LineData)l : null;
                if (ld == null || ld.getMethodSignature() != null) continue;
                ld.setMethodSignature("()V");
            }
        }
        InstrumentationOptions options = new InstrumentationOptions.Builder().setDataFile(fileData.toFile()).setSourceMapFile(fileSourceMap.toFile()).build();
        CoverageReport.save((ProjectData)data, (InstrumentationOptions)options);
    }

    protected void processReportData(@NotNull ProjectData data, @NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        CoverageStatisticsData stat = globalContext.getCoverageStatisticsData();
        Map map2 = data.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getClasses(...)");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry x = element$iv = iterator2.next();
            boolean bl = false;
            Object v = x.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            CoverageStatisticsKt.processReportClassData(stat, (ClassData)v);
        }
    }

    @Nullable
    public final ProjectData computeCoverageData(@NotNull QodanaGlobalInspectionContext globalContext, @NotNull KClass<? extends CoverageEngine> engineType) {
        CoverageEngine engine;
        ProjectData data;
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        Intrinsics.checkNotNullParameter(engineType, (String)"engineType");
        List<File> coverageFiles = this.provideCoverageFiles(globalContext);
        CoverageInspectionBaseKt.getLogger().info("Coverage for " + JvmClassMappingKt.getJavaClass(engineType).getSimpleName() + " - provided " + coverageFiles.size() + " files");
        if (!coverageFiles.isEmpty() && (data = UtilsKt.retrieveCoverageData(engine = (CoverageEngine)CoverageEngine.EP_NAME.findExtensionOrFail(JvmClassMappingKt.getJavaClass(engineType)), coverageFiles, globalContext)) != null) {
            Project project = globalContext.getProject();
            String string = JvmClassMappingKt.getJavaClass(engineType).getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            CoverageFeatureEventsCollector.INSPECTION_LOADED_COVERAGE.log(project, (Object)CoverageLanguage.Companion.mapEngine(string));
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final List<File> provideCoverageFiles(@NotNull QodanaGlobalInspectionContext globalContext) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        QodanaGlobalInspectionContext qodanaGlobalInspectionContext = globalContext;
        synchronized (qodanaGlobalInspectionContext) {
            boolean bl = false;
            List list3 = (List)globalContext.getUserData(CoverageStatisticsDataKt.getPrecomputedCoverageFiles());
            if (list3 == null) {
                Object[] objectArray = new Path[2];
                objectArray[0] = UtilsKt.reportsInExternalPath();
                Project project = globalContext.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                objectArray[1] = UtilsKt.reportsInProjectPath(project);
                List coverageFiles = SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), CoverageInspectionBase::provideCoverageFiles$lambda$7$lambda$6));
                globalContext.putUserData(CoverageStatisticsDataKt.getPrecomputedCoverageFiles(), coverageFiles);
                List list4 = coverageFiles;
                return list4;
            }
            List it = list3;
            boolean bl2 = false;
            List list5 = it;
            list2 = list5;
        }
        return list2;
    }

    @NotNull
    protected final PsiElement highlightedElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiNameIdentifierOwner psiNameIdentifierOwner = element instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)element : null;
        if (psiNameIdentifierOwner == null || (psiNameIdentifierOwner = psiNameIdentifierOwner.getNameIdentifier()) == null) {
            psiNameIdentifierOwner = element;
        }
        return psiNameIdentifierOwner;
    }

    private static final boolean provideCoverageFiles$lambda$7$lambda$6$lambda$4(Path f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(f, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final File provideCoverageFiles$lambda$7$lambda$6$lambda$5(Path f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        return f.toFile();
    }

    private static final Sequence provideCoverageFiles$lambda$7$lambda$6(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)PathsKt.walk((Path)it, (PathWalkOption[])new PathWalkOption[0]), CoverageInspectionBase::provideCoverageFiles$lambda$7$lambda$6$lambda$4), CoverageInspectionBase::provideCoverageFiles$lambda$7$lambda$6$lambda$5);
    }
}

