/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.cloud.QodanaCloudStateService;
import org.jetbrains.qodana.cloud.UserState;
import org.jetbrains.qodana.cloud.project.LinkState;
import org.jetbrains.qodana.cloud.project.QodanaCloudProjectLinkService;
import org.jetbrains.qodana.registry.QodanaRegistry;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollector;
import org.jetbrains.qodana.stats.SourceLinkState;
import org.jetbrains.qodana.ui.link.LinkCloudProjectDialog;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0003J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/qodana/actions/LinkCloudProjectAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionText", "", "linkState", "Lorg/jetbrains/qodana/cloud/project/LinkState;", "actionPerformed", "logUnlinkStats", "project", "Lcom/intellij/openapi/project/Project;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nLinkCloudProjectAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkCloudProjectAction.kt\norg/jetbrains/qodana/actions/LinkCloudProjectAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,59:1\n31#2,2:60\n*S KotlinDebug\n*F\n+ 1 LinkCloudProjectAction.kt\norg/jetbrains/qodana/actions/LinkCloudProjectAction\n*L\n24#1:60,2\n*E\n"})
public final class LinkCloudProjectAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * Unable to fully structure code
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        var3_2 = QodanaCloudStateService.Companion.getInstance().getUserState().getValue();
        authorized = var3_2 instanceof UserState.Authorized != false ? (UserState.Authorized)var3_2 : null;
        v0 = e.getProject();
        if (v0 == null) ** GOTO lbl-1000
        $this$service$iv = (ComponentManager)v0;
        $i$f$service = false;
        serviceClass$iv = QodanaCloudProjectLinkService.class;
        v1 = $this$service$iv.getService(serviceClass$iv);
        if (v1 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        v0 = (QodanaCloudProjectLinkService)v1;
        if (v0 != null && (v0 = v0.getLinkState()) != null) {
            v2 = (LinkState)v0.getValue();
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        linkState = v2;
        isVisible = authorized != null && linkState != null && QodanaRegistry.INSTANCE.isQodanaCloudIntegrationEnabled() != false;
        e.getPresentation().setVisible(isVisible);
        if (!isVisible) {
            return;
        }
        v3 = e.getPresentation();
        v4 = linkState;
        Intrinsics.checkNotNull((Object)v4);
        v3.setText(this.getActionText(v4));
    }

    @NlsActions.ActionText
    private final String getActionText(LinkState linkState) {
        String string;
        LinkState linkState2 = linkState;
        if (linkState2 instanceof LinkState.Linked) {
            String string2 = QodanaBundle.message("qodana.unlink.project.action", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else if (linkState2 instanceof LinkState.NotLinked) {
            String string3 = QodanaBundle.message("qodana.link.project.action", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        LinkState linkState = (LinkState)QodanaCloudProjectLinkService.Companion.getInstance(project2).getLinkState().getValue();
        if (linkState instanceof LinkState.Linked) {
            ((LinkState.Linked)linkState).unlink();
            this.logUnlinkStats(project2);
        } else if (linkState instanceof LinkState.NotLinked) {
            new LinkCloudProjectDialog(project2).show();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void logUnlinkStats(Project project) {
        QodanaPluginStatsCounterCollector.UPDATE_CLOUD_LINK.log(project, (Object)false, (Object)SourceLinkState.TOOLS_LIST);
    }
}

