/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.definition.internal;

import com.vladsch.flexmark.ext.definition.DefinitionItem;
import com.vladsch.flexmark.ext.definition.DefinitionList;
import com.vladsch.flexmark.ext.definition.internal.DefinitionListItemBlockPreProcessor;
import com.vladsch.flexmark.ext.definition.internal.DefinitionOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.BlockPreProcessor;
import com.vladsch.flexmark.parser.block.BlockPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefinitionListBlockPreProcessor
implements BlockPreProcessor {
    private final DefinitionOptions options;

    public DefinitionListBlockPreProcessor(DataHolder options) {
        this.options = new DefinitionOptions(options);
    }

    @Override
    public void preProcess(ParserState state, Block block) {
        Boolean blankLinesInAST = Parser.BLANK_LINES_IN_AST.get(state.getProperties());
        if (block instanceof DefinitionList) {
            DefinitionList definitionList = (DefinitionList)block;
            boolean isTight = definitionList.isTight();
            if (this.options.autoLoose && isTight) {
                for (Node child : definitionList.getChildren()) {
                    if (!(child instanceof DefinitionItem)) continue;
                    if (((DefinitionItem)child).isLoose()) {
                        isTight = false;
                        if (!blankLinesInAST.booleanValue()) break;
                    }
                    if (!blankLinesInAST.booleanValue()) continue;
                    child.moveTrailingBlankLines();
                }
                definitionList.setTight(isTight);
            }
            if (blankLinesInAST.booleanValue()) {
                definitionList.moveTrailingBlankLines();
            }
        }
    }

    public static class Factory
    implements BlockPreProcessorFactory {
        @Override
        @NotNull
        public Set<Class<? extends Block>> getBlockTypes() {
            HashSet<Class<? extends Block>> set = new HashSet<Class<? extends Block>>();
            set.add(DefinitionList.class);
            return set;
        }

        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            HashSet set = new HashSet();
            set.add(DefinitionListItemBlockPreProcessor.Factory.class);
            return set;
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return true;
        }

        @Override
        @NotNull
        public BlockPreProcessor apply(@NotNull ParserState state) {
            return new DefinitionListBlockPreProcessor(state.getProperties());
        }
    }
}

