/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.Token;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.parser.property.Conversions;
import com.openhtmltopdf.css.parser.property.PrimitivePropertyBuilders;
import com.openhtmltopdf.css.parser.property.PropertyBuilder;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class FontPropertyBuilder
extends AbstractPropertyBuilder {
    private static final CSSName[] ALL = new CSSName[]{CSSName.FONT_STYLE, CSSName.FONT_VARIANT, CSSName.FONT_WEIGHT, CSSName.FONT_SIZE, CSSName.LINE_HEIGHT, CSSName.FONT_FAMILY};

    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
        PropertyValue value2;
        List<PropertyDeclaration> result2 = this.checkInheritAll(ALL, values, origin, important, inheritAllowed);
        if (result2 != null) {
            return result2;
        }
        PropertyDeclaration fontStyle = null;
        PropertyDeclaration fontVariant = null;
        PropertyDeclaration fontWeight = null;
        PropertyDeclaration fontSize = null;
        PropertyDeclaration lineHeight = null;
        PropertyDeclaration fontFamily = null;
        boolean keepGoing = false;
        ListIterator<PropertyValue> i = values.listIterator();
        while (i.hasNext()) {
            value2 = i.next();
            short type2 = value2.getPrimitiveType();
            if (type2 == 21) {
                String lowerCase = value2.getStringValue().toLowerCase();
                IdentValue ident = this.checkIdent(cssName, value2 = new PropertyValue(21, lowerCase, lowerCase));
                if (ident == IdentValue.NORMAL) continue;
                if (PrimitivePropertyBuilders.FONT_STYLES.get(ident.FS_ID)) {
                    if (fontStyle != null) {
                        throw new CSSParseException("font-style cannot be set twice", -1);
                    }
                    fontStyle = new PropertyDeclaration(CSSName.FONT_STYLE, value2, important, origin);
                    continue;
                }
                if (PrimitivePropertyBuilders.FONT_VARIANTS.get(ident.FS_ID)) {
                    if (fontVariant != null) {
                        throw new CSSParseException("font-variant cannot be set twice", -1);
                    }
                    fontVariant = new PropertyDeclaration(CSSName.FONT_VARIANT, value2, important, origin);
                    continue;
                }
                if (PrimitivePropertyBuilders.FONT_WEIGHTS.get(ident.FS_ID)) {
                    if (fontWeight != null) {
                        throw new CSSParseException("font-weight cannot be set twice", -1);
                    }
                    fontWeight = new PropertyDeclaration(CSSName.FONT_WEIGHT, value2, important, origin);
                    continue;
                }
                keepGoing = true;
                break;
            }
            if (type2 == 1 && value2.getFloatValue() > 0.0f) {
                if (fontWeight != null) {
                    throw new CSSParseException("font-weight cannot be set twice", -1);
                }
                IdentValue weight = Conversions.getNumericFontWeight(value2.getFloatValue());
                if (weight == null) {
                    throw new CSSParseException(value2 + " is not a valid font weight", -1);
                }
                PropertyValue replacement = new PropertyValue(21, weight.toString(), weight.toString());
                replacement.setIdentValue(weight);
                fontWeight = new PropertyDeclaration(CSSName.FONT_WEIGHT, replacement, important, origin);
                continue;
            }
            keepGoing = true;
            break;
        }
        if (keepGoing) {
            i.previous();
            value2 = i.next();
            if (value2.getPrimitiveType() == 21) {
                String lowerCase = value2.getStringValue().toLowerCase();
                value2 = new PropertyValue(21, lowerCase, lowerCase);
            }
            PropertyBuilder fontSizeBuilder = CSSName.getPropertyBuilder(CSSName.FONT_SIZE);
            List<PropertyDeclaration> l = fontSizeBuilder.buildDeclarations(CSSName.FONT_SIZE, Collections.singletonList(value2), origin, important);
            fontSize = l.get(0);
            if (i.hasNext()) {
                value2 = i.next();
                if (value2.getOperator() == Token.TK_VIRGULE) {
                    PropertyBuilder lineHeightBuilder = CSSName.getPropertyBuilder(CSSName.LINE_HEIGHT);
                    l = lineHeightBuilder.buildDeclarations(CSSName.LINE_HEIGHT, Collections.singletonList(value2), origin, important);
                    lineHeight = l.get(0);
                } else {
                    i.previous();
                }
            }
            if (i.hasNext()) {
                ArrayList<PropertyValue> families = new ArrayList<PropertyValue>();
                while (i.hasNext()) {
                    families.add(i.next());
                }
                PropertyBuilder fontFamilyBuilder = CSSName.getPropertyBuilder(CSSName.FONT_FAMILY);
                l = fontFamilyBuilder.buildDeclarations(CSSName.FONT_FAMILY, families, origin, important);
                fontFamily = l.get(0);
            }
        }
        if (fontStyle == null) {
            fontStyle = new PropertyDeclaration(CSSName.FONT_STYLE, new PropertyValue(IdentValue.NORMAL), important, origin);
        }
        if (fontVariant == null) {
            fontVariant = new PropertyDeclaration(CSSName.FONT_VARIANT, new PropertyValue(IdentValue.NORMAL), important, origin);
        }
        if (fontWeight == null) {
            fontWeight = new PropertyDeclaration(CSSName.FONT_WEIGHT, new PropertyValue(IdentValue.NORMAL), important, origin);
        }
        if (fontSize == null) {
            throw new CSSParseException("A font-size value is required", -1);
        }
        if (lineHeight == null) {
            lineHeight = new PropertyDeclaration(CSSName.LINE_HEIGHT, new PropertyValue(IdentValue.NORMAL), important, origin);
        }
        result2 = new ArrayList<PropertyDeclaration>(ALL.length);
        result2.add(fontStyle);
        result2.add(fontVariant);
        result2.add(fontWeight);
        result2.add(fontSize);
        result2.add(lineHeight);
        if (fontFamily != null) {
            result2.add(fontFamily);
        }
        return result2;
    }
}

