/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core.matcher;

import java.util.regex.Pattern;
import javax.swing.JButton;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.core.matcher.NamedComponentMatcherTemplate;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public final class JButtonMatcher
extends NamedComponentMatcherTemplate<JButton> {
    private Object text;

    @Nonnull
    public static JButtonMatcher withName(@Nullable String name) {
        return new JButtonMatcher(name, JButtonMatcher.anyValue());
    }

    @Nonnull
    public static JButtonMatcher withText(@Nullable String text) {
        return new JButtonMatcher(JButtonMatcher.anyValue(), (Object)text);
    }

    @Nonnull
    public static JButtonMatcher withText(@Nonnull Pattern pattern) {
        return new JButtonMatcher(JButtonMatcher.anyValue(), (Object)pattern);
    }

    public static JButtonMatcher any() {
        return new JButtonMatcher(JButtonMatcher.anyValue(), JButtonMatcher.anyValue());
    }

    private JButtonMatcher(@Nullable Object name, @Nullable Object text) {
        super(JButton.class, name);
        this.text = text;
    }

    @Nonnull
    public JButtonMatcher andText(@Nullable String newText) {
        this.text = newText;
        return this;
    }

    public JButtonMatcher andText(@Nonnull Pattern textPattern) {
        this.text = textPattern;
        return this;
    }

    @Nonnull
    public JButtonMatcher andShowing() {
        this.requireShowing(true);
        return this;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(@Nonnull JButton button2) {
        return this.isNameMatching(button2.getName()) && this.arePropertyValuesMatching(this.text, button2.getText());
    }

    public String toString() {
        String format = "%s[name=%s, text=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), this.quotedName(), this.quoted(this.text), this.requireShowing());
    }
}

