/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.tunnels;

import com.intellij.ssh.SshTunnelAlreadyRegisteredException;
import com.intellij.ssh.SshTunnelCreationException;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.tunnels.ConnectListenerForRemoteTunnels;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import net.schmizz.sshj.connection.channel.forwarded.RemotePortForwarder;
import net.schmizz.sshj.transport.Transport;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0012J\u001e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0016\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0012J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ssh/impl/sshj/tunnels/RemoteForwarderCollection;", "", "sshClient", "Lnet/schmizz/sshj/SSHClient;", "ownerName", "", "<init>", "(Lnet/schmizz/sshj/SSHClient;Ljava/lang/String;)V", "forwardByRemoteAddress", "Ljava/util/HashMap;", "Lnet/schmizz/sshj/connection/channel/forwarded/RemotePortForwarder$Forward;", "Ljava/net/InetSocketAddress;", "forwardLock", "Ljava/util/concurrent/locks/ReentrantLock;", "create", "", "localHost", "localPort", "", "remoteHost", "remotePort", "createWithRandomRemotePort", "wrapIntoTunnelCreationException", "Lcom/intellij/ssh/SshTunnelCreationException;", "Ljava/io/IOException;", "logLabel", "remove", "get", "", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nRemoteForwarderCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteForwarderCollection.kt\ncom/intellij/ssh/impl/sshj/tunnels/RemoteForwarderCollection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class RemoteForwarderCollection {
    @NotNull
    private final SSHClient sshClient;
    @NotNull
    private final String ownerName;
    @NotNull
    private final HashMap<RemotePortForwarder.Forward, InetSocketAddress> forwardByRemoteAddress;
    @NotNull
    private final ReentrantLock forwardLock;

    public RemoteForwarderCollection(@NotNull SSHClient sshClient, @NotNull String ownerName) {
        Intrinsics.checkNotNullParameter((Object)sshClient, (String)"sshClient");
        Intrinsics.checkNotNullParameter((Object)ownerName, (String)"ownerName");
        this.sshClient = sshClient;
        this.ownerName = ownerName;
        this.forwardByRemoteAddress = new HashMap();
        this.forwardLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(@NotNull String localHost, int localPort, @NotNull String remoteHost, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        Lock lock = this.forwardLock;
        lock.lock();
        try {
            boolean bl = false;
            RemotePortForwarder.Forward forward = new RemotePortForwarder.Forward(remoteHost, remotePort);
            String logLabel = "remote tunnel for " + this.ownerName + ": " + localHost + ":" + localPort + " <== " + remoteHost + ":" + remotePort;
            UtilKt.getSSHJ_LOG().debug("Creating " + logLabel);
            if (((Map)this.forwardByRemoteAddress).containsKey(forward)) {
                throw new SshTunnelAlreadyRegisteredException("Already registered: " + logLabel);
            }
            InetSocketAddress localAddress = new InetSocketAddress(localHost, localPort);
            try {
                RemotePortForwarder remotePortForwarder = this.sshClient.getRemotePortForwarder();
                Transport transport = this.sshClient.getTransport();
                Intrinsics.checkNotNullExpressionValue((Object)transport, (String)"getTransport(...)");
                remotePortForwarder.bind(forward, (ConnectListener)new ConnectListenerForRemoteTunnels(transport, localAddress, forward));
            }
            catch (IOException e) {
                throw this.wrapIntoTunnelCreationException(e, logLabel);
            }
            ((Map)this.forwardByRemoteAddress).put(forward, localAddress);
            UtilKt.getSSHJ_LOG().debug("Created " + logLabel);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int createWithRandomRemotePort(@NotNull String localHost, int localPort, @NotNull String remoteHost) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        Lock lock = this.forwardLock;
        lock.lock();
        try {
            RemotePortForwarder.Forward forward;
            boolean bl = false;
            InetSocketAddress localAddress = new InetSocketAddress(localHost, localPort);
            String logLabel = "remote tunnel for " + this.ownerName + ": " + localHost + ":" + localPort + " <== " + remoteHost + ":<any free port>";
            UtilKt.getSSHJ_LOG().debug("Creating " + logLabel);
            Transport transport = this.sshClient.getTransport();
            Intrinsics.checkNotNullExpressionValue((Object)transport, (String)"getTransport(...)");
            ConnectListenerForRemoteTunnels connectListener = new ConnectListenerForRemoteTunnels(transport, localAddress, new RemotePortForwarder.Forward(remoteHost, Integer.MIN_VALUE));
            try {
                forward = this.sshClient.getRemotePortForwarder().bind(new RemotePortForwarder.Forward(remoteHost, 0), (ConnectListener)connectListener);
            }
            catch (IOException e) {
                throw this.wrapIntoTunnelCreationException(e, logLabel);
            }
            RemotePortForwarder.Forward forward2 = forward;
            connectListener.setForward(forward2);
            ((Map)this.forwardByRemoteAddress).put(forward2, localAddress);
            UtilKt.getSSHJ_LOG().debug("Created " + logLabel + ", chosen port is " + forward2.getPort());
            int n = forward2.getPort();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    private final SshTunnelCreationException wrapIntoTunnelCreationException(IOException $this$wrapIntoTunnelCreationException, String logLabel) {
        String message = "While creating " + logLabel + ": " + $this$wrapIntoTunnelCreationException.getMessage();
        UtilKt.getSSHJ_LOG().warn(message, (Throwable)$this$wrapIntoTunnelCreationException);
        return new SshTunnelCreationException(message, $this$wrapIntoTunnelCreationException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull String remoteHost, int remotePort) {
        InetSocketAddress inetSocketAddress;
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        RemotePortForwarder.Forward remoteAddr = new RemotePortForwarder.Forward(remoteHost, remotePort);
        Lock lock = this.forwardLock;
        lock.lock();
        try {
            boolean bl = false;
            inetSocketAddress = this.forwardByRemoteAddress.remove(remoteAddr);
        }
        finally {
            lock.unlock();
        }
        InetSocketAddress localAddr = inetSocketAddress;
        if (localAddr != null) {
            this.sshClient.getRemotePortForwarder().cancel(remoteAddr);
            UtilKt.getSSHJ_LOG().debug("Removed remote tunnel for " + this.ownerName + ": " + localAddr.getAddress().getHostAddress() + ":" + localAddr.getPort() + " <== " + remoteHost + ":" + remotePort);
        } else {
            UtilKt.getSSHJ_LOG().debug("Tried to remove non-existing remote tunnel for " + this.ownerName + ": <host>:<port> <== " + remoteHost + ":" + remotePort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> get() {
        Lock lock = this.forwardLock;
        lock.lock();
        try {
            boolean bl = false;
            List list = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)MapsKt.asSequence((Map)this.forwardByRemoteAddress), RemoteForwarderCollection::get$lambda$4$lambda$3));
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final String get$lambda$4$lambda$3(Map.Entry it) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                var2_1 = ((InetSocketAddress)it.getValue()).getHostString();
                if (var2_1 == null) break block7;
                switch (var2_1.hashCode()) {
                    case 0: {
                        if (!var2_1.equals("")) {
                            break;
                        }
                        ** GOTO lbl15
                    }
                    case -1204607085: {
                        if (!var2_1.equals("localhost")) {
                            break;
                        }
                        ** GOTO lbl15
                    }
                    case 1505998205: {
                        if (!var2_1.equals("127.0.0.1")) break;
lbl15:
                        // 3 sources

                        v0 = "";
                        break block8;
                    }
                }
            }
            v0 = ((InetSocketAddress)it.getValue()).getHostString() + ":";
        }
        fromHost = v0;
        return fromHost + ((InetSocketAddress)it.getValue()).getPort() + ":" + ((RemotePortForwarder.Forward)it.getKey()).getAddress() + ":" + ((RemotePortForwarder.Forward)it.getKey()).getPort();
    }
}

