/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.PyCollectImportsTask;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirementsAnalysisResult;
import com.jetbrains.python.packaging.PyRequirementsFileVisitor;
import com.jetbrains.python.packaging.PyRequirementsVersionSpecifierType;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.sdk.PySdkPopupFactory;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a6\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u001a \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001bH\u0002\u00a8\u0006\u001c"}, d2={"syncWithImports", "", "module", "Lcom/intellij/openapi/module/Module;", "showNotification", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "type", "Lcom/intellij/notification/NotificationType;", "text", "", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lcom/intellij/notification/NotificationAction;", "prepareRequirementsText", "Lcom/jetbrains/python/packaging/PyRequirementsAnalysisResult;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "settings", "Lcom/jetbrains/python/packaging/PyPackageRequirementsSettings;", "showSyncSettingsDialog", "", "addImports", "file", "Lcom/jetbrains/python/psi/PyFile;", "imported", "", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyRequirementsTxtUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyRequirementsTxtUtil.kt\ncom/jetbrains/python/packaging/PyRequirementsTxtUtilKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1317#2,2:229\n216#3,2:231\n1#4:233\n*S KotlinDebug\n*F\n+ 1 PyRequirementsTxtUtil.kt\ncom/jetbrains/python/packaging/PyRequirementsTxtUtilKt\n*L\n226#1:229,2\n128#1:231,2\n*E\n"})
public final class PyRequirementsTxtUtilKt {
    public static final void syncWithImports(@NotNull Module module) {
        String text;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Sync Python requirements");
        Sdk sdk2 = PythonSdkUtil.findPythonSdk(module);
        if (sdk2 == null) {
            NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)PySdkBundle.message("python.configure.interpreter.action", new Object[0]), () -> PyRequirementsTxtUtilKt.syncWithImports$lambda$0(module));
            Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
            NotificationAction configureSdkAction = notificationAction;
            Intrinsics.checkNotNull((Object)notificationGroup);
            String string = PyBundle.message("python.requirements.error.no.interpreter", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PyRequirementsTxtUtilKt.showNotification(notificationGroup, NotificationType.ERROR, string, project, configureSdkAction);
            return;
        }
        PyPackageRequirementsSettings pyPackageRequirementsSettings = PyPackageRequirementsSettings.getInstance(module);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)pyPackageRequirementsSettings), (String)"getInstance(...)");
        PyPackageRequirementsSettings settings = pyPackageRequirementsSettings;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            boolean proceed = PyRequirementsTxtUtilKt.showSyncSettingsDialog(project, settings);
            if (!proceed) {
                return;
            }
        }
        Ref.ObjectRef requirementsFile = new Ref.ObjectRef();
        requirementsFile.element = PyPackageUtil.findRequirementsTxt(module);
        PyRequirementsAnalysisResult matchResult = PyRequirementsTxtUtilKt.prepareRequirementsText(module, sdk2, settings);
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        WriteCommandAction.runWriteCommandAction((Project)module.getProject(), (String)PyBundle.message("python.requirements.action.name", new Object[0]), null, () -> PyRequirementsTxtUtilKt.syncWithImports$lambda$2(requirementsFile, settings, module, psiManager2, matchResult), (PsiFile[])new PsiFile[0]);
        Object object = requirementsFile.element;
        Intrinsics.checkNotNull((Object)object);
        PsiFile psiFile = psiManager2.findFile((VirtualFile)object);
        if (psiFile != null) {
            psiFile.navigate(true);
        }
        if (!((Collection)matchResult.getUnhandledLines()).isEmpty()) {
            objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)matchResult.getUnhandledLines(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)};
            String string = PyBundle.message("python.requirements.warning.unhandled.lines", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            text = string;
            Intrinsics.checkNotNull((Object)notificationGroup);
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PyRequirementsTxtUtilKt.showNotification$default(notificationGroup, NotificationType.WARNING, text, project, null, 16, null);
        }
        if (!((Collection)matchResult.getUnchangedInBaseFiles()).isEmpty()) {
            objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)matchResult.getUnchangedInBaseFiles(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)};
            String string = PyBundle.message("python.requirements.info.file.ref.dropped", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            text = string;
            Intrinsics.checkNotNull((Object)notificationGroup);
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PyRequirementsTxtUtilKt.showNotification$default(notificationGroup, NotificationType.INFORMATION, text, project, null, 16, null);
        }
    }

    private static final void showNotification(NotificationGroup notificationGroup, NotificationType type2, @NlsContexts.NotificationContent String text, Project project, NotificationAction action) {
        String string = PyBundle.message("python.requirements.balloon", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Notification notification2 = notificationGroup.createNotification(string, text, type2);
        if (action != null) {
            notification2.addAction((AnAction)action);
        }
        notification2.notify(project);
    }

    static /* synthetic */ void showNotification$default(NotificationGroup notificationGroup, NotificationType notificationType, String string, Project project, NotificationAction notificationAction, int n, Object object) {
        if ((n & 0x10) != 0) {
            notificationAction = null;
        }
        PyRequirementsTxtUtilKt.showNotification(notificationGroup, notificationType, string, project, notificationAction);
    }

    private static final PyRequirementsAnalysisResult prepareRequirementsText(Module module, Sdk sdk2, PyPackageRequirementsSettings settings) {
        PyRequirementsAnalysisResult pyRequirementsAnalysisResult;
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        String string = PyBundle.message("python.requirements.analyzing.imports.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String dialogTitle = string;
        PyCollectImportsTask task2 = new PyCollectImportsTask(module, psiManager2, dialogTitle);
        task2.queue();
        List<PyPackage> list = PyPackageManager.getInstance(sdk2).refreshAndGetPackages(false);
        Intrinsics.checkNotNullExpressionValue(list, (String)"refreshAndGetPackages(...)");
        List<PyPackage> installedPackages = list;
        Object object = task2.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getResult(...)");
        Map importedPackages2 = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), arg_0 -> PyRequirementsTxtUtilKt.prepareRequirementsText$lambda$5(installedPackages, arg_0)), PyRequirementsTxtUtilKt::prepareRequirementsText$lambda$6), (Map)new LinkedHashMap());
        VirtualFile requirementsFile = PyPackageUtil.findRequirementsTxt(module);
        if (requirementsFile == null) {
            pyRequirementsAnalysisResult = PyRequirementsAnalysisResult.Companion.empty();
        } else {
            PyRequirementsFileVisitor visitor2 = new PyRequirementsFileVisitor(importedPackages2, settings);
            PsiFile psiFile = psiManager2.findFile(requirementsFile);
            Intrinsics.checkNotNull((Object)psiFile);
            pyRequirementsAnalysisResult = visitor2.visitRequirementsFile(psiFile);
        }
        PyRequirementsAnalysisResult analysisResult = pyRequirementsAnalysisResult;
        return analysisResult.withImportedPackages(importedPackages2, settings);
    }

    private static final boolean showSyncSettingsDialog(Project project, PyPackageRequirementsSettings settings) {
        Ref ref = Ref.create((Object)false);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, false);
        DialogPanel panel2 = BuilderKt.panel(arg_0 -> PyRequirementsTxtUtilKt.showSyncSettingsDialog$lambda$12(descriptor2, settings, arg_0));
        String string = PyBundle.message("python.requirements.action.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        DialogWrapper dialog2 = ComponentsKt.dialog$default((String)string, (JComponent)((JComponent)panel2), (boolean)true, null, (boolean)false, (Project)project, null, null, null, null, null, (int)2008, null);
        ApplicationManager.getApplication().invokeAndWait(() -> PyRequirementsTxtUtilKt.showSyncSettingsDialog$lambda$13(ref, dialog2));
        Object object = ref.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private static final void addImports(PyFile file, Set<String> imported) {
        List<PyImportElement> list = file.getImportTargets();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getImportTargets(...)");
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), PyRequirementsTxtUtilKt::addImports$lambda$14);
        List<PyFromImportStatement> list2 = file.getFromImports();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getFromImports(...)");
        Sequence $this$forEach$iv = SequencesKt.plus((Sequence)sequence, (Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list2), PyRequirementsTxtUtilKt::addImports$lambda$15));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            imported.add(it);
        }
    }

    private static final void syncWithImports$lambda$0(Module $module) {
        PySdkPopupFactory.Companion.createAndShow($module);
    }

    private static final void syncWithImports$lambda$2(Ref.ObjectRef $requirementsFile, PyPackageRequirementsSettings $settings, Module $module, PsiManager $psiManager, PyRequirementsAnalysisResult $matchResult) {
        if ($requirementsFile.element == null) {
            VirtualFile virtualFile;
            Path path2 = Paths.get($settings.getRequirementsPath(), new String[0]);
            if (path2.getParent() != null) {
                VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(((Object)path2.getParent()).toString());
                virtualFile = virtualFile2;
                Intrinsics.checkNotNull((Object)virtualFile2);
            } else {
                VirtualFile[] virtualFileArray = ProjectUtil.getRootManager((Module)$module).getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
                virtualFile = (VirtualFile)ArraysKt.first((Object[])virtualFileArray);
            }
            VirtualFile location = virtualFile;
            PsiDirectory psiDirectory = $psiManager.findDirectory(location);
            Intrinsics.checkNotNull((Object)psiDirectory);
            PsiDirectory root = psiDirectory;
            PsiFile psiFile = root.findFile(((Object)path2.getFileName()).toString());
            if (psiFile == null) {
                psiFile = root.createFile(((Object)path2.getFileName()).toString());
            }
            $requirementsFile.element = psiFile.getVirtualFile();
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager documentManager = fileDocumentManager;
        Object object = $requirementsFile.element;
        Intrinsics.checkNotNull((Object)object);
        Document document = documentManager.getDocument((VirtualFile)object);
        Intrinsics.checkNotNull((Object)document);
        document.setText((CharSequence)CollectionsKt.joinToString$default((Iterable)$matchResult.getCurrentFileOutput(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        Map<VirtualFile, List<String>> $this$forEach$iv = $matchResult.getBaseFilesOutput();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<VirtualFile, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<VirtualFile, List<String>> element$iv;
            Map.Entry<VirtualFile, List<String>> entry = element$iv = iterator.next();
            boolean bl = false;
            VirtualFile file = entry.getKey();
            List<String> content = entry.getValue();
            Document document2 = documentManager.getDocument(file);
            Intrinsics.checkNotNull((Object)document2);
            document2.setText((CharSequence)CollectionsKt.joinToString$default((Iterable)content, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
    }

    private static final PyPackage prepareRequirementsText$lambda$5$lambda$4(List $installedPackages, String name2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Iterable iterable = $installedPackages;
            for (Object t : iterable) {
                PyPackage it = (PyPackage)((Object)t);
                boolean bl = false;
                if (!StringUtil.equalsIgnoreCase((CharSequence)it.getName(), (CharSequence)name2)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final Sequence prepareRequirementsText$lambda$5(List $installedPackages, String topLevelPackage) {
        Intrinsics.checkNotNullParameter((Object)topLevelPackage, (String)"topLevelPackage");
        String alias = PyPsiPackageUtil.INSTANCE.moduleToPackageName(topLevelPackage, "");
        return SequencesKt.mapNotNull((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(topLevelPackage, alias, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $topLevelPackage;
            final /* synthetic */ String $alias;
            {
                this.$topLevelPackage = $topLevelPackage;
                this.$alias = $alias;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yield((Object)this.$topLevelPackage, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        if (((CharSequence)this.$alias).length() > 0) {
                            this.L$0 = null;
                            this.label = 2;
                            v1 = $this$sequence.yield((Object)this.$alias, (Continuation)this);
                            if (v1 == var3_2) {
                                return var3_2;
                            }
                        }
                        ** GOTO lbl26
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl26:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super String> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), arg_0 -> PyRequirementsTxtUtilKt.prepareRequirementsText$lambda$5$lambda$4($installedPackages, arg_0));
    }

    private static final Pair prepareRequirementsText$lambda$6(PyPackage it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return TuplesKt.to((Object)string3, (Object)((Object)it));
    }

    private static final Unit showSyncSettingsDialog$lambda$12$lambda$7(FileChooserDescriptor $descriptor, PyPackageRequirementsSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)$descriptor, null, null, (int)6, null), (Function0)((Function0)new Function0<String>((Object)$settings){

            public final String invoke() {
                return ((PyPackageRequirementsSettings)((Object)this.receiver)).getRequirementsPath();
            }
        }), (Function1)((Function1)new Function1<String, Unit>((Object)$settings){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((PyPackageRequirementsSettings)((Object)this.receiver)).setRequirementsPath(p0);
            }
        })).align((Align)AlignX.FILL.INSTANCE).focused();
        return Unit.INSTANCE;
    }

    private static final Unit showSyncSettingsDialog$lambda$12$lambda$8(PyPackageRequirementsSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (Collection)ArraysKt.asList((Object[])PyRequirementsVersionSpecifierType.values()), null, (int)2, null), (Function0)((Function0)new Function0<PyRequirementsVersionSpecifierType>((Object)$settings){

            public final PyRequirementsVersionSpecifierType invoke() {
                return ((PyPackageRequirementsSettings)((Object)this.receiver)).getVersionSpecifier();
            }
        }), (Function1)((Function1)new Function1<PyRequirementsVersionSpecifierType, Unit>((Object)$settings){

            public final void invoke(PyRequirementsVersionSpecifierType p0) {
                ((PyPackageRequirementsSettings)((Object)this.receiver)).setVersionSpecifier(p0);
            }
        })).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit showSyncSettingsDialog$lambda$12$lambda$9(PyPackageRequirementsSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PyBundle.message("python.requirements.remove.unused", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((PyPackageRequirementsSettings)((Object)this.receiver)).getRemoveUnused();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((PyPackageRequirementsSettings)((Object)this.receiver)).setRemoveUnused(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit showSyncSettingsDialog$lambda$12$lambda$10(PyPackageRequirementsSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PyBundle.message("python.requirements.modify.base.files", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((PyPackageRequirementsSettings)((Object)this.receiver)).getModifyBaseFiles();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((PyPackageRequirementsSettings)((Object)this.receiver)).setModifyBaseFiles(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit showSyncSettingsDialog$lambda$12$lambda$11(PyPackageRequirementsSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PyBundle.message("python.requirements.keep.matching.specifier", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((PyPackageRequirementsSettings)((Object)this.receiver)).getKeepMatchingSpecifier();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((PyPackageRequirementsSettings)((Object)this.receiver)).setKeepMatchingSpecifier(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit showSyncSettingsDialog$lambda$12(FileChooserDescriptor $descriptor, PyPackageRequirementsSettings $settings, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = PyBundle.message("form.integrated.tools.package.requirements.file", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> PyRequirementsTxtUtilKt.showSyncSettingsDialog$lambda$12$lambda$7($descriptor, $settings, arg_0));
        String string2 = PyBundle.message("python.requirements.version.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> PyRequirementsTxtUtilKt.showSyncSettingsDialog$lambda$12$lambda$8($settings, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PyRequirementsTxtUtilKt.showSyncSettingsDialog$lambda$12$lambda$9($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PyRequirementsTxtUtilKt.showSyncSettingsDialog$lambda$12$lambda$10($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PyRequirementsTxtUtilKt.showSyncSettingsDialog$lambda$12$lambda$11($settings, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void showSyncSettingsDialog$lambda$13(Ref $ref, DialogWrapper $dialog) {
        $ref.set((Object)$dialog.showAndGet());
    }

    private static final String addImports$lambda$14(PyImportElement it) {
        QualifiedName qualifiedName = it.getImportedQName();
        return qualifiedName != null ? qualifiedName.getFirstComponent() : null;
    }

    private static final String addImports$lambda$15(PyFromImportStatement it) {
        QualifiedName qualifiedName = it.getImportSourceQName();
        return qualifiedName != null ? qualifiedName.getFirstComponent() : null;
    }

    public static final /* synthetic */ void access$addImports(PyFile file, Set imported) {
        PyRequirementsTxtUtilKt.addImports(file, imported);
    }
}

