/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.codeinsight.completion.providers.EditorConfigCompletionProviderBase;
import org.editorconfig.language.filetype.EditorConfigFileConstants;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/editorconfig/language/codeinsight/completion/providers/EditorConfigRootDeclarationCompletionProvider;", "Lorg/editorconfig/language/codeinsight/completion/providers/EditorConfigCompletionProviderBase;", "<init>", "()V", "destination", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lcom/intellij/psi/PsiElement;", "getDestination", "()Lcom/intellij/patterns/PsiElementPattern$Capture;", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.editorconfig"})
public final class EditorConfigRootDeclarationCompletionProvider
extends EditorConfigCompletionProviderBase {
    @NotNull
    public static final EditorConfigRootDeclarationCompletionProvider INSTANCE = new EditorConfigRootDeclarationCompletionProvider();
    @NotNull
    private static final PsiElementPattern.Capture<PsiElement> destination;

    private EditorConfigRootDeclarationCompletionProvider() {
    }

    @Override
    @NotNull
    public PsiElementPattern.Capture<PsiElement> getDestination() {
        return destination;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiFile psiFile = parameters.getOriginalFile();
        EditorConfigPsiFile editorConfigPsiFile = psiFile instanceof EditorConfigPsiFile ? (EditorConfigPsiFile)psiFile : null;
        if (editorConfigPsiFile == null) {
            return;
        }
        EditorConfigPsiFile file = editorConfigPsiFile;
        if (file.getHasValidRootDeclaration()) {
            return;
        }
        PsiFile psiFile2 = parameters.getPosition().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        String rootDeclaration = EditorConfigFileConstants.INSTANCE.getRootDeclarationFor(psiFile2);
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)rootDeclaration);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"create(...)");
        LookupElementBuilder element = lookupElementBuilder;
        result2.addElement((LookupElement)element);
    }

    static {
        TreeElementPattern treeElementPattern = PlatformPatterns.psiElement().withParent(EditorConfigPsiFile.class);
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"withParent(...)");
        destination = (PsiElementPattern.Capture)treeElementPattern;
    }
}

