/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/editorconfig/configmanagement/ConfigEncodingCharsetUtil;", "", "<init>", "()V", "charsetKey", "", "UTF8_BOM_ENCODING", "UTF8_ENCODING", "encodingMap", "", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "toString", "charset", "useBom", "", "toCharset", "str", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nConfigEncodingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigEncodingManager.kt\norg/editorconfig/configmanagement/ConfigEncodingCharsetUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class ConfigEncodingCharsetUtil {
    @NotNull
    public static final ConfigEncodingCharsetUtil INSTANCE = new ConfigEncodingCharsetUtil();
    @NotNull
    public static final String charsetKey = "charset";
    @NotNull
    public static final String UTF8_BOM_ENCODING = "utf-8-bom";
    @NotNull
    private static final String UTF8_ENCODING = "utf-8";
    @NotNull
    private static final Map<String, Charset> encodingMap;

    private ConfigEncodingCharsetUtil() {
    }

    @Nullable
    public final String toString(@NotNull Charset charset, boolean useBom) {
        String string;
        Intrinsics.checkNotNullParameter((Object)charset, (String)charsetKey);
        if (charset == StandardCharsets.UTF_8) {
            string = useBom ? UTF8_BOM_ENCODING : UTF8_ENCODING;
        } else {
            Object v1;
            block3: {
                Iterable iterable = encodingMap.entrySet();
                for (Object t : iterable) {
                    Map.Entry entry = (Map.Entry)t;
                    boolean bl = false;
                    Charset v = (Charset)entry.getValue();
                    if (!Intrinsics.areEqual((Object)v, (Object)charset)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            Map.Entry entry = v1;
            string = entry != null ? (String)entry.getKey() : null;
        }
        return string;
    }

    @Nullable
    public final Charset toCharset(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return encodingMap.get(str);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"latin1", (Object)StandardCharsets.ISO_8859_1), TuplesKt.to((Object)UTF8_ENCODING, (Object)StandardCharsets.UTF_8), TuplesKt.to((Object)UTF8_BOM_ENCODING, (Object)StandardCharsets.UTF_8), TuplesKt.to((Object)"utf-16be", (Object)StandardCharsets.UTF_16BE), TuplesKt.to((Object)"utf-16le", (Object)StandardCharsets.UTF_16LE)};
        encodingMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

