/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.google.common.primitives.Ints;
import com.intellij.openapi.util.Couple;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.ScrollingTarget;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0002\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tJ*\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00192\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J0\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0002J!\u0010\u001c\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/log/ui/table/SelectionSnapshot;", "", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "<init>", "(Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;)V", "selectedCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "isOnTop", "", "scrollingTarget", "Lcom/intellij/vcs/log/ui/table/ScrollingTarget;", "getTopGap", "", "row", "getVisibleRows", "Lkotlin/ranges/IntRange;", "Ljavax/swing/JTable;", "restore", "", "graph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "scroll", "permanentGraphChanged", "mapCommitsToRows", "", "commits", "", "scrollToRow", "delta", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nSelectionSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionSnapshot.kt\ncom/intellij/vcs/log/ui/table/SelectionSnapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class SelectionSnapshot {
    @NotNull
    private final VcsLogGraphTable table;
    @NotNull
    private final IntSet selectedCommits;
    private final boolean isOnTop;
    @Nullable
    private final ScrollingTarget scrollingTarget;

    public SelectionSnapshot(@NotNull VcsLogGraphTable table) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
        this.selectedCommits = (IntSet)new IntOpenHashSet();
        Object object2 = this.table.getSelectedRows();
        List list = ContainerUtil.sorted((Collection)Ints.asList((int[])Arrays.copyOf((int[])object2, ((int[])object2).length)));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sorted(...)");
        List selectedRows = list;
        Map selectedRowsToCommits = new LinkedHashMap();
        object2 = selectedRows.iterator();
        while (object2.hasNext()) {
            Integer row = (Integer)object2.next();
            GraphTableModel graphTableModel = this.table.getModel();
            Intrinsics.checkNotNull((Object)row);
            Integer n = graphTableModel.getId(row);
            if (n == null) {
                continue;
            }
            int commitId = n;
            object = commitId;
            selectedRowsToCommits.put(row, object);
            this.selectedCommits.add(commitId);
        }
        IntRange visibleRows = this.getVisibleRows((JTable)((Object)this.table));
        if (visibleRows == null) {
            this.isOnTop = false;
            this.scrollingTarget = null;
        } else {
            Object v3;
            block6: {
                this.isOnTop = visibleRows.getFirst() == 0;
                object = selectedRowsToCommits.keySet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    int it = ((Number)t).intValue();
                    boolean bl = false;
                    if (!visibleRows.contains(it)) continue;
                    v3 = t;
                    break block6;
                }
                v3 = null;
            }
            Integer n = v3;
            int visibleRow = n != null ? n.intValue() : visibleRows.getFirst();
            Integer n2 = (Integer)selectedRowsToCommits.get(visibleRow);
            if (n2 == null) {
                n2 = this.table.getModel().getId(visibleRow);
            }
            Integer visibleCommit = n2;
            this.scrollingTarget = new ScrollingTarget(visibleCommit, this.getTopGap(visibleRow));
        }
    }

    private final int getTopGap(int row) {
        return this.table.getCellRect((int)row, (int)0, (boolean)false).y - this.table.getVisibleRect().y;
    }

    private final IntRange getVisibleRows(JTable table) {
        Couple couple = ScrollingUtil.getVisibleRows((JTable)table);
        Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"getVisibleRows(...)");
        Couple visibleRows = couple;
        Object object = visibleRows.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
        int n = ((Number)object).intValue();
        Object object2 = visibleRows.second;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
        IntRange range = new IntRange(n, ((Number)object2).intValue());
        if (range.isEmpty() || range.getFirst() < 0) {
            return null;
        }
        return range;
    }

    public final void restore(@NotNull VisibleGraph<Integer> graph, boolean scroll, boolean permanentGraphChanged) {
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        boolean scrollToTop = this.isOnTop && permanentGraphChanged;
        Map<Integer, Integer> commitsToRows = this.mapCommitsToRows(graph, scroll && !scrollToTop);
        this.table.getSelectionModel().setValueIsAdjusting(true);
        this.selectedCommits.forEach(arg_0 -> SelectionSnapshot.restore$lambda$1(commitsToRows, this, arg_0));
        this.table.getSelectionModel().setValueIsAdjusting(false);
        if (scroll) {
            Integer scrollingTargetRow;
            if (scrollToTop) {
                this.scrollToRow(0, 0);
            } else if (this.scrollingTarget != null && (scrollingTargetRow = commitsToRows.get(this.scrollingTarget.getCommit())) != null) {
                this.scrollToRow(scrollingTargetRow, this.scrollingTarget.getTopGap());
            }
        }
    }

    private final Map<Integer, Integer> mapCommitsToRows(VisibleGraph<Integer> graph, boolean scroll) {
        Set commits = new LinkedHashSet();
        commits.addAll((Collection)this.selectedCommits);
        if (scroll && this.scrollingTarget != null && this.scrollingTarget.getCommit() != null) {
            commits.add(this.scrollingTarget.getCommit());
        }
        return this.mapCommitsToRows(commits, graph);
    }

    private final Map<Integer, Integer> mapCommitsToRows(Collection<Integer> commits, VisibleGraph<Integer> graph) {
        Map commitsToRows = new LinkedHashMap();
        int n = graph.getVisibleCommitCount();
        for (int row = 0; row < n; ++row) {
            Object object = graph.getRowInfo(row).getCommit();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCommit(...)");
            int commit = ((Number)object).intValue();
            if (commits.remove(commit)) {
                Integer n2 = commit;
                Integer n3 = row;
                commitsToRows.put(n2, n3);
            }
            if (commits.isEmpty()) break;
        }
        return commitsToRows;
    }

    private final void scrollToRow(Integer row, Integer delta) {
        JScrollPane scrollPane;
        JScrollPane jScrollPane = scrollPane = (JScrollPane)ComponentUtil.getParentOfType(JScrollPane.class, (Component)((Component)((Object)this.table)));
        if (jScrollPane != null) {
            jScrollPane.validate();
        }
        Integer n = row;
        Intrinsics.checkNotNull((Object)n);
        Rectangle startRect = this.table.getCellRect(n, 0, true);
        int n2 = startRect.x;
        int n3 = startRect.y;
        Integer n4 = delta;
        Intrinsics.checkNotNull((Object)n4);
        this.table.scrollRectToVisible(new Rectangle(n2, Math.max(n3 - n4, 0), startRect.width, this.table.getVisibleRect().height));
    }

    private static final void restore$lambda$1(Map $commitsToRows, SelectionSnapshot this$0, int commit) {
        Integer row = (Integer)$commitsToRows.get(commit);
        if (row != null) {
            this$0.table.addRowSelectionInterval(row, row);
        }
    }
}

