// Written by John Newbigin
// jn@it.swin.edu.au
// Copyright (c) 1999 John Newbigin
// Covered by the terms of the GPL.

// This is a huge string class
// that means char * with built in memory management

#include "tlist.h"
#include <string.h>


TList::TList()
{
	data      = 0;
	alloclen  = 0;
	allocsize = 256;
	stringlen = 0;
}

TList::~TList()
{
	if(alloclen > 0)
	{
		delete[] data;
	}
}

int TList::GrowMemory(int blocks)
{
	void **newstr = new void *[alloclen + allocsize];
	int newlen = alloclen + (blocks * allocsize);
	if(newstr)
	{
		if(data)
		{
			memcpy(newstr, data, sizeof(void *) * stringlen);
			delete[] data;
		}
		alloclen = newlen;
		data = newstr;
	}
	// else raise an exception!!!!!!!!
	return newlen;
}

int TList::add(void *obj)
{
	if(stringlen >= alloclen)
	{
		GrowMemory(1);
	}
	data[stringlen] = obj;
	stringlen++;
	return stringlen;
}

void *TList::get(int i)
{
	if(i >= 0 && i < stringlen)
	{
		return data[i];
	}
	else
	{
		return 0;
	}
}

int TList::clear()
{
	if(data)
	{
		data[0] = 0;
		stringlen = 0;
	}
	return stringlen;
}

int TList::count()
{
	return stringlen;
}

void *TList::getBase()
{
	return (void *)data;
}
