#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include "misc.h"

/*
   Allocate memory, and copy a given string, then return
   pointer.  If the string given is NULL, or blank, return
   an empty string.
*/
unsigned char *mstrdup(unsigned char *str)
{
  int len = 0;
  unsigned char *r = NULL;

  if ((!str) || (!(*str)))
     len = 1;

  else
     len = strlen(str);

  r = (unsigned char *)malloc(len + 1);
  if (r == NULL)
     return NULL;

  memset((unsigned char *)r, 0, (len + 1));

  /*
     Previously blank string
  */
  if ((!str) || (!(*str)))
     return r;
  
  memcpy((unsigned char *)r, (unsigned char *)str, len);

  return r;
}

