## @file
# Mde DSC include file for [LibraryClasses*] section of all Architectures.
#
# This file can be included to the [LibraryClasses*] section(s) of a platform DSC file
# by using "!include MdePkg/MdeLibs.dsc.inc" to specify the library instances
# of some EDKII basic/common library classes.
#
# Copyright (c) 2021 - 2024, Intel Corporation. All rights reserved.<BR>
#
#    SPDX-License-Identifier: BSD-2-Clause-Patent
#
##

[Defines]
!ifndef CUSTOM_STACK_CHECK_LIB
  # The DSC parser will set any unset macros to 0. Then, below when we check for STATIC or DYNAMIC, even if we couch
  # that in a !ifdef CUSTOM_STACK_CHECK_LIB, the parser will issue a warning that we are comparing a boolean (0) against
  # a string, which will always fail. So we set it to a dummy value here.
  DEFINE CUSTOM_STACK_CHECK_LIB = NONE
!endif

[LibraryClasses]
  OrderedCollectionLib|MdePkg/Library/BaseOrderedCollectionRedBlackTreeLib/BaseOrderedCollectionRedBlackTreeLib.inf
  ArmTrngLib|MdePkg/Library/BaseArmTrngLibNull/BaseArmTrngLibNull.inf
  RegisterFilterLib|MdePkg/Library/RegisterFilterLibNull/RegisterFilterLibNull.inf
  CpuLib|MdePkg/Library/BaseCpuLib/BaseCpuLib.inf
  SmmCpuRendezvousLib|MdePkg/Library/SmmCpuRendezvousLibNull/SmmCpuRendezvousLibNull.inf
  SafeIntLib|MdePkg/Library/BaseSafeIntLib/BaseSafeIntLib.inf
  SynchronizationLib|MdePkg/Library/BaseSynchronizationLib/BaseSynchronizationLib.inf
  MmUnblockMemoryLib|MdePkg/Library/MmUnblockMemoryLib/MmUnblockMemoryLibNull.inf
  StackCheckFailureHookLib|MdePkg/Library/StackCheckFailureHookLibNull/StackCheckFailureHookLibNull.inf
  FvLib|MdePkg/Library/FvLib/FvLib.inf

!if $(CUSTOM_STACK_CHECK_LIB) == STATIC
  # To only use the static stack cookie, we just include the checking functionality.
  StackCheckLib|MdePkg/Library/StackCheckLib/StackCheckLib.inf
!elseif $(CUSTOM_STACK_CHECK_LIB) == DYNAMIC
  StackCheckLib|MdePkg/Library/StackCheckLib/StackCheckLib.inf

  # To use the dynamic stack cookie, we need to include the entry point libraries that will set up the stack cookie.
  # Typically, PeiCore and PEIMs will not use dynamic stack cookies, so they are not included generally.
  # If dynamic stack cookies are not enabled, we do not setup the entry points, as the existing behavior was
  # for a platform to define them.
  # StandaloneMmCoreEntryPoint is not included here because support dynamic stack cookies is not available for
  # AARCH64 here. X64 platforms should include the DynamicStackCookieEntryPointLib in their DSC file.
  DxeCoreEntryPoint|MdePkg/Library/DynamicStackCookieEntryPointLib/DxeCoreEntryPoint.inf
  StandaloneMmDriverEntryPoint|MdePkg/Library/DynamicStackCookieEntryPointLib/StandaloneMmDriverEntryPoint.inf
  UefiApplicationEntryPoint|MdePkg/Library/DynamicStackCookieEntryPointLib/UefiApplicationEntryPoint.inf
  UefiDriverEntryPoint|MdePkg/Library/DynamicStackCookieEntryPointLib/UefiDriverEntryPoint.inf

!else
  # If CUSTOM_STACK_CHECK_LIB is set, MdeLibs.dsc.inc will not link StackCheckLibNull and it is expected that the
  # DSC being built is providing it's own implementation of StackCheckLib.
  StackCheckLib|MdePkg/Library/StackCheckLibNull/StackCheckLibNull.inf
!endif

[LibraryClasses.common.SEC, LibraryClasses.common.PEI_CORE]
  # edk2 does not implement exception handling for SEC and PEI_CORE, so StackCheckLibNull is used, as failing
  # stack cookies will generate an exception, which if unhandled can lead to a hung system state. If a platform
  # implements exception handling for SEC and PEI_CORE, it can use StackCheckLib for these phases in its DSC.
  StackCheckLib|MdePkg/Library/StackCheckLibNull/StackCheckLibNull.inf

[LibraryClasses.AARCH64]
  #
  # It is not possible to prevent the AARCH64 compilers from inserting generic intrinsic functions.
  # This library provides the intrinsic functions generated by these compilers.
  #
  # Linking this here as a null library will cause all AARCH64 files to link against it and have
  # definitions for the intrinsic functions.
  #
  NULL|MdePkg/Library/CompilerIntrinsicsLib/CompilerIntrinsicsLib.inf

[LibraryClasses.LOONGARCH64]
  #
  # Some LOONGARCH/LOONGARCH64 compilers may replace memory operations with libc functions to improve performance,
  # and there is no way to prevent the LOONGARCH/LOONGARCH64 compilers from inserting generic intrinsics.
  # This library provides the intrinsic functions generated by these compilers.
  #
  # Linking this here as a null library will cause all LOONGARCH/LOONGARCH64 files to link against it and have
  # definitions for the intrinsic functions.
  #
  NULL|MdePkg/Library/CompilerIntrinsicsLib/CompilerIntrinsicsLib.inf
