/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionFormBean;
import org.apache.struts.action.ActionFormBeans;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionForwards;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMappings;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ConfigHelperInterface;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.MessageResources;

public class ConfigHelper
implements ConfigHelperInterface {
    private ServletContext application = null;
    private HttpSession session = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private ActionForward forward = null;

    public void setApplication(ServletContext application) {
        this.application = application;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
        if (this.request == null) {
            this.setSession(null);
        } else {
            this.setSession(this.request.getSession());
        }
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setForward(ActionForward forward) {
        this.forward = forward;
    }

    public void setResources(ServletContext application, HttpServletRequest request, HttpServletResponse response) {
        this.setApplication(application);
        this.setRequest(request);
        this.setResponse(response);
    }

    public DataSource getDataSource() {
        if (this.application == null) {
            return null;
        }
        return (DataSource)this.application.getAttribute("org.apache.struts.action.DATA_SOURCE");
    }

    public ActionMessages getActionMessages() {
        if (this.application == null) {
            return null;
        }
        return (ActionMessages)this.application.getAttribute("org.apache.struts.action.ACTION_MESSAGE");
    }

    public ActionFormBeans getActionFormBeans() {
        if (this.application == null) {
            return null;
        }
        return (ActionFormBeans)this.application.getAttribute("org.apache.struts.action.FORM_BEANS");
    }

    public ActionForwards getActionForwards() {
        if (this.application == null) {
            return null;
        }
        return (ActionForwards)this.application.getAttribute("org.apache.struts.action.FORWARDS");
    }

    public ActionMappings getActionMappings() {
        if (this.application == null) {
            return null;
        }
        return (ActionMappings)this.application.getAttribute("org.apache.struts.action.MAPPINGS");
    }

    public MessageResources getMessageResources() {
        if (this.application == null) {
            return null;
        }
        return (MessageResources)this.application.getAttribute("org.apache.struts.action.MESSAGE");
    }

    public String getServletMapping() {
        if (this.application == null) {
            return null;
        }
        return (String)this.application.getAttribute("org.apache.struts.action.SERVLET_MAPPING");
    }

    public Locale getLocale() {
        Locale locale = null;
        if (this.session != null) {
            locale = (Locale)this.session.getAttribute("org.apache.struts.action.LOCALE");
        }
        if (locale == null && this.request != null) {
            locale = this.request.getLocale();
        }
        return locale;
    }

    public String getToken() {
        if (this.session == null) {
            return null;
        }
        return (String)this.session.getAttribute("org.apache.struts.action.TOKEN");
    }

    public ActionErrors getActionErrors() {
        if (this.request == null) {
            return null;
        }
        return (ActionErrors)this.request.getAttribute("org.apache.struts.action.ERROR");
    }

    public Throwable getException() {
        if (this.request == null) {
            return null;
        }
        return (Throwable)this.request.getAttribute("org.apache.struts.action.EXCEPTION");
    }

    public MultipartRequestWrapper getMultipartRequestWrapper() {
        if (this.request == null) {
            return null;
        }
        return (MultipartRequestWrapper)this.request.getAttribute("org.apache.struts.action.mapping.multipartclass");
    }

    public ActionMapping getMapping() {
        if (this.request == null) {
            return null;
        }
        return (ActionMapping)this.request.getAttribute("org.apache.struts.action.mapping.instance");
    }

    public boolean isMessage(String key) {
        MessageResources resources = this.getMessageResources();
        if (resources == null) {
            return false;
        }
        return resources.isPresent(this.getLocale(), key);
    }

    public ActionForm getActionForm() {
        ActionMapping mapping = this.getMapping();
        if (mapping == null) {
            return null;
        }
        String attribute = mapping.getAttribute();
        if (attribute == null) {
            return null;
        }
        ActionForm instance = null;
        instance = "request".equals(mapping.getScope()) ? (ActionForm)this.request.getAttribute(attribute) : (ActionForm)this.session.getAttribute(attribute);
        return instance;
    }

    public ActionFormBean getFormBean(String name) {
        ActionFormBeans formBeans = this.getActionFormBeans();
        if (formBeans == null) {
            return null;
        }
        return formBeans.findFormBean(name);
    }

    public ActionForward getActionForward(String name) {
        ActionForwards forwards = this.getActionForwards();
        if (forwards == null) {
            return null;
        }
        return forwards.findForward(name);
    }

    public ActionMapping getActionMapping(String path) {
        ActionMappings mappings = this.getActionMappings();
        if (mappings == null) {
            return null;
        }
        return mappings.findMapping(path);
    }

    public String getActionMappingName(String action) {
        String value = action;
        int question = action.indexOf("?");
        if (question >= 0) {
            value = value.substring(0, question);
        }
        int slash = value.lastIndexOf("/");
        int period = value.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            value = value.substring(0, period);
        }
        if (value.startsWith("/")) {
            return value;
        }
        return "/" + value;
    }

    public String getActionMappingURL(String action) {
        StringBuffer value = new StringBuffer(this.request.getContextPath());
        String servletMapping = this.getServletMapping();
        if (servletMapping != null) {
            String queryString = null;
            int question = action.indexOf("?");
            if (question >= 0) {
                queryString = action.substring(question);
            }
            String actionMapping = this.getActionMappingName(action);
            if (servletMapping.startsWith("*.")) {
                value.append(actionMapping);
                value.append(servletMapping.substring(1));
            } else if (servletMapping.endsWith("/*")) {
                value.append(servletMapping.substring(0, servletMapping.length() - 2));
                value.append(actionMapping);
            }
            if (queryString != null) {
                value.append(queryString);
            }
        } else {
            if (!action.startsWith("/")) {
                value.append("/");
            }
            value.append(action);
        }
        return value.toString();
    }

    public String getEncodeURL(String url) {
        if (this.session != null && this.response != null) {
            boolean redirect = false;
            if (this.forward != null) {
                redirect = this.forward.getRedirect();
            }
            if (redirect) {
                return this.response.encodeRedirectURL(url);
            }
            return this.response.encodeURL(url);
        }
        return url;
    }

    public String getOrigRef() {
        if (this.request == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        result.append(this.request.getScheme());
        result.append("://");
        result.append(this.request.getServerName());
        if (!("http".equals(this.request.getScheme()) && 80 == this.request.getServerPort() || "https".equals(this.request.getScheme()) && 443 == this.request.getServerPort())) {
            result.append(":");
            result.append(this.request.getServerPort());
        }
        result.append(this.request.getRequestURI());
        return result.toString();
    }

    public String getBaseRef() {
        if (this.request == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        result.append(this.request.getScheme());
        result.append("://");
        result.append(this.request.getServerName());
        if (!("http".equals(this.request.getScheme()) && 80 == this.request.getServerPort() || "https".equals(this.request.getScheme()) && 443 == this.request.getServerPort())) {
            result.append(":");
            result.append(this.request.getServerPort());
        }
        String path = null;
        path = this.forward == null ? this.request.getRequestURI() : this.request.getContextPath() + this.forward.getPath();
        result.append(path);
        return result.toString();
    }

    public String getLink(String name) {
        ActionForward forward = this.getActionForward(name);
        if (forward == null) {
            return null;
        }
        StringBuffer path = new StringBuffer(this.request.getContextPath());
        path.append(forward.getPath());
        return this.getEncodeURL(path.toString());
    }

    public String getMessage(String key) {
        MessageResources resources = this.getMessageResources();
        if (resources == null) {
            return null;
        }
        return resources.getMessage(this.getLocale(), key);
    }

    public String getMessage(String key, Object[] args) {
        MessageResources resources = this.getMessageResources();
        if (resources == null) {
            return null;
        }
        if (args == null) {
            return resources.getMessage(this.getLocale(), key);
        }
        return resources.getMessage(this.getLocale(), key, args);
    }

    public String getAction(String path) {
        return this.getEncodeURL(this.getActionMappingURL(path));
    }

    public int getErrorSize() {
        ActionErrors actionErrors = this.getActionErrors();
        if (actionErrors == null) {
            return 0;
        }
        return actionErrors.size();
    }

    public boolean getErrorsEmpty() {
        ActionErrors actionErrors = this.getActionErrors();
        if (actionErrors == null) {
            return false;
        }
        return actionErrors.isEmpty();
    }

    public Iterator getErrors() {
        ActionErrors actionErrors = this.getActionErrors();
        if (actionErrors == null) {
            return null;
        }
        return actionErrors.get();
    }

    public Iterator getErrors(String property) {
        ActionErrors actionErrors = this.getActionErrors();
        if (actionErrors == null) {
            return null;
        }
        return actionErrors.get(property);
    }

    public int getErrorSize(String property) {
        ActionErrors actionErrors = this.getActionErrors();
        if (actionErrors == null) {
            return 0;
        }
        return actionErrors.size(property);
    }

    public String getErrorOutput(String property) {
        ActionErrors errors = this.getActionErrors();
        if (errors == null || errors.isEmpty()) {
            return null;
        }
        boolean headerPresent = this.isMessage("errors.header");
        boolean footerPresent = this.isMessage("errors.footer");
        StringBuffer results = new StringBuffer();
        String message = null;
        if (headerPresent) {
            message = this.getMessage("errors.header");
        }
        Iterator reports = null;
        reports = property == null ? errors.get() : errors.get(property);
        boolean propertyMsgPresent = reports.hasNext();
        if (message != null && property == null || propertyMsgPresent) {
            results.append(message);
            results.append("\r\n");
        }
        while (reports.hasNext()) {
            ActionError report = (ActionError)reports.next();
            message = this.getMessage(report.getKey(), report.getValues());
            if (message == null) continue;
            results.append(message);
            results.append("\r\n");
        }
        message = null;
        if (footerPresent) {
            message = this.getMessage("errors.footer");
        }
        if (message != null && property == null || propertyMsgPresent) {
            results.append(message);
            results.append("\r\n");
        }
        return results.toString();
    }

    public String getErrorOutput() {
        return this.getErrorOutput(null);
    }

    public String link(String name) {
        return this.getLink(name);
    }

    public String message(String key) {
        return this.getMessage(key);
    }

    public String message(String key, Object[] args) {
        return this.getMessage(key, args);
    }

    public String action(String path) {
        return this.getAction(path);
    }

    public int errorSize() {
        return this.getErrorSize();
    }

    public boolean errorsEmpty() {
        return this.getErrorsEmpty();
    }

    public Iterator errors() {
        return this.errors();
    }

    public Iterator errors(String property) {
        return this.getErrors(property);
    }

    public int errorSize(String property) {
        return this.getErrorSize(property);
    }

    public String errorOutput(String property) {
        return this.getErrorOutput(property);
    }

    public String errorOutput() {
        return this.getErrorOutput();
    }

    public ConfigHelper() {
    }

    public ConfigHelper(ServletContext application, HttpServletRequest request, HttpServletResponse response) {
        this.setResources(application, request, response);
    }
}

