// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutObjectLockConfiguration`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket whose Object Lock configuration you want to create or replace.</p><br>
    ///   - [`object_lock_configuration(ObjectLockConfiguration)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::object_lock_configuration) / [`set_object_lock_configuration(Option<ObjectLockConfiguration>)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::set_object_lock_configuration):<br>required: **false**<br><p>The Object Lock configuration that you want to apply to the specified bucket.</p><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`token(impl Into<String>)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::token) / [`set_token(Option<String>)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::set_token):<br>required: **false**<br><p>A token to allow Object Lock to be enabled for an existing bucket.</p><br>
    ///   - [`content_md5(impl Into<String>)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::content_md5) / [`set_content_md5(Option<String>)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::set_content_md5):<br>required: **false**<br><p>The MD5 hash for the request body.</p> <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p><br>
    ///   - [`checksum_algorithm(ChecksumAlgorithm)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::checksum_algorithm) / [`set_checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::set_checksum_algorithm):<br>required: **false**<br><p>Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding <code>x-amz-checksum</code> or <code>x-amz-trailer</code> header sent. Otherwise, Amazon S3 fails the request with the HTTP status code <code>400 Bad Request</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you provide an individual checksum, Amazon S3 ignores any provided <code>ChecksumAlgorithm</code> parameter.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`PutObjectLockConfigurationOutput`](crate::operation::put_object_lock_configuration::PutObjectLockConfigurationOutput) with field(s):
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::put_object_lock_configuration::PutObjectLockConfigurationOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/RequesterPaysBuckets.html">Using Requester Pays buckets for storage transfers and usage</a> in the <i>Amazon Simple Storage Service user guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    /// - On failure, responds with [`SdkError<PutObjectLockConfigurationError>`](crate::operation::put_object_lock_configuration::PutObjectLockConfigurationError)
    pub fn put_object_lock_configuration(
        &self,
    ) -> crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder {
        crate::operation::put_object_lock_configuration::builders::PutObjectLockConfigurationFluentBuilder::new(self.handle.clone())
    }
}
