**Language Features:**
* linear_extrude now takes a scale parameter:
  linear_extrude(height=a, slices=b, twist=c, scale=[x,y])
* Recursive use of modules is now supported (including cascading child() operations):
  https://github.com/openscad/openscad/blob/master/examples/example024.scad
* Parameter list values can now depend on earlier values, e.g. for (i=[0:2], j=[0:i]) ..
* value assignments in parameters can now depend on already declared parameters
* Added resize() module: 
  http://en.wikibooks.org/wiki/OpenSCAD_User_Manual/Transformations#resize

**Program Features:**
* Added basic syntax highlighting in the editor
* There is now a built-in library path in user-space:
  http://en.wikibooks.org/wiki/OpenSCAD_User_Manual/Libraries#Library_Locations
* Commandline output to PNG, with various camera and rendering settings.        
  Run openscad -h to see usage info or see the OpenSCAD wiki user manual.
* Attempting to open dxf, off or stl files in the GUI will now create an import statement.
* The preview operator (%) will now preserve any manually set color
* The highlight operator (#) will now color the object in transparent red
* Mac: Added document icon
* Mac: Added auto-update check
* Windows: Better cmd-line support using the openscad.com executable

**Bugfixes:**
* Importing files is now always relative to the importing script, also for libraries
* We didn't always print a warning when CSG normalization created too many elements
* Binary STLs can now be read on big endian architectures
* Some binary STLs couldn't be read
* Fixed some issues related to ARM builds
* CGAL triangulation more lenient- enables partial rendering of 'bad' DXF data
* The Automatic Reload feature is now more robust
* If a file couldn't be saved it no longer fails silently
* Fixed a number of crashes related to CGAL and OpenCSG rendering or complex models
* The lookup() function had bad boundary condition behavior
* The surface() module failed when the .dat file lacked a trailing newline
* The hull() module could crash if any of the children were empty objects
* Some problems using unicode filenames have been fixed

**Misc:**
* Build scripts have been further improved
* Regression test now creates single monolithic .html file for easier uploading
* Regression test auto-starts & stops Xvfb / Xvnc if on headless unix machine
* The backend is finally independent of Qt
* Windows: We now have a 64-bit version

**Known Bugs:**
* Linux: command-line png rendering on Gallium is flaky. 
  Workaround: use CGAL --render or hardware rendering.

