/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'wake_up_new_task' function
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process forks, child must be tracked as well! We need to update RB tree.
 *
 * Caveats:
 *  - Previous version was hooking 'do_fork' function.
 *
 * Timeline:
 *  - Created: 18.IX.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_WAKE_UP_NEW_TASK_H
#define P_LKRG_EXPLOIT_DETECTION_WAKE_UP_NEW_TASK_H

/* per-instance private data */
struct p_wake_up_new_task_data {
    ktime_t entry_stamp;
};


int p_wake_up_new_task_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_wake_up_new_task_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_wake_up_new_task_hook(int p_isra);
void p_uninstall_wake_up_new_task_hook(void);

#endif
