/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'capable' function
 *
 * Notes:
 *  - Enforce Exploit Detection validation
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 22.III.2020
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_CAPABLE_H
#define P_LKRG_EXPLOIT_DETECTION_CAPABLE_H

/* per-instance private data */
struct p_capable_data {
    ktime_t entry_stamp;
};


int p_capable_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_capable_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_capable_hook(int p_isra);
void p_uninstall_capable_hook(void);

#endif
